/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.base.controller;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import top.tangyh.basic.annotation.log.WebLog;
import top.tangyh.basic.base.R;
import top.tangyh.basic.base.controller.BaseController;
import top.tangyh.basic.base.entity.SuperEntity;
import top.tangyh.basic.base.request.PageParams;
import top.tangyh.basic.database.mybatis.conditions.Wraps;
import top.tangyh.basic.database.mybatis.conditions.query.QueryWrap;
import top.tangyh.basic.interfaces.echo.EchoService;
import top.tangyh.basic.utils.BeanPlusUtil;

public interface PageController<Id extends Serializable, Entity extends SuperEntity<Id>, PageQuery, ResultVO>
extends BaseController<Id, Entity> {
    public Class<ResultVO> getResultVOClass();

    default public void handlerQueryParams(PageParams<PageQuery> params) {
    }

    default public IPage<Entity> query(PageParams<PageQuery> params) {
        this.handlerQueryParams(params);
        IPage page = params.buildPage(this.getEntityClass());
        SuperEntity model = (SuperEntity)BeanUtil.toBean(params.getModel(), this.getEntityClass());
        QueryWrap<SuperEntity> wrapper = this.handlerWrapper(model, params);
        this.getSuperService().page(page, (Wrapper<SuperEntity>)wrapper);
        return page;
    }

    default public QueryWrap<Entity> handlerWrapper(Entity model, PageParams<PageQuery> params) {
        return Wraps.q(model, params.getExtra(), this.getEntityClass());
    }

    default public EchoService getEchoService() {
        return null;
    }

    default public void handlerResult(IPage<ResultVO> page) {
        EchoService echoService = this.getEchoService();
        if (echoService != null) {
            echoService.action(page, new String[0]);
        }
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/page"})
    @WebLog(value="'\u5206\u9875\u5217\u8868\u67e5\u8be2:\u7b2c' + #params?.current + '\u9875, \u663e\u793a' + #params?.size + '\u884c'", response=false)
    default public R<IPage<ResultVO>> page(@RequestBody @Validated PageParams<PageQuery> params) {
        IPage<Entity> page = this.query(params);
        IPage voPage = BeanPlusUtil.toBeanPage(page, this.getResultVOClass());
        this.handlerResult(voPage);
        return this.success(voPage);
    }
}

