/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.base.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import top.tangyh.basic.base.entity.SuperEntity;
import top.tangyh.basic.base.manager.SuperManager;
import top.tangyh.basic.base.service.SuperService;
import top.tangyh.basic.utils.ArgumentAssert;
import top.tangyh.basic.utils.BeanPlusUtil;

public class SuperServiceImpl<M extends SuperManager<Entity>, Id extends Serializable, Entity extends SuperEntity<?>>
implements SuperService<Id, Entity> {
    @Autowired
    protected M superManager;
    protected Class<M> managerClass = this.currentManagerClass();
    protected Class<Entity> entityClass = this.currentModelClass();
    protected Class<Id> idClass = this.currentIdClass();

    public M getSuperManager() {
        return this.superManager;
    }

    @Override
    public Class<Entity> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public Class<Id> getIdClass() {
        return this.idClass;
    }

    protected Class<M> currentManagerClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), SuperServiceImpl.class, (int)0);
    }

    protected Class<Id> currentIdClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), SuperServiceImpl.class, (int)1);
    }

    protected Class<Entity> currentModelClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), SuperServiceImpl.class, (int)2);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <SaveVO> Entity save(SaveVO saveVO) {
        Entity entity = this.saveBefore(saveVO);
        this.getSuperManager().save(entity);
        this.saveAfter(saveVO, entity);
        return entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(List<Entity> entityList) {
        return this.getSuperManager().saveBatch(entityList);
    }

    protected <SaveVO> Entity saveBefore(SaveVO saveVO) {
        return (Entity)((SuperEntity)BeanUtil.toBean(saveVO, this.getEntityClass()));
    }

    protected <SaveVO> void saveAfter(SaveVO saveVO, Entity entity) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <UpdateVO> Entity updateById(UpdateVO updateVO) {
        Entity entity = this.updateBefore(updateVO);
        this.getSuperManager().updateById(entity);
        this.updateAfter(updateVO, entity);
        return entity;
    }

    protected <UpdateVO> Entity updateBefore(UpdateVO updateVO) {
        return (Entity)((SuperEntity)BeanUtil.toBean(updateVO, this.getEntityClass()));
    }

    protected <UpdateVO> void updateAfter(UpdateVO updateVO, Entity entity) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <UpdateVO> Entity updateAllById(UpdateVO updateVO) {
        Entity entity = this.updateAllBefore(updateVO);
        this.getSuperManager().updateAllById(entity);
        this.updateAllAfter(updateVO, entity);
        return entity;
    }

    protected <UpdateVO> Entity updateAllBefore(UpdateVO updateVO) {
        return (Entity)((SuperEntity)BeanUtil.toBean(updateVO, this.getEntityClass()));
    }

    protected <UpdateVO> void updateAllAfter(UpdateVO updateVO, Entity entity) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Entity copy(Id id) {
        Entity old = this.getById(id);
        ArgumentAssert.notNull(old, (String)"\u60a8\u8981\u590d\u5236\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5", (Object[])new Object[0]);
        SuperEntity entity = (SuperEntity)BeanPlusUtil.toBean(old, this.getEntityClass());
        entity.setId(null);
        this.superManager.save((Object)entity);
        return (Entity)entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeByIds(Collection<Id> idList) {
        return this.getSuperManager().removeByIds(idList);
    }

    @Override
    @Transactional(readOnly=true)
    public Entity getById(Id id) {
        return (Entity)((SuperEntity)this.getSuperManager().getById(id));
    }

    @Override
    @Transactional(readOnly=true)
    public List<Entity> list(Wrapper<Entity> queryWrapper) {
        return this.getSuperManager().list(queryWrapper);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Entity> listByIds(List<Id> ids) {
        return this.getSuperManager().listByIds(ids);
    }

    @Override
    @Transactional(readOnly=true)
    public <E extends IPage<Entity>> E page(E page, Wrapper<Entity> queryWrapper) {
        return (E)this.getSuperManager().page(page, queryWrapper);
    }
}

