/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.base.controller;

import cn.hutool.core.collection.CollUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import top.tangyh.basic.annotation.log.WebLog;
import top.tangyh.basic.base.R;
import top.tangyh.basic.base.controller.PageController;
import top.tangyh.basic.base.entity.SuperEntity;
import top.tangyh.basic.database.mybatis.conditions.Wraps;
import top.tangyh.basic.database.mybatis.conditions.query.QueryWrap;
import top.tangyh.basic.interfaces.echo.EchoService;
import top.tangyh.basic.utils.BeanPlusUtil;

public interface QueryController<Id extends Serializable, Entity extends SuperEntity<Id>, PageQuery, ResultVO>
extends PageController<Id, Entity, PageQuery, ResultVO> {
    @Parameters(value={@Parameter(name="id", description="\u4e3b\u952e", schema=@Schema(type="long"), in=ParameterIn.PATH)})
    @Operation(summary="\u5355\u4f53\u67e5\u8be2", description="\u5355\u4f53\u67e5\u8be2")
    @GetMapping(value={"/{id:[0-9]+}"})
    @WebLog(value="'\u67e5\u8be2:' + #id")
    default public R<ResultVO> get(@PathVariable Id id) {
        Object entity = this.getSuperService().getById(id);
        return this.success(BeanPlusUtil.toBean(entity, this.getResultVOClass()));
    }

    @Operation(summary="\u67e5\u8be2\u5355\u4f53\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    @WebLog(value="'\u67e5\u8be2:' + #id")
    default public R<ResultVO> getDetail(@RequestParam(value="id") Id id) {
        Object entity = this.getSuperService().getById(id);
        Object resultVO = BeanPlusUtil.toBean(entity, this.getResultVOClass());
        EchoService echoService = this.getEchoService();
        if (echoService != null) {
            echoService.action(resultVO, new String[0]);
        }
        return this.success(resultVO);
    }

    @Operation(summary="\u6279\u91cf\u67e5\u8be2", description="\u6279\u91cf\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @WebLog(value="\u6279\u91cf\u67e5\u8be2")
    default public R<List<ResultVO>> query(@RequestBody PageQuery data) {
        SuperEntity entity = (SuperEntity)BeanPlusUtil.toBean(data, this.getEntityClass());
        QueryWrap wrapper = Wraps.q((Object)entity);
        List list = this.getSuperService().list(wrapper);
        return this.success(BeanPlusUtil.toBeanList(list, this.getResultVOClass()));
    }

    @Operation(summary="\u6839\u636eId\u6279\u91cf\u67e5\u8be2", description="\u6839\u636eId\u6279\u91cf\u67e5\u8be2")
    @PostMapping(value={"/findByIds"})
    @WebLog(value="\u6839\u636eId\u6279\u91cf\u67e5\u8be2")
    default public R<List<ResultVO>> findByIds(@RequestBody List<Id> ids) {
        if (CollUtil.isEmpty(ids)) {
            return R.success(Collections.emptyList());
        }
        List list = this.getSuperService().listByIds(ids);
        return this.success(BeanPlusUtil.toBeanList(list, this.getResultVOClass()));
    }
}

