/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.base.controller;

import io.swagger.v3.oas.annotations.Operation;
import java.io.Serializable;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import top.tangyh.basic.annotation.log.WebLog;
import top.tangyh.basic.base.R;
import top.tangyh.basic.base.controller.SuperController;
import top.tangyh.basic.base.entity.SuperEntity;
import top.tangyh.basic.base.service.SuperCacheService;
import top.tangyh.basic.utils.BeanPlusUtil;

public abstract class SuperCacheController<S extends SuperCacheService<Id, Entity>, Id extends Serializable, Entity extends SuperEntity<Id>, SaveVO, UpdateVO, PageQuery, ResultVO>
extends SuperController<S, Id, Entity, SaveVO, UpdateVO, PageQuery, ResultVO> {
    @Override
    public SuperCacheService<Id, Entity> getSuperService() {
        return (SuperCacheService)this.superService;
    }

    @Override
    @WebLog(value="'\u67e5\u8be2:' + #id")
    public R<ResultVO> get(@PathVariable Id id) {
        Object entity = this.getSuperService().getByIdCache(id);
        return this.success(BeanPlusUtil.toBean(entity, this.getResultVOClass()));
    }

    @Operation(summary="\u5237\u65b0\u7f13\u5b58", description="\u5237\u65b0\u7f13\u5b58")
    @PostMapping(value={"refreshCache"})
    @WebLog(value="\u5237\u65b0\u7f13\u5b58")
    public R<Boolean> refreshCache(@RequestBody List<Long> ids) {
        this.getSuperService().refreshCache(ids);
        return this.success(true);
    }

    @Operation(summary="\u6e05\u7406\u7f13\u5b58", description="\u6e05\u7406\u7f13\u5b58")
    @PostMapping(value={"clearCache"})
    @WebLog(value="\u6e05\u7406\u7f13\u5b58")
    public R<Boolean> clearCache(@RequestBody List<Long> ids) {
        this.getSuperService().clearCache(ids);
        return this.success(true);
    }
}

