/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.security.permission;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import top.tangyh.basic.utils.CollHelper;

public class WildcardPermission
implements Serializable {
    protected static final String WILDCARD_TOKEN = "*";
    protected static final String PART_DIVIDER_TOKEN = ":";
    protected static final String SUBPART_DIVIDER_TOKEN = ",";
    private List<Set<String>> parts;

    public WildcardPermission(String wildcardString, boolean caseSensitive) {
        this.init(wildcardString, caseSensitive);
    }

    protected List<Set<String>> getParts() {
        return this.parts;
    }

    protected void init(String wildcardString, boolean caseSensitive) {
        if (wildcardString == null || wildcardString.trim().length() == 0) {
            throw new IllegalArgumentException("\u6743\u9650\u7f16\u7801\u901a\u914d\u7b26\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3anull\u6216\u7a7a\u3002\u786e\u4fdd\u6743\u9650\u5b57\u7b26\u4e32\u7684\u683c\u5f0f\u6b63\u786e\u3002");
        }
        wildcardString = wildcardString.trim();
        List parts = CollHelper.asList((Object[])wildcardString.split(PART_DIVIDER_TOKEN));
        this.parts = new ArrayList<Set<String>>();
        for (String part : parts) {
            Set<String> subParts = CollHelper.asSet((Object[])part.split(SUBPART_DIVIDER_TOKEN));
            if (!caseSensitive) {
                subParts = this.lowercase(subParts);
            }
            if (subParts.isEmpty()) {
                throw new IllegalArgumentException("\u6743\u9650\u7f16\u7801\u901a\u914d\u7b26\u5b57\u7b26\u4e32\u4e0d\u80fd\u5305\u542b\u53ea\u6709\u5206\u9694\u7b26\u7684\u90e8\u5206\uff0c\u786e\u4fdd\u6743\u9650\u7f16\u7801\u5b57\u7b26\u4e32\u7684\u683c\u5f0f\u6b63\u786e\u3002");
            }
            this.parts.add(subParts);
        }
        if (this.parts.isEmpty()) {
            throw new IllegalArgumentException("\u6743\u9650\u7f16\u7801\u901a\u914d\u7b26\u5b57\u7b26\u4e32\u4e0d\u80fd\u53ea\u5305\u542b\u5206\u9694\u7b26\uff0c\u786e\u4fdd\u6743\u9650\u7f16\u7801\u5b57\u7b26\u4e32\u7684\u683c\u5f0f\u6b63\u786e\u3002");
        }
    }

    private Set<String> lowercase(Set<String> subParts) {
        LinkedHashSet<String> lowerCasedSubParts = new LinkedHashSet<String>(subParts.size());
        for (String subpart : subParts) {
            lowerCasedSubParts.add(subpart.toLowerCase());
        }
        return lowerCasedSubParts;
    }

    public boolean implies(WildcardPermission wp) {
        List<Set<String>> otherParts = wp.getParts();
        int i = 0;
        for (Set<String> otherPart : otherParts) {
            if (this.getParts().size() - 1 < i) {
                return true;
            }
            Set<String> part = this.getParts().get(i);
            if (!part.contains(WILDCARD_TOKEN) && !part.containsAll(otherPart)) {
                return false;
            }
            ++i;
        }
        while (i < this.getParts().size()) {
            Set<String> part = this.getParts().get(i);
            if (!part.contains(WILDCARD_TOKEN)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Set<String> part : this.parts) {
            if (buffer.length() > 0) {
                buffer.append(PART_DIVIDER_TOKEN);
            }
            buffer.append(part);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof WildcardPermission) {
            WildcardPermission wp = (WildcardPermission)o;
            return this.parts.equals(wp.parts);
        }
        return false;
    }

    public int hashCode() {
        return this.parts.hashCode();
    }
}

