/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.security.aspect;

import cn.hutool.core.collection.CollUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import top.tangyh.basic.base.R;
import top.tangyh.basic.security.feign.UserQuery;
import top.tangyh.basic.security.feign.UserResolverService;
import top.tangyh.basic.security.model.SysRole;
import top.tangyh.basic.security.model.SysUser;
import top.tangyh.basic.security.permission.AuthorizingRealm;
import top.tangyh.basic.security.properties.SecurityProperties;

public class VerifyAuthFunction {
    private final UserResolverService userResolverService;
    private final SecurityProperties securityProperties;

    public VerifyAuthFunction(UserResolverService userResolverService, SecurityProperties securityProperties) {
        this.userResolverService = userResolverService;
        this.securityProperties = securityProperties;
    }

    public boolean permit() {
        return true;
    }

    public boolean denyAll() {
        return this.hasAnyRole("SUPER_ADMIN");
    }

    public boolean hasAnyPermission(String ... permit) {
        Set<String> resources = this.getAllResources();
        return AuthorizingRealm.hasAnyPermission(resources, permit, this.securityProperties.getCaseSensitive());
    }

    public boolean hasNoPermission(String ... permit) {
        Set<String> resources = this.getAllResources();
        return AuthorizingRealm.hasNoPermission(resources, permit, this.securityProperties.getCaseSensitive());
    }

    public boolean hasPermission(String ... permit) {
        Set<String> resources = this.getAllResources();
        return AuthorizingRealm.hasAllPermission(resources, permit, this.securityProperties.getCaseSensitive());
    }

    @NonNull
    private Set<String> getAllResources() {
        HashSet<String> resources = new HashSet<String>();
        R<SysUser> result = this.userResolverService.getById(UserQuery.buildResource());
        if (result.getIsSuccess().booleanValue() && result.getData() != null && ((SysUser)result.getData()).getResources() != null) {
            SysUser sysUser = (SysUser)result.getData();
            resources = new HashSet<String>(sysUser.getResources());
        }
        return resources;
    }

    public boolean hasAnyRole(String ... role) {
        Set<String> roles = this.getAllRoles();
        return CollUtil.containsAny(roles, (Collection)CollUtil.newHashSet((Object[])role));
    }

    public boolean hasRole(String ... role) {
        Set<String> roles = this.getAllRoles();
        return CollUtil.containsAll(roles, (Collection)CollUtil.newHashSet((Object[])role));
    }

    public boolean hasNoRole(String ... role) {
        return !this.hasRole(role);
    }

    @NonNull
    private Set<String> getAllRoles() {
        Set<String> roles = new HashSet<String>();
        R<SysUser> result = this.userResolverService.getById(UserQuery.buildRoles());
        if (result.getIsSuccess().booleanValue() && result.getData() != null && ((SysUser)result.getData()).getRoles() != null) {
            SysUser sysUser = (SysUser)result.getData();
            roles = sysUser.getRoles().stream().map(SysRole::getCode).collect(Collectors.toSet());
        }
        return roles;
    }
}

