/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.security.resolver;

import cn.hutool.core.util.BooleanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import top.tangyh.basic.annotation.user.LoginUser;
import top.tangyh.basic.base.R;
import top.tangyh.basic.context.ContextUtil;
import top.tangyh.basic.security.feign.UserQuery;
import top.tangyh.basic.security.feign.UserResolverService;
import top.tangyh.basic.security.model.SysUser;
import top.tangyh.basic.utils.SpringUtils;

public class ContextArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(ContextArgumentResolver.class);

    public boolean supportsParameter(MethodParameter mp) {
        return mp.hasParameterAnnotation(LoginUser.class) && mp.getParameterType().equals(SysUser.class);
    }

    public Object resolveArgument(@NonNull MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, @NonNull NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) {
        Long userId = ContextUtil.getUserId();
        String account = ContextUtil.getAccount();
        String name = ContextUtil.getName();
        SysUser user = SysUser.builder().id(userId).account(account).name(name).build();
        if (userId == null) {
            return user;
        }
        try {
            UserResolverService userResolverService;
            R<SysUser> result;
            LoginUser loginUser = (LoginUser)methodParameter.getParameterAnnotation(LoginUser.class);
            boolean isQuery = BooleanUtil.or((boolean[])new boolean[]{loginUser.isFull(), loginUser.isStation(), loginUser.isOrg(), loginUser.isRoles(), loginUser.isResource()});
            if (isQuery && (result = (userResolverService = (UserResolverService)SpringUtils.getBean(UserResolverService.class)).getById(userId, UserQuery.builder().full(loginUser.isFull()).org(loginUser.isOrg()).station(loginUser.isStation()).roles(loginUser.isRoles()).resource(loginUser.isResource()).build())).getIsSuccess().booleanValue() && result.getData() != null) {
                return result.getData();
            }
        }
        catch (Exception e) {
            log.warn("\u6ce8\u5165\u767b\u5f55\u4eba\u4fe1\u606f\u65f6\uff0c\u53d1\u751f\u5f02\u5e38. --> {}", (Object)user, (Object)e);
        }
        return user;
    }
}

