/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.security.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import top.tangyh.basic.security.permission.WildcardPermission;

public class AuthorizingRealm {
    public static boolean isPermitted(Collection<WildcardPermission> perms, String permission, boolean caseSensitive) {
        return AuthorizingRealm.isPermitted(perms, new WildcardPermission(permission, caseSensitive));
    }

    private static boolean isPermitted(Collection<WildcardPermission> perms, WildcardPermission permission) {
        if (perms == null || perms.isEmpty()) {
            return false;
        }
        return perms.parallelStream().anyMatch(perm -> perm.implies(permission));
    }

    public static boolean hasAllPermission(Collection<String> allPermissions, String[] permissions, boolean caseSensitive) {
        if (permissions != null && permissions.length > 0) {
            Collection allPerms = allPermissions.parallelStream().map(perm -> new WildcardPermission((String)perm, caseSensitive)).collect(Collectors.toList());
            return Arrays.stream(permissions).allMatch(perm -> AuthorizingRealm.isPermitted(allPerms, perm, caseSensitive));
        }
        return false;
    }

    public static boolean hasAnyPermission(Collection<String> allPermissions, String[] permissions, boolean caseSensitive) {
        if (permissions != null && permissions.length > 0) {
            Collection allPerms = allPermissions.parallelStream().map(perm -> new WildcardPermission((String)perm, caseSensitive)).collect(Collectors.toList());
            return Arrays.stream(permissions).anyMatch(perm -> AuthorizingRealm.isPermitted(allPerms, perm, caseSensitive));
        }
        return false;
    }

    public static boolean hasNoPermission(Collection<String> allPermissions, String[] permissions, boolean caseSensitive) {
        if (permissions != null && permissions.length > 0) {
            Collection allPerms = allPermissions.parallelStream().map(perm -> new WildcardPermission((String)perm, caseSensitive)).collect(Collectors.toList());
            return Arrays.stream(permissions).noneMatch(perm -> AuthorizingRealm.isPermitted(allPerms, perm, caseSensitive));
        }
        return false;
    }

    public static void main(String[] args) {
        ArrayList<String> perms = new ArrayList<String>();
        perms.add("authority:user:*");
        perms.add("authority:org:add");
        perms.add("authority:*:view");
        perms.add("authority:station:add,view");
        String[] noTrue = new String[]{"authority:org:delete", "authority:station:delete"};
        String[] noFalse = new String[]{"authority:user:add", "authority:aaa:vvv"};
        String[] andTrue = new String[]{"authority:org:add", "authority:station:add", "authority:station:view"};
        String[] andFalse = new String[]{"authority:org:add", "authority:org:edit"};
        String[] anyTrue = new String[]{"authority:user:add", "authority:org:edit"};
        String[] anyFalse = new String[]{"authority:org:delete", "authority:station:delete"};
        System.out.println(AuthorizingRealm.hasNoPermission(perms, noTrue, false));
        System.out.println(AuthorizingRealm.hasNoPermission(perms, noFalse, false));
        System.out.println(AuthorizingRealm.hasAllPermission(perms, noTrue, false));
        System.out.println(AuthorizingRealm.hasAllPermission(perms, noFalse, false));
        System.out.println(AuthorizingRealm.hasAllPermission(perms, andTrue, false));
        System.out.println(AuthorizingRealm.hasAllPermission(perms, andFalse, false));
        System.out.println(AuthorizingRealm.hasAnyPermission(perms, anyTrue, false));
        System.out.println(AuthorizingRealm.hasAnyPermission(perms, anyFalse, false));
    }
}

