/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.validator.mateconstraint.impl;

import cn.hutool.core.map.MapUtil;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import top.tangyh.basic.validator.mateconstraint.IConstraintConverter;
import top.tangyh.basic.validator.model.ConstraintInfo;

public abstract class BaseConstraintConverter
implements IConstraintConverter {
    private final List<String> methods = Collections.emptyList();

    @Override
    public boolean support(Class<? extends Annotation> clazz) {
        if (this.getSupport().isEmpty()) {
            return true;
        }
        return clazz != null && this.getSupport().contains(clazz);
    }

    @Override
    public ConstraintInfo converter(Annotation ano) throws Exception {
        Class<?> clazz = ano.getClass();
        HashMap attr = MapUtil.newHashMap();
        for (String method : this.getMethods()) {
            Object value = clazz.getMethod(method, new Class[0]).invoke((Object)ano, new Object[0]);
            attr.put(method, value);
        }
        return new ConstraintInfo().setType(this.getType(ano.annotationType())).setAttrs(attr);
    }

    protected abstract List<Class<? extends Annotation>> getSupport();

    protected List<String> getMethods() {
        return this.methods;
    }

    protected abstract String getType(Class<? extends Annotation> var1);
}

