/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.validator.constraintvalidators;

import cn.hutool.core.util.StrUtil;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.invoke.MethodHandles;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import org.hibernate.validator.internal.engine.messageinterpolation.util.InterpolationHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import top.tangyh.basic.annotation.constraints.NotEmptyPattern;

public class NotEmptyPatternConstraintValidator
implements ConstraintValidator<NotEmptyPattern, CharSequence> {
    private static final Log LOG = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private Pattern pattern;
    private String escapedRegexp;

    public void initialize(NotEmptyPattern parameters) {
        NotEmptyPattern.Flag[] flags = parameters.flags();
        int intFlag = 0;
        for (NotEmptyPattern.Flag flag : flags) {
            intFlag |= flag.getValue();
        }
        try {
            this.pattern = Pattern.compile(parameters.regexp(), intFlag);
        }
        catch (PatternSyntaxException e) {
            throw LOG.getInvalidRegularExpressionException(e);
        }
        this.escapedRegexp = InterpolationHelper.escapeMessageParameter((String)parameters.regexp());
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext constraintValidatorContext) {
        if (StrUtil.isEmpty((CharSequence)value)) {
            return true;
        }
        if (constraintValidatorContext instanceof HibernateConstraintValidatorContext) {
            ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("regexp", (Object)this.escapedRegexp);
        }
        Matcher m = this.pattern.matcher(value);
        return m.matches();
    }
}

