/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.xss.wrapper;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.xss.utils.XssUtils;

public class XssRequestWrapper
extends HttpServletRequestWrapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XssRequestWrapper.class);
    private final List<String> ignoreParamValueList;

    public XssRequestWrapper(HttpServletRequest request, List<String> ignoreParamValueList) {
        super(request);
        this.ignoreParamValueList = ignoreParamValueList;
    }

    public Map<String, String[]> getParameterMap() {
        Map requestMap = super.getParameterMap();
        for (Map.Entry me : requestMap.entrySet()) {
            log.debug((String)me.getKey() + ":");
            String[] values = (String[])me.getValue();
            for (int i = 0; i < values.length; ++i) {
                log.debug(values[i]);
                values[i] = XssUtils.xssClean(values[i], this.ignoreParamValueList);
            }
        }
        return requestMap;
    }

    public String getQueryString() {
        String queryString = super.getQueryString();
        try {
            if (queryString != null) {
                queryString = URLDecoder.decode(queryString, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.warn("getQueryString", (Throwable)e);
        }
        return XssUtils.xssClean(queryString, this.ignoreParamValueList);
    }

    public String[] getParameterValues(String paramString) {
        String[] arrayOfString1 = super.getParameterValues(paramString);
        if (arrayOfString1 == null) {
            return null;
        }
        int i = arrayOfString1.length;
        String[] arrayOfString2 = new String[i];
        for (int j = 0; j < i; ++j) {
            arrayOfString2[j] = XssUtils.xssClean(arrayOfString1[j], this.ignoreParamValueList, paramString);
        }
        return arrayOfString2;
    }

    public String getParameter(String paramString) {
        String str = super.getParameter(paramString);
        if (str == null) {
            return null;
        }
        return XssUtils.xssClean(str, this.ignoreParamValueList);
    }

    public String getHeader(String paramString) {
        String str = super.getHeader(paramString);
        if (str == null) {
            return null;
        }
        return XssUtils.xssClean(str, this.ignoreParamValueList);
    }
}

