/*
 * Decompiled with CFR 0.152.
 */
package top.tanmw.db2dict;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tanmw.db2dict.db.DbConfig;
import top.tanmw.db2dict.db.DbConfigFactory;
import top.tanmw.db2dict.entity.DbConstant;
import top.tanmw.db2dict.entity.DbEnum;
import top.tanmw.db2dict.entity.TableInfo;
import top.tanmw.db2dict.word.WordConfig;
import top.tanmw.db2dict.word.WordUtil;

public class Application {
    private static final Logger log = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) throws Exception {
        Properties prop = Application.getProp();
        if (Objects.isNull(prop)) {
            return;
        }
        DbConfig dbConfig = DbConfigFactory.getDbConfig();
        dbConfig.init(prop);
        List<TableInfo> tableList = dbConfig.getTableList();
        WordUtil wordUtil = new WordUtil();
        wordUtil.writeTableToWord(tableList);
    }

    public static void run(String url) throws Exception {
        Properties prop = Application.getProperties(url);
        if (Objects.isNull(prop)) {
            return;
        }
        DbConfig dbConfig = DbConfigFactory.getDbConfig();
        dbConfig.init(prop);
        List<TableInfo> tableList = dbConfig.getTableList();
        WordUtil wordUtil = new WordUtil();
        wordUtil.writeTableToWord(tableList);
    }

    public static Properties getProperties(String url) throws Exception {
        Properties properties = new Properties();
        File file = new File(url);
        FileInputStream in = new FileInputStream(file);
        properties.load(in);
        return properties;
    }

    public static Properties getProp() {
        Properties properties = new Properties();
        try {
            log.info("...\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6...");
            String configPath = Application.class.getClassLoader().getResource("dbconfig.txt").getPath();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configPath));
            properties.load(bufferedReader);
            DbConfigFactory.dbEnum = DbEnum.getDbEnum(properties.getProperty(DbConstant.TYPE));
            WordConfig.EXPORT_FILE_PATH = properties.getProperty(DbConstant.EXPORT_PATH);
            return properties;
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

