/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.hook.DefaultShutdownHook;
import ch.qos.logback.core.hook.ShutdownHookBase;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ShutdownHookModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.DynamicClassLoadingException;
import ch.qos.logback.core.util.IncompatibleClassException;
import ch.qos.logback.core.util.OptionHelper;

public class ShutdownHookModelHandler
extends ModelHandlerBase {
    public ShutdownHookModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        return new ShutdownHookModelHandler(context);
    }

    protected Class<ShutdownHookModel> getSupportedModelClass() {
        return ShutdownHookModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext interpretationContext, Model model) {
        ShutdownHookModel shutdownHookModel = (ShutdownHookModel)model;
        String className = shutdownHookModel.getClassName();
        if (OptionHelper.isNullOrEmpty(className)) {
            className = DefaultShutdownHook.class.getName();
            this.addInfo("Assuming className [" + className + "]");
        } else {
            className = interpretationContext.getImport(className);
        }
        this.addInfo("About to instantiate shutdown hook of type [" + className + "]");
        ShutdownHookBase hook = null;
        try {
            hook = (ShutdownHookBase)OptionHelper.instantiateByClassName(className, ShutdownHookBase.class, this.context);
            hook.setContext(this.context);
        }
        catch (DynamicClassLoadingException | IncompatibleClassException e2) {
            this.addError("Could not create a shutdown hook of type [" + className + "].", e2);
        }
        if (hook == null) {
            return;
        }
        Thread hookThread = new Thread((Runnable)hook, "Logback shutdown hook [" + this.context.getName() + "]");
        this.addInfo("Registeting shuthown hook with JVM runtime.");
        this.context.putObject("SHUTDOWN_HOOK", hookThread);
        Runtime.getRuntime().addShutdownHook(hookThread);
    }
}

