/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;
import com.graphbuilder.curve.ValueVector;

public class BSpline
extends ParametricCurve {
    public static final int UNIFORM_CLAMPED = 0;
    public static final int UNIFORM_UNCLAMPED = 1;
    public static final int NON_UNIFORM = 2;
    private static final ThreadLocal<SharedData> SHARED_DATA = new ThreadLocal<SharedData>(){

        @Override
        protected SharedData initialValue() {
            return new SharedData();
        }
    };
    private final SharedData sharedData = SHARED_DATA.get();
    private ValueVector knotVector = new ValueVector(new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0}, 8);
    private double t_min = 0.0;
    private double t_max = 1.0;
    private int sampleLimit = 1;
    private int degree = 4;
    private int knotVectorType = 0;
    private boolean useDefaultInterval = true;

    public BSpline(ControlPath cp, GroupIterator gi) {
        super(cp, gi);
    }

    @Override
    protected void eval(double[] p2) {
        int dim = p2.length - 1;
        double t2 = p2[dim];
        int numPts = this.gi.getGroupSize();
        this.gi.set(0, 0);
        for (int i2 = 0; i2 < numPts; ++i2) {
            double w2 = this.N(t2, i2);
            double[] loc = this.cp.getPoint(this.gi.next()).getLocation();
            for (int j2 = 0; j2 < dim; ++j2) {
                int n2 = j2;
                p2[n2] = p2[n2] + loc[j2] * w2;
            }
        }
    }

    public void setInterval(double t_min, double t_max) {
        if (t_min > t_max) {
            throw new IllegalArgumentException("t_min <= t_max required.");
        }
        this.t_min = t_min;
        this.t_max = t_max;
    }

    public double t_min() {
        return this.t_min;
    }

    public double t_max() {
        return this.t_max;
    }

    @Override
    public int getSampleLimit() {
        return this.sampleLimit;
    }

    public void setSampleLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Sample-limit >= 0 required.");
        }
        this.sampleLimit = limit;
    }

    public int getDegree() {
        return this.degree - 1;
    }

    public void setDegree(int d2) {
        if (d2 <= 0) {
            throw new IllegalArgumentException("Degree > 0 required.");
        }
        this.degree = d2 + 1;
    }

    public ValueVector getKnotVector() {
        return this.knotVector;
    }

    public void setKnotVector(ValueVector v2) {
        if (v2 == null) {
            throw new IllegalArgumentException("Knot-vector cannot be null.");
        }
        this.knotVector = v2;
    }

    public boolean getUseDefaultInterval() {
        return this.useDefaultInterval;
    }

    public void setUseDefaultInterval(boolean b2) {
        this.useDefaultInterval = b2;
    }

    public int getKnotVectorType() {
        return this.knotVectorType;
    }

    public void setKnotVectorType(int type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("Unknown knot-vector type.");
        }
        this.knotVectorType = type;
    }

    @Override
    public void appendTo(MultiPath mp) {
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("Group iterator not in range");
        }
        int numPts = this.gi.getGroupSize();
        int f2 = numPts - this.degree;
        if (f2 < 0) {
            throw new IllegalArgumentException("group iterator size - degree < 0");
        }
        int x2 = numPts + this.degree;
        if (this.sharedData.knot.length < x2) {
            SharedData.access$102(this.sharedData, new double[2 * x2]);
        }
        double t1 = this.t_min;
        double t2 = this.t_max;
        if (this.knotVectorType == 2) {
            if (this.knotVector.size() != x2) {
                throw new IllegalArgumentException("knotVector.size(" + this.knotVector.size() + ") != " + x2);
            }
            ((SharedData)this.sharedData).knot[0] = this.knotVector.get(0);
            for (int i2 = 1; i2 < x2; ++i2) {
                ((SharedData)this.sharedData).knot[i2] = this.knotVector.get(i2);
                if (!(this.sharedData.knot[i2] < this.sharedData.knot[i2 - 1])) continue;
                throw new IllegalArgumentException("Knot not in sorted order! (knot[" + i2 + "] < knot[" + i2 + "-1])");
            }
        } else if (this.knotVectorType == 1) {
            double grad = 1.0 / (double)(x2 - 1);
            for (int i3 = 0; i3 < x2; ++i3) {
                ((SharedData)this.sharedData).knot[i3] = (double)i3 * grad;
            }
            if (this.useDefaultInterval) {
                t1 = (double)(this.degree - 1) * grad;
                t2 = 1.0 - (double)(this.degree - 1) * grad;
            }
        } else if (this.knotVectorType == 0) {
            int i4;
            double grad = 1.0 / (double)(f2 + 1);
            for (int i5 = 0; i5 < this.degree; ++i5) {
                ((SharedData)this.sharedData).knot[i5] = 0.0;
            }
            int j2 = this.degree;
            for (i4 = 1; i4 <= f2; ++i4) {
                ((SharedData)this.sharedData).knot[j2++] = (double)i4 * grad;
            }
            for (i4 = j2; i4 < x2; ++i4) {
                ((SharedData)this.sharedData).knot[i4] = 1.0;
            }
            if (this.useDefaultInterval) {
                t1 = 0.0;
                t2 = 1.0;
            }
        }
        if (this.sharedData.a.length < this.degree) {
            SharedData.access$202(this.sharedData, new int[2 * this.degree]);
            SharedData.access$302(this.sharedData, new int[2 * this.degree]);
        }
        double[] p2 = new double[mp.getDimension() + 1];
        p2[mp.getDimension()] = t1;
        this.eval(p2);
        if (this.connect) {
            mp.lineTo(p2);
        } else {
            mp.moveTo(p2);
        }
        BinaryCurveApproximationAlgorithm.genPts(this, t1, t2, mp);
    }

    protected double N(double t2, int i2) {
        double d2 = 0.0;
        block0: for (int j2 = 0; j2 < this.degree; ++j2) {
            int k2;
            double t1 = this.sharedData.knot[i2 + j2];
            double t22 = this.sharedData.knot[i2 + j2 + 1];
            if (!(t2 >= t1) || !(t2 <= t22) || t1 == t22) continue;
            int dm2 = this.degree - 2;
            for (k2 = this.degree - j2 - 1; k2 >= 0; --k2) {
                ((SharedData)this.sharedData).a[k2] = 0;
            }
            if (j2 > 0) {
                for (k2 = 0; k2 < j2; ++k2) {
                    ((SharedData)this.sharedData).c[k2] = k2;
                }
                ((SharedData)this.sharedData).c[j2] = Integer.MAX_VALUE;
            } else {
                ((SharedData)this.sharedData).c[0] = dm2;
                ((SharedData)this.sharedData).c[1] = this.degree;
            }
            int z2 = 0;
            while (true) {
                if (this.sharedData.c[z2] < this.sharedData.c[z2 + 1] - 1) {
                    double e2 = 1.0;
                    int bc = 0;
                    int y2 = dm2 - j2;
                    int p2 = j2 - 1;
                    int m3 = dm2;
                    int n2 = this.degree;
                    while (m3 >= 0) {
                        int w2;
                        if (p2 >= 0 && this.sharedData.c[p2] == m3) {
                            w2 = i2 + bc;
                            double kd = this.sharedData.knot[w2 + n2];
                            e2 *= (kd - t2) / (kd - this.sharedData.knot[w2 + 1]);
                            ++bc;
                            --p2;
                        } else {
                            w2 = i2 + this.sharedData.a[y2];
                            double kw = this.sharedData.knot[w2];
                            e2 *= (t2 - kw) / (this.sharedData.knot[w2 + n2 - 1] - kw);
                            --y2;
                        }
                        --m3;
                        --n2;
                    }
                    if (j2 > 0) {
                        int g2 = 0;
                        boolean reset = false;
                        while (true) {
                            int[] nArray = this.sharedData.a;
                            int n3 = ++g2;
                            nArray[n3] = nArray[n3] + 1;
                            if (this.sharedData.a[g2] <= j2) break;
                            reset = true;
                        }
                        if (reset) {
                            for (int h2 = g2 - 1; h2 >= 0; --h2) {
                                ((SharedData)this.sharedData).a[h2] = this.sharedData.a[g2];
                            }
                        }
                    }
                    d2 += e2;
                    int[] nArray = this.sharedData.c;
                    int n4 = z2;
                    nArray[n4] = nArray[n4] + 1;
                    if (this.sharedData.c[z2] > dm2) break block0;
                    for (int k3 = 0; k3 < z2; ++k3) {
                        ((SharedData)this.sharedData).c[k3] = k3;
                    }
                    z2 = 0;
                    continue;
                }
                ++z2;
            }
        }
        return d2;
    }

    @Override
    public void resetMemory() {
        if (this.sharedData.a.length > 0) {
            SharedData.access$202(this.sharedData, new int[0]);
            SharedData.access$302(this.sharedData, new int[0]);
        }
        if (this.sharedData.knot.length > 0) {
            SharedData.access$102(this.sharedData, new double[0]);
        }
    }

    private static class SharedData {
        private int[] a = new int[0];
        private int[] c = new int[0];
        private double[] knot = new double[0];

        private SharedData() {
        }

        static /* synthetic */ double[] access$102(SharedData x0, double[] x1) {
            x0.knot = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(SharedData x0, int[] x1) {
            x0.a = x1;
            return x1;
        }

        static /* synthetic */ int[] access$302(SharedData x0, int[] x1) {
            x0.c = x1;
            return x1;
        }
    }
}

