/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;

public class NaturalCubicSpline
extends ParametricCurve {
    private static final ThreadLocal<SharedData> SHARED_DATA = new ThreadLocal<SharedData>(){

        @Override
        protected SharedData initialValue() {
            return new SharedData();
        }
    };
    private final SharedData sharedData = SHARED_DATA.get();
    private boolean closed = false;

    public NaturalCubicSpline(ControlPath cp, GroupIterator gi) {
        super(cp, gi);
    }

    @Override
    protected void eval(double[] p2) {
        int n2 = p2.length - 1;
        double t2 = p2[n2];
        double t22 = t2 * t2;
        double t3 = t22 * t2;
        int j2 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            p2[i2] = this.sharedData.data[j2++][this.sharedData.ci] + this.sharedData.data[j2++][this.sharedData.ci] * t2 + this.sharedData.data[j2++][this.sharedData.ci] * t22 + this.sharedData.data[j2++][this.sharedData.ci] * t3;
        }
    }

    private void precalc(int n2, int dim, boolean closed) {
        --n2;
        double[] a2 = this.sharedData.data[4 * dim];
        double[] b2 = this.sharedData.data[4 * dim + 1];
        double[] c2 = this.sharedData.data[4 * dim + 2];
        int k2 = 0;
        if (closed) {
            double[] d2 = this.sharedData.data[4 * dim + 3];
            for (int j2 = 0; j2 < dim; ++j2) {
                int i2;
                double e2 = 0.25;
                a2[1] = 0.25;
                d2[1] = 0.25;
                b2[0] = e2 * 3.0 * (this.sharedData.pt[1][j2] - this.sharedData.pt[n2][j2]);
                double h2 = 4.0;
                double f2 = 3.0 * (this.sharedData.pt[0][j2] - this.sharedData.pt[n2 - 1][j2]);
                double g2 = 1.0;
                for (i2 = 1; i2 < n2; ++i2) {
                    a2[i2 + 1] = e2 = 1.0 / (4.0 - a2[i2]);
                    d2[i2 + 1] = -e2 * d2[i2];
                    b2[i2] = e2 * (3.0 * (this.sharedData.pt[i2 + 1][j2] - this.sharedData.pt[i2 - 1][j2]) - b2[i2 - 1]);
                    h2 -= g2 * d2[i2];
                    f2 -= g2 * b2[i2 - 1];
                    g2 = -a2[i2] * g2;
                }
                b2[n2] = f2 - (g2 + 1.0) * b2[n2 - 1];
                c2[n2] = b2[n2] / (h2 -= (g2 + 1.0) * (a2[n2] + d2[n2]));
                c2[n2 - 1] = b2[n2 - 1] - (a2[n2] + d2[n2]) * c2[n2];
                for (i2 = n2 - 2; i2 >= 0; --i2) {
                    c2[i2] = b2[i2] - a2[i2 + 1] * c2[i2 + 1] - d2[i2 + 1] * c2[n2];
                }
                double[] w2 = this.sharedData.data[k2++];
                double[] x2 = this.sharedData.data[k2++];
                double[] y2 = this.sharedData.data[k2++];
                double[] z2 = this.sharedData.data[k2++];
                for (int i3 = 0; i3 < n2; ++i3) {
                    w2[i3] = this.sharedData.pt[i3][j2];
                    x2[i3] = c2[i3];
                    y2[i3] = 3.0 * (this.sharedData.pt[i3 + 1][j2] - this.sharedData.pt[i3][j2]) - 2.0 * c2[i3] - c2[i3 + 1];
                    z2[i3] = 2.0 * (this.sharedData.pt[i3][j2] - this.sharedData.pt[i3 + 1][j2]) + c2[i3] + c2[i3 + 1];
                }
                w2[n2] = this.sharedData.pt[n2][j2];
                x2[n2] = c2[n2];
                y2[n2] = 3.0 * (this.sharedData.pt[0][j2] - this.sharedData.pt[n2][j2]) - 2.0 * c2[n2] - c2[0];
                z2[n2] = 2.0 * (this.sharedData.pt[n2][j2] - this.sharedData.pt[0][j2]) + c2[n2] + c2[0];
            }
        } else {
            for (int j3 = 0; j3 < dim; ++j3) {
                int i4;
                a2[0] = 0.5;
                for (i4 = 1; i4 < n2; ++i4) {
                    a2[i4] = 1.0 / (4.0 - a2[i4 - 1]);
                }
                a2[n2] = 1.0 / (2.0 - a2[n2 - 1]);
                b2[0] = a2[0] * (3.0 * (this.sharedData.pt[1][j3] - this.sharedData.pt[0][j3]));
                for (i4 = 1; i4 < n2; ++i4) {
                    b2[i4] = a2[i4] * (3.0 * (this.sharedData.pt[i4 + 1][j3] - this.sharedData.pt[i4 - 1][j3]) - b2[i4 - 1]);
                }
                b2[n2] = a2[n2] * (3.0 * (this.sharedData.pt[n2][j3] - this.sharedData.pt[n2 - 1][j3]) - b2[n2 - 1]);
                c2[n2] = b2[n2];
                for (i4 = n2 - 1; i4 >= 0; --i4) {
                    c2[i4] = b2[i4] - a2[i4] * c2[i4 + 1];
                }
                double[] w3 = this.sharedData.data[k2++];
                double[] x3 = this.sharedData.data[k2++];
                double[] y3 = this.sharedData.data[k2++];
                double[] z3 = this.sharedData.data[k2++];
                for (int i5 = 0; i5 < n2; ++i5) {
                    w3[i5] = this.sharedData.pt[i5][j3];
                    x3[i5] = c2[i5];
                    y3[i5] = 3.0 * (this.sharedData.pt[i5 + 1][j3] - this.sharedData.pt[i5][j3]) - 2.0 * c2[i5] - c2[i5 + 1];
                    z3[i5] = 2.0 * (this.sharedData.pt[i5][j3] - this.sharedData.pt[i5 + 1][j3]) + c2[i5] + c2[i5 + 1];
                }
                w3[n2] = this.sharedData.pt[n2][j3];
                x3[n2] = 0.0;
                y3[n2] = 0.0;
                z3[n2] = 0.0;
            }
        }
    }

    public void setClosed(boolean b2) {
        this.closed = b2;
    }

    public boolean getClosed() {
        return this.closed;
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    @Override
    public void appendTo(MultiPath mp) {
        int i2;
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("Group iterator not in range");
        }
        int n2 = this.gi.getGroupSize();
        if (n2 < 2) {
            throw new IllegalArgumentException("Group iterator size < 2");
        }
        int dim = mp.getDimension();
        int x2 = 3 + 4 * dim + 1;
        if (this.sharedData.data.length < x2) {
            double[][] temp = new double[x2][];
            for (i2 = 0; i2 < this.sharedData.data.length; ++i2) {
                temp[i2] = this.sharedData.data[i2];
            }
            SharedData.access$102(this.sharedData, temp);
        }
        if (this.sharedData.pt.length < n2) {
            int m3 = 2 * n2;
            SharedData.access$302(this.sharedData, new double[m3][]);
            for (i2 = 0; i2 < this.sharedData.data.length; ++i2) {
                ((SharedData)this.sharedData).data[i2] = new double[m3];
            }
        }
        this.gi.set(0, 0);
        for (int i3 = 0; i3 < n2; ++i3) {
            ((SharedData)this.sharedData).pt[i3] = this.cp.getPoint(this.gi.next()).getLocation();
        }
        this.precalc(n2, dim, this.closed);
        this.sharedData.ci = 0;
        double[] p2 = new double[dim + 1];
        this.eval(p2);
        if (this.connect) {
            mp.lineTo(p2);
        } else {
            mp.moveTo(p2);
        }
        for (i2 = 0; i2 < n2; ++i2) {
            this.sharedData.ci = i2;
            BinaryCurveApproximationAlgorithm.genPts(this, 0.0, 1.0, mp);
        }
    }

    @Override
    public void resetMemory() {
        if (this.sharedData.pt.length > 0) {
            SharedData.access$302(this.sharedData, new double[0][]);
        }
        if (this.sharedData.data.length > 0) {
            SharedData.access$102(this.sharedData, new double[0][]);
        }
    }

    private static class SharedData {
        private double[][] pt = new double[0][];
        private double[][] data = new double[0][];
        private int ci = 0;

        private SharedData() {
        }

        static /* synthetic */ double[][] access$102(SharedData x0, double[][] x1) {
            x0.data = x1;
            return x1;
        }

        static /* synthetic */ double[][] access$302(SharedData x0, double[][] x1) {
            x0.pt = x1;
            return x1;
        }
    }
}

