/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.math;

public final class PascalsTriangle {
    private static final ThreadLocal<SharedData> SHARED_DATA = new ThreadLocal<SharedData>(){

        @Override
        protected SharedData initialValue() {
            return new SharedData();
        }
    };
    private final SharedData sharedData = SHARED_DATA.get();

    public double nCr(int n2, int r2) {
        if (n2 < 0 || r2 < 0 || r2 > n2) {
            return 0.0;
        }
        if (n2 >= this.sharedData.pt.length) {
            int i2;
            int d2 = 2 * this.sharedData.pt.length;
            double[][] pt2 = null;
            pt2 = n2 > d2 ? new double[n2 + 1][] : new double[d2 + 1][];
            for (i2 = 0; i2 < this.sharedData.pt.length; ++i2) {
                pt2[i2] = this.sharedData.pt[i2];
            }
            for (i2 = this.sharedData.pt.length; i2 < pt2.length; ++i2) {
                pt2[i2] = new double[i2 / 2 + 1];
                pt2[i2][0] = 1.0;
                for (int j2 = 1; j2 < pt2[i2].length; ++j2) {
                    double x2 = pt2[i2 - 1][j2 - 1];
                    x2 = j2 < pt2[i2 - 1].length ? (x2 += pt2[i2 - 1][j2]) : 2.0 * x2;
                    pt2[i2][j2] = x2;
                }
            }
            SharedData.access$102(this.sharedData, pt2);
        }
        if (2 * r2 > n2) {
            r2 = n2 - r2;
        }
        return this.sharedData.pt[n2][r2];
    }

    public void reset() {
        SharedData.access$102(this.sharedData, new double[][]{{1.0}});
    }

    private static class SharedData {
        private double[][] pt = new double[][]{{1.0}};

        private SharedData() {
        }

        static /* synthetic */ double[][] access$102(SharedData x0, double[][] x1) {
            x0.pt = x1;
            return x1;
        }
    }
}

