/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.math;

public class VarMap {
    private boolean caseSensitive = true;
    private String[] name = new String[2];
    private double[] value = new double[2];
    private int numVars = 0;

    public VarMap() {
        this(true);
    }

    public VarMap(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public double getValue(String varName) {
        for (int i2 = 0; i2 < this.numVars; ++i2) {
            if ((!this.caseSensitive || !this.name[i2].equals(varName)) && (this.caseSensitive || !this.name[i2].equalsIgnoreCase(varName))) continue;
            return this.value[i2];
        }
        throw new RuntimeException("variable value has not been set: " + varName);
    }

    public void setValue(String varName, double val) {
        if (varName == null) {
            throw new IllegalArgumentException("varName cannot be null");
        }
        for (int i2 = 0; i2 < this.numVars; ++i2) {
            if ((!this.caseSensitive || !this.name[i2].equals(varName)) && (this.caseSensitive || !this.name[i2].equalsIgnoreCase(varName))) continue;
            this.value[i2] = val;
            return;
        }
        if (this.numVars == this.name.length) {
            String[] tmp1 = new String[2 * this.numVars];
            double[] tmp2 = new double[tmp1.length];
            for (int i3 = 0; i3 < this.numVars; ++i3) {
                tmp1[i3] = this.name[i3];
                tmp2[i3] = this.value[i3];
            }
            this.name = tmp1;
            this.value = tmp2;
        }
        this.name[this.numVars] = varName;
        this.value[this.numVars] = val;
        ++this.numVars;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String[] getVariableNames() {
        String[] arr = new String[this.numVars];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            arr[i2] = this.name[i2];
        }
        return arr;
    }

    public double[] getValues() {
        double[] arr = new double[this.numVars];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            arr[i2] = this.value[i2];
        }
        return arr;
    }

    public void remove(String varName) {
        for (int i2 = 0; i2 < this.numVars; ++i2) {
            if ((!this.caseSensitive || !this.name[i2].equals(varName)) && (this.caseSensitive || !this.name[i2].equalsIgnoreCase(varName))) continue;
            for (int j2 = i2 + 1; j2 < this.numVars; ++j2) {
                this.name[j2 - 1] = this.name[j2];
                this.value[j2 - 1] = this.value[j2];
            }
            --this.numVars;
            this.name[this.numVars] = null;
            this.value[this.numVars] = 0.0;
            break;
        }
    }
}

