/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.result;

import com.mysql.cj.conf.PropertySet;
import com.mysql.cj.result.AbstractNumericValueFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class BigDecimalValueFactory
extends AbstractNumericValueFactory<BigDecimal> {
    int scale;
    boolean hasScale;

    public BigDecimalValueFactory(PropertySet pset) {
        super(pset);
    }

    public BigDecimalValueFactory(PropertySet pset, int scale) {
        super(pset);
        this.scale = scale;
        this.hasScale = true;
    }

    private BigDecimal adjustResult(BigDecimal d2) {
        if (this.hasScale) {
            try {
                return d2.setScale(this.scale);
            }
            catch (ArithmeticException ex) {
                return d2.setScale(this.scale, 4);
            }
        }
        return d2;
    }

    @Override
    public BigDecimal createFromBigInteger(BigInteger i2) {
        return this.adjustResult(new BigDecimal(i2));
    }

    @Override
    public BigDecimal createFromLong(long l2) {
        return this.adjustResult(BigDecimal.valueOf(l2));
    }

    @Override
    public BigDecimal createFromBigDecimal(BigDecimal d2) {
        return this.adjustResult(d2);
    }

    @Override
    public BigDecimal createFromDouble(double d2) {
        return this.adjustResult(BigDecimal.valueOf(d2));
    }

    @Override
    public BigDecimal createFromBit(byte[] bytes, int offset, int length) {
        return new BigDecimal(new BigInteger(ByteBuffer.allocate(length + 1).put((byte)0).put(bytes, offset, length).array()));
    }

    @Override
    public String getTargetTypeName() {
        return BigDecimal.class.getName();
    }
}

