/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sparsebits;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SparseBitSet
implements Cloneable,
Serializable {
    protected transient int compactionCount;
    static int compactionCountDefault = 2;
    protected transient long[][][] bits;
    protected transient int bitsLength;
    protected static final int LENGTH4 = 64;
    protected static final int INDEX_SIZE = 31;
    protected static final int LEVEL4 = 6;
    protected static final int LEVEL3 = 5;
    protected static final int LEVEL2 = 5;
    protected static final int LEVEL1 = 15;
    protected static final int MAX_LENGTH1 = 32768;
    protected static final int LENGTH2 = 32;
    protected static final int LENGTH3 = 32;
    protected static final int SHIFT3 = 6;
    protected static final int MASK3 = 31;
    protected static final int SHIFT2 = 5;
    protected static final int UNIT = 65536;
    protected static final int MASK2 = 31;
    protected static final int SHIFT1 = 10;
    protected static final int LENGTH2_SIZE = 31;
    protected static final int LENGTH3_SIZE = 31;
    protected static final int LENGTH4_SIZE = 63;
    protected transient Cache cache;
    protected transient long[] spare;
    static final long[] ZERO_BLOCK = new long[32];
    private static final long serialVersionUID = -6663013367427929992L;
    protected static final transient AndStrategy andStrategy = new AndStrategy();
    protected static final transient AndNotStrategy andNotStrategy = new AndNotStrategy();
    protected static final transient ClearStrategy clearStrategy = new ClearStrategy();
    protected static final transient CopyStrategy copyStrategy = new CopyStrategy();
    protected transient EqualsStrategy equalsStrategy;
    protected static final transient FlipStrategy flipStrategy = new FlipStrategy();
    protected static transient IntersectsStrategy intersectsStrategy = new IntersectsStrategy();
    protected static final transient OrStrategy orStrategy = new OrStrategy();
    protected static final transient SetStrategy setStrategy = new SetStrategy();
    protected transient UpdateStrategy updateStrategy;
    protected static final transient XorStrategy xorStrategy = new XorStrategy();

    protected SparseBitSet(int capacity, int compactionCount) throws NegativeArraySizeException {
        if (capacity < 0) {
            throw new NegativeArraySizeException("(requested capacity=" + capacity + ") < 0");
        }
        this.resize(capacity - 1);
        this.compactionCount = compactionCount;
        this.constructorHelper();
        this.statisticsUpdate();
    }

    public SparseBitSet() {
        this(1, compactionCountDefault);
    }

    public SparseBitSet(int nbits) throws NegativeArraySizeException {
        this(nbits, compactionCountDefault);
    }

    public void and(int i2, boolean value) throws IndexOutOfBoundsException {
        if (i2 + 1 < 1) {
            throw new IndexOutOfBoundsException("i=" + i2);
        }
        if (!value) {
            this.clear(i2);
        }
    }

    public void and(int i2, int j2, SparseBitSet b2) throws IndexOutOfBoundsException {
        this.setScanner(i2, j2, b2, andStrategy);
    }

    public void and(SparseBitSet b2) {
        this.nullify(Math.min(this.bits.length, b2.bits.length));
        this.setScanner(0, Math.min(this.bitsLength, b2.bitsLength), b2, andStrategy);
    }

    public static SparseBitSet and(SparseBitSet a2, SparseBitSet b2) {
        SparseBitSet result = a2.clone();
        result.and(b2);
        return result;
    }

    public void andNot(int i2, boolean value) {
        if (i2 + 1 < 1) {
            throw new IndexOutOfBoundsException("i=" + i2);
        }
        if (value) {
            this.clear(i2);
        }
    }

    public void andNot(int i2, int j2, SparseBitSet b2) throws IndexOutOfBoundsException {
        this.setScanner(i2, j2, b2, andNotStrategy);
    }

    public void andNot(SparseBitSet b2) {
        this.setScanner(0, Math.min(this.bitsLength, b2.bitsLength), b2, andNotStrategy);
    }

    public static SparseBitSet andNot(SparseBitSet a2, SparseBitSet b2) {
        SparseBitSet result = a2.clone();
        result.andNot(b2);
        return result;
    }

    public int cardinality() {
        this.statisticsUpdate();
        return this.cache.cardinality;
    }

    public void clear(int i2) {
        if (i2 + 1 < 1) {
            throw new IndexOutOfBoundsException("i=" + i2);
        }
        if (i2 >= this.bitsLength) {
            return;
        }
        int w2 = i2 >> 6;
        long[][] a2 = this.bits[w2 >> 10];
        if (a2 == null) {
            return;
        }
        long[] a3 = a2[w2 >> 5 & 0x1F];
        if (a3 == null) {
            return;
        }
        int n2 = w2 & 0x1F;
        a3[n2] = a3[n2] & (1L << i2 ^ 0xFFFFFFFFFFFFFFFFL);
        this.cache.hash = 0;
    }

    public void clear(int i2, int j2) throws IndexOutOfBoundsException {
        this.setScanner(i2, j2, null, clearStrategy);
    }

    public void clear() {
        this.nullify(0);
    }

    public SparseBitSet clone() {
        try {
            SparseBitSet result = (SparseBitSet)super.clone();
            result.bits = null;
            result.resize(1);
            result.constructorHelper();
            result.equalsStrategy = null;
            result.setScanner(0, this.bitsLength, this, copyStrategy);
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SparseBitSet)) {
            return false;
        }
        SparseBitSet b2 = (SparseBitSet)obj;
        if (this == b2) {
            return true;
        }
        if (this.equalsStrategy == null) {
            this.equalsStrategy = new EqualsStrategy();
        }
        this.setScanner(0, Math.max(this.bitsLength, b2.bitsLength), b2, this.equalsStrategy);
        return this.equalsStrategy.result;
    }

    public void flip(int i2) {
        long[] a3;
        Object a2;
        if (i2 + 1 < 1) {
            throw new IndexOutOfBoundsException("i=" + i2);
        }
        int w2 = i2 >> 6;
        int w1 = w2 >> 10;
        int w22 = w2 >> 5 & 0x1F;
        if (i2 >= this.bitsLength) {
            this.resize(i2);
        }
        if ((a2 = this.bits[w1]) == null) {
            long[][] lArrayArray = new long[32][];
            this.bits[w1] = lArrayArray;
            a2 = lArrayArray;
        }
        if ((a3 = a2[w22]) == null) {
            a2[w22] = new long[32];
            a3 = a2[w22];
        }
        int n2 = w2 & 0x1F;
        a3[n2] = a3[n2] ^ 1L << i2;
        this.cache.hash = 0;
    }

    public void flip(int i2, int j2) throws IndexOutOfBoundsException {
        this.setScanner(i2, j2, null, flipStrategy);
    }

    public boolean get(int i2) {
        long[] a3;
        long[][] a2;
        if (i2 + 1 < 1) {
            throw new IndexOutOfBoundsException("i=" + i2);
        }
        int w2 = i2 >> 6;
        return i2 < this.bitsLength && (a2 = this.bits[w2 >> 10]) != null && (a3 = a2[w2 >> 5 & 0x1F]) != null && (a3[w2 & 0x1F] & 1L << i2) != 0L;
    }

    public SparseBitSet get(int i2, int j2) throws IndexOutOfBoundsException {
        SparseBitSet result = new SparseBitSet(j2, this.compactionCount);
        result.setScanner(i2, j2, this, copyStrategy);
        return result;
    }

    public int hashCode() {
        this.statisticsUpdate();
        return this.cache.hash;
    }

    public boolean intersects(int i2, int j2, SparseBitSet b2) throws IndexOutOfBoundsException {
        this.setScanner(i2, j2, b2, intersectsStrategy);
        return SparseBitSet.intersectsStrategy.result;
    }

    public boolean intersects(SparseBitSet b2) {
        this.setScanner(0, Math.max(this.bitsLength, b2.bitsLength), b2, intersectsStrategy);
        return SparseBitSet.intersectsStrategy.result;
    }

    public boolean isEmpty() {
        this.statisticsUpdate();
        return this.cache.cardinality == 0;
    }

    public int length() {
        this.statisticsUpdate();
        return this.cache.length;
    }

    public int nextClearBit(int i2) {
        int result;
        long[] a3;
        long[][] a2;
        if (i2 < 0) {
            throw new IndexOutOfBoundsException("i=" + i2);
        }
        int w2 = i2 >> 6;
        int w3 = w2 & 0x1F;
        int w22 = w2 >> 5 & 0x1F;
        int w1 = w2 >> 10;
        long nword = -1L << i2;
        int aLength = this.bits.length;
        if (w1 < aLength && (a2 = this.bits[w1]) != null && (a3 = a2[w22]) != null && (nword = (a3[w3] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << i2) == 0L) {
            w3 = ++w2 & 0x1F;
            w22 = w2 >> 5 & 0x1F;
            nword = -1L;
            block0: for (w1 = w2 >> 10; w1 != aLength && (a2 = this.bits[w1]) != null; ++w1) {
                while (w22 != 32) {
                    a3 = a2[w22];
                    if (a3 == null) break block0;
                    while (w3 != 32) {
                        nword = a3[w3] ^ 0xFFFFFFFFFFFFFFFFL;
                        if (nword != 0L) break block0;
                        ++w3;
                    }
                    w3 = 0;
                    ++w22;
                }
                w3 = 0;
                w22 = 0;
            }
        }
        return (result = ((w1 << 10) + (w22 << 5) + w3 << 6) + Long.numberOfTrailingZeros(nword)) == Integer.MAX_VALUE ? -1 : result;
    }

    public int nextSetBit(int i2) {
        long[] a3;
        long[][] a2;
        if (i2 < 0) {
            throw new IndexOutOfBoundsException("i=" + i2);
        }
        int w2 = i2 >> 6;
        int w3 = w2 & 0x1F;
        int w22 = w2 >> 5 & 0x1F;
        int w1 = w2 >> 10;
        long word = 0L;
        int aLength = this.bits.length;
        if (w1 < aLength && ((a2 = this.bits[w1]) == null || (a3 = a2[w22]) == null || (word = a3[w3] & -1L << i2) == 0L)) {
            w3 = ++w2 & 0x1F;
            w22 = w2 >> 5 & 0x1F;
            block0: for (w1 = w2 >> 10; w1 != aLength; ++w1) {
                a2 = this.bits[w1];
                if (a2 != null) {
                    while (w22 != 32) {
                        a3 = a2[w22];
                        if (a3 != null) {
                            while (w3 != 32) {
                                word = a3[w3];
                                if (word != 0L) break block0;
                                ++w3;
                            }
                        }
                        w3 = 0;
                        ++w22;
                    }
                }
                w3 = 0;
                w22 = 0;
            }
        }
        return w1 >= aLength ? -1 : ((w1 << 10) + (w22 << 5) + w3 << 6) + Long.numberOfTrailingZeros(word);
    }

    public int previousClearBit(int i2) {
        if (i2 < 0) {
            if (i2 == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("i=" + i2);
        }
        long[][][] bits = this.bits;
        int aSize = bits.length - 1;
        int w2 = i2 >> 6;
        int w3 = w2 & 0x1F;
        int w22 = w2 >> 5 & 0x1F;
        int w1 = w2 >> 10;
        if (w1 > aSize) {
            return i2;
        }
        int w4 = i2 % 64;
        while (w1 >= 0) {
            long[][] a2 = bits[w1];
            if (a2 == null) {
                return ((w1 << 10) + (w22 << 5) + w3 << 6) + w4;
            }
            while (w22 >= 0) {
                long[] a3 = a2[w22];
                if (a3 == null) {
                    return ((w1 << 10) + (w22 << 5) + w3 << 6) + w4;
                }
                while (w3 >= 0) {
                    long word = a3[w3];
                    if (word == 0L) {
                        return ((w1 << 10) + (w22 << 5) + w3 << 6) + w4;
                    }
                    for (int bitIdx = w4; bitIdx >= 0; --bitIdx) {
                        if ((word & 1L << bitIdx) != 0L) continue;
                        return ((w1 << 10) + (w22 << 5) + w3 << 6) + bitIdx;
                    }
                    w4 = 63;
                    --w3;
                }
                w3 = 31;
                --w22;
            }
            w22 = 31;
            --w1;
        }
        return -1;
    }

    public int previousSetBit(int i2) {
        int w4;
        int w3;
        int w2;
        if (i2 < 0) {
            if (i2 == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("i=" + i2);
        }
        int w5 = i2 >> 6;
        int w1 = w5 >> 10;
        long[][][] bits = this.bits;
        int aSize = bits.length - 1;
        if (w1 > aSize) {
            w1 = aSize;
            w2 = 31;
            w3 = 31;
            w4 = 63;
        } else {
            w2 = w5 >> 5 & 0x1F;
            w3 = w5 & 0x1F;
            w4 = i2 % 64;
        }
        while (w1 >= 0) {
            long[][] a2 = bits[w1];
            if (a2 != null) {
                while (w2 >= 0) {
                    long[] a3 = a2[w2];
                    if (a3 != null) {
                        while (w3 >= 0) {
                            long word = a3[w3];
                            if (word != 0L) {
                                for (int bitIdx = w4; bitIdx >= 0; --bitIdx) {
                                    if ((word & 1L << bitIdx) == 0L) continue;
                                    return ((w1 << 10) + (w2 << 5) + w3 << 6) + bitIdx;
                                }
                            }
                            w4 = 63;
                            --w3;
                        }
                    }
                    w3 = 31;
                    w4 = 63;
                    --w2;
                }
            }
            w2 = 31;
            w3 = 31;
            w4 = 63;
            --w1;
        }
        return -1;
    }

    public void or(int i2, boolean value) {
        if (i2 + 1 < 1) {
            throw new IndexOutOfBoundsException("i=" + i2);
        }
        if (value) {
            this.set(i2);
        }
    }

    public void or(int i2, int j2, SparseBitSet b2) throws IndexOutOfBoundsException {
        this.setScanner(i2, j2, b2, orStrategy);
    }

    public void or(SparseBitSet b2) {
        this.setScanner(0, b2.bitsLength, b2, orStrategy);
    }

    public static SparseBitSet or(SparseBitSet a2, SparseBitSet b2) {
        SparseBitSet result = a2.clone();
        result.or(b2);
        return result;
    }

    public void set(int i2) {
        long[] a3;
        Object a2;
        if (i2 + 1 < 1) {
            throw new IndexOutOfBoundsException("i=" + i2);
        }
        int w2 = i2 >> 6;
        int w1 = w2 >> 10;
        int w22 = w2 >> 5 & 0x1F;
        if (i2 >= this.bitsLength) {
            this.resize(i2);
        }
        if ((a2 = this.bits[w1]) == null) {
            long[][] lArrayArray = new long[32][];
            this.bits[w1] = lArrayArray;
            a2 = lArrayArray;
        }
        if ((a3 = a2[w22]) == null) {
            a2[w22] = new long[32];
            a3 = a2[w22];
        }
        int n2 = w2 & 0x1F;
        a3[n2] = a3[n2] | 1L << i2;
        this.cache.hash = 0;
    }

    public void set(int i2, boolean value) {
        if (value) {
            this.set(i2);
        } else {
            this.clear(i2);
        }
    }

    public void set(int i2, int j2) throws IndexOutOfBoundsException {
        this.setScanner(i2, j2, null, setStrategy);
    }

    public void set(int i2, int j2, boolean value) {
        if (value) {
            this.set(i2, j2);
        } else {
            this.clear(i2, j2);
        }
    }

    public int size() {
        this.statisticsUpdate();
        return this.cache.size;
    }

    public String statistics() {
        return this.statistics(null);
    }

    public String statistics(String[] values) {
        this.statisticsUpdate();
        String[] v2 = new String[Statistics.values().length];
        v2[Statistics.Size.ordinal()] = Integer.toString(this.size());
        v2[Statistics.Length.ordinal()] = Integer.toString(this.length());
        v2[Statistics.Cardinality.ordinal()] = Integer.toString(this.cardinality());
        v2[Statistics.Total_words.ordinal()] = Integer.toString(this.cache.count);
        v2[Statistics.Set_array_length.ordinal()] = Integer.toString(this.bits.length);
        v2[Statistics.Set_array_max_length.ordinal()] = Integer.toString(32768);
        v2[Statistics.Level2_areas.ordinal()] = Integer.toString(this.cache.a2Count);
        v2[Statistics.Level2_area_length.ordinal()] = Integer.toString(32);
        v2[Statistics.Level3_blocks.ordinal()] = Integer.toString(this.cache.a3Count);
        v2[Statistics.Level3_block_length.ordinal()] = Integer.toString(32);
        v2[Statistics.Compaction_count_value.ordinal()] = Integer.toString(this.compactionCount);
        int longestLabel = 0;
        for (Statistics s2 : Statistics.values()) {
            longestLabel = Math.max(longestLabel, s2.name().length());
        }
        StringBuilder result = new StringBuilder();
        for (Statistics s3 : Statistics.values()) {
            result.append(s3.name());
            for (int i2 = 0; i2 != longestLabel - s3.name().length(); ++i2) {
                result.append(' ');
            }
            result.append(" = ");
            result.append(v2[s3.ordinal()]);
            result.append('\n');
        }
        for (int i3 = 0; i3 != result.length(); ++i3) {
            if (result.charAt(i3) != '_') continue;
            result.setCharAt(i3, ' ');
        }
        if (values != null) {
            int len = Math.min(values.length, v2.length);
            System.arraycopy(v2, 0, values, 0, len);
        }
        return result.toString();
    }

    public String toString() {
        StringBuilder p2 = new StringBuilder(200);
        p2.append('{');
        int i2 = this.nextSetBit(0);
        while (i2 >= 0) {
            p2.append(i2);
            int j2 = this.nextSetBit(i2 + 1);
            if (this.compactionCount > 0) {
                if (j2 < 0) break;
                int last = this.nextClearBit(i2);
                int n2 = last = last < 0 ? Integer.MAX_VALUE : last;
                if (i2 + this.compactionCount < last) {
                    p2.append("..").append(last - 1);
                    j2 = this.nextSetBit(last);
                }
            }
            if (j2 >= 0) {
                p2.append(", ");
            }
            i2 = j2;
        }
        p2.append('}');
        return p2.toString();
    }

    public void toStringCompaction(int count) {
        this.compactionCount = count;
    }

    public void toStringCompaction(boolean change) {
        if (change) {
            compactionCountDefault = this.compactionCount;
        }
    }

    public void xor(int i2, boolean value) {
        if (i2 + 1 < 1) {
            throw new IndexOutOfBoundsException("i=" + i2);
        }
        if (value) {
            this.flip(i2);
        }
    }

    public void xor(int i2, int j2, SparseBitSet b2) throws IndexOutOfBoundsException {
        this.setScanner(i2, j2, b2, xorStrategy);
    }

    public void xor(SparseBitSet b2) {
        this.setScanner(0, b2.bitsLength, b2, xorStrategy);
    }

    public static SparseBitSet xor(SparseBitSet a2, SparseBitSet b2) {
        SparseBitSet result = a2.clone();
        result.xor(b2);
        return result;
    }

    protected static void throwIndexOutOfBoundsException(int i2, int j2) throws IndexOutOfBoundsException {
        String s2 = "";
        if (i2 < 0) {
            s2 = s2 + "(i=" + i2 + ") < 0";
        }
        if (i2 == Integer.MAX_VALUE) {
            s2 = s2 + "(i=" + i2 + ")";
        }
        if (j2 < 0) {
            s2 = s2 + (s2.isEmpty() ? "" : ", ") + "(j=" + j2 + ") < 0";
        }
        if (i2 > j2) {
            s2 = s2 + (s2.isEmpty() ? "" : ", ") + "(i=" + i2 + ") > (j=" + j2 + ")";
        }
        throw new IndexOutOfBoundsException(s2);
    }

    protected final void constructorHelper() {
        this.spare = new long[32];
        this.cache = new Cache();
        this.updateStrategy = new UpdateStrategy();
    }

    protected final void nullify(int start) {
        int aLength = this.bits.length;
        if (start < aLength) {
            for (int w2 = start; w2 != aLength; ++w2) {
                this.bits[w2] = null;
            }
            this.cache.hash = 0;
        }
    }

    protected final void resize(int index) {
        int aLength1;
        int w1 = index >> 6 >> 10;
        int newSize = Integer.highestOneBit(w1);
        if (newSize == 0) {
            newSize = 1;
        }
        if (w1 >= newSize) {
            newSize <<= 1;
        }
        if (newSize > 32768) {
            newSize = 32768;
        }
        int n2 = aLength1 = this.bits != null ? this.bits.length : 0;
        if (newSize != aLength1 || this.bits == null) {
            long[][][] temp = new long[newSize][][];
            if (aLength1 != 0) {
                System.arraycopy(this.bits, 0, temp, 0, Math.min(aLength1, newSize));
                this.nullify(0);
            }
            this.bits = temp;
            this.bitsLength = newSize == 32768 ? Integer.MAX_VALUE : newSize * 65536;
        }
    }

    protected final void setScanner(int i2, int j2, SparseBitSet b2, AbstractStrategy op) throws IndexOutOfBoundsException {
        boolean a2IsEmpty;
        if (op.start(b2)) {
            this.cache.hash = 0;
        }
        if (j2 < i2 || i2 + 1 < 1) {
            SparseBitSet.throwIndexOutOfBoundsException(i2, j2);
        }
        if (i2 == j2) {
            return;
        }
        int properties = op.properties();
        boolean f_op_f_eq_f = (properties & 1) != 0;
        boolean f_op_x_eq_f = (properties & 2) != 0;
        boolean x_op_f_eq_f = (properties & 4) != 0;
        boolean x_op_f_eq_x = (properties & 8) != 0;
        int u2 = i2 >> 6;
        long um = -1L << i2;
        int v2 = j2 - 1 >> 6;
        long vm = -1L >>> -j2;
        long[][][] a1 = this.bits;
        int aLength1 = this.bits.length;
        long[][][] b1 = b2 != null ? b2.bits : null;
        int bLength1 = b1 != null ? b2.bits.length : 0;
        int u1 = u2 >> 10;
        int u22 = u2 >> 5 & 0x1F;
        int u3 = u2 & 0x1F;
        int v1 = v2 >> 10;
        int v22 = v2 >> 5 & 0x1F;
        int v3 = v2 & 0x1F;
        int lastA3Block = (v1 << 5) + v22;
        int a2CountLocal = 0;
        int a3CountLocal = 0;
        boolean notFirstBlock = u2 == 0 && um == -1L;
        boolean bl = a2IsEmpty = u22 == 0;
        while (i2 < j2) {
            boolean haveB2;
            Object a2 = null;
            boolean haveA2 = u1 < aLength1 && (a2 = a1[u1]) != null;
            long[][] b22 = null;
            boolean bl2 = haveB2 = u1 < bLength1 && b1 != null && (b22 = b1[u1]) != null;
            if ((!haveA2 && !haveB2 && f_op_f_eq_f || !haveA2 && f_op_x_eq_f || !haveB2 && x_op_f_eq_f) && notFirstBlock && u1 != v1) {
                if (u1 < aLength1) {
                    a1[u1] = null;
                }
            } else {
                int limit2;
                int n2 = limit2 = u1 == v1 ? v22 + 1 : 32;
                while (u22 != limit2) {
                    boolean notLastBlock;
                    long[] a3 = null;
                    boolean haveA3 = haveA2 && (a3 = a2[u22]) != null;
                    long[] b3 = null;
                    boolean haveB3 = haveB2 && (b3 = b22[u22]) != null;
                    int a3Block = (u1 << 5) + u22;
                    boolean bl3 = notLastBlock = lastA3Block != a3Block;
                    if ((!haveA3 && !haveB3 && f_op_f_eq_f || !haveA3 && f_op_x_eq_f || !haveB3 && x_op_f_eq_f) && notFirstBlock && notLastBlock) {
                        if (haveA2) {
                            a2[u22] = null;
                        }
                    } else {
                        boolean isZero;
                        int limit3;
                        int base3 = a3Block << 5;
                        int n3 = limit3 = notLastBlock ? 32 : v3;
                        if (!haveA3) {
                            a3 = this.spare;
                        }
                        if (!haveB3) {
                            b3 = ZERO_BLOCK;
                        }
                        if (notFirstBlock && notLastBlock) {
                            isZero = x_op_f_eq_x && !haveB3 ? op.isZeroBlock(a3) : op.block(base3, 0, 32, a3, b3);
                        } else {
                            if (notFirstBlock) {
                                isZero = op.block(base3, 0, limit3, a3, b3);
                                isZero &= op.word(base3, limit3, a3, b3, vm);
                            } else {
                                if (u2 == v2) {
                                    isZero = op.word(base3, u3, a3, b3, um & vm);
                                } else {
                                    isZero = op.word(base3, u3, a3, b3, um);
                                    isZero &= op.block(base3, u3 + 1, limit3, a3, b3);
                                    if (limit3 != 32) {
                                        isZero &= op.word(base3, limit3, a3, b3, vm);
                                    }
                                }
                                notFirstBlock = true;
                            }
                            if (isZero) {
                                isZero = op.isZeroBlock(a3);
                            }
                        }
                        if (isZero) {
                            if (haveA2) {
                                a2[u22] = null;
                            }
                        } else {
                            if (a3 == this.spare) {
                                if (i2 >= this.bitsLength) {
                                    this.resize(i2);
                                    a1 = this.bits;
                                    aLength1 = a1.length;
                                }
                                if (a2 == null) {
                                    long[][] lArrayArray = new long[32][];
                                    a2 = lArrayArray;
                                    a1[u1] = lArrayArray;
                                    haveA2 = true;
                                }
                                a2[u22] = a3;
                                this.spare = new long[32];
                            }
                            ++a3CountLocal;
                        }
                        a2IsEmpty &= !haveA2 || a2[u22] == null;
                    }
                    ++u22;
                    u3 = 0;
                }
                if (u22 == 32 && a2IsEmpty && u1 < aLength1) {
                    a1[u1] = null;
                } else {
                    ++a2CountLocal;
                }
            }
            u2 = ++u1 << 10;
            i2 = u2 << 6;
            u22 = 0;
            if (i2 >= 0) continue;
            i2 = Integer.MAX_VALUE;
        }
        op.finish(a2CountLocal, a3CountLocal);
    }

    protected final void statisticsUpdate() {
        if (this.cache.hash != 0) {
            return;
        }
        this.setScanner(0, this.bitsLength, null, this.updateStrategy);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException, InternalError {
        this.statisticsUpdate();
        s2.defaultWriteObject();
        s2.writeInt(this.compactionCount);
        s2.writeInt(this.cache.length);
        int count = this.cache.count;
        s2.writeInt(count);
        long[][][] a1 = this.bits;
        int aLength1 = a1.length;
        for (int w1 = 0; w1 != aLength1; ++w1) {
            long[][] a2 = a1[w1];
            if (a2 == null) continue;
            for (int w2 = 0; w2 != 32; ++w2) {
                long[] a3 = a2[w2];
                if (a3 == null) continue;
                int base = (w1 << 10) + (w2 << 5);
                for (int w3 = 0; w3 != 32; ++w3) {
                    long word = a3[w3];
                    if (word == 0L) continue;
                    s2.writeInt(base + w3);
                    s2.writeLong(word);
                    --count;
                }
            }
        }
        if (count != 0) {
            throw new InternalError("count of entries not consistent");
        }
        s2.writeInt(this.cache.hash);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.compactionCount = s2.readInt();
        int aLength = s2.readInt();
        this.resize(aLength);
        int count = s2.readInt();
        for (int n2 = 0; n2 != count; ++n2) {
            long[] a3;
            int w2 = s2.readInt();
            int w3 = w2 & 0x1F;
            int w22 = w2 >> 5 & 0x1F;
            int w1 = w2 >> 10;
            long word = s2.readLong();
            Object a2 = this.bits[w1];
            if (a2 == null) {
                long[][] lArrayArray = new long[32][];
                this.bits[w1] = lArrayArray;
                a2 = lArrayArray;
            }
            if ((a3 = a2[w22]) == null) {
                a2[w22] = new long[32];
                a3 = a2[w22];
            }
            a3[w3] = word;
        }
        this.constructorHelper();
        this.statisticsUpdate();
        if (count != this.cache.count) {
            throw new InternalError("count of entries not consistent");
        }
        int hash = s2.readInt();
        if (hash != this.cache.hash) {
            throw new IOException("deserialized hashCode mis-match");
        }
    }

    protected static class XorStrategy
    extends AbstractStrategy {
        protected XorStrategy() {
        }

        @Override
        protected int properties() {
            return 9;
        }

        @Override
        protected boolean start(SparseBitSet b2) {
            if (b2 == null) {
                throw new NullPointerException();
            }
            return true;
        }

        @Override
        protected boolean word(int base, int u3, long[] a3, long[] b3, long mask) {
            int n2 = u3;
            long l2 = a3[n2] ^ b3[u3] & mask;
            a3[n2] = l2;
            return l2 == 0L;
        }

        @Override
        protected boolean block(int base, int u3, int v3, long[] a3, long[] b3) {
            boolean isZero = true;
            for (int w3 = u3; w3 != v3; ++w3) {
                int n2 = w3;
                long l2 = a3[n2] ^ b3[w3];
                a3[n2] = l2;
                isZero &= l2 == 0L;
            }
            return isZero;
        }
    }

    protected class UpdateStrategy
    extends AbstractStrategy {
        protected transient int wMin;
        protected transient long wordMin;
        protected transient int wMax;
        protected transient long wordMax;
        protected transient long hash;
        protected transient int count;
        protected transient int cardinality;

        protected UpdateStrategy() {
        }

        @Override
        protected int properties() {
            return 3;
        }

        @Override
        protected boolean start(SparseBitSet b2) {
            this.hash = 1234L;
            this.wMin = -1;
            this.wordMin = 0L;
            this.wMax = 0;
            this.wordMax = 0L;
            this.count = 0;
            this.cardinality = 0;
            return false;
        }

        @Override
        protected boolean word(int base, int u3, long[] a3, long[] b3, long mask) {
            long word = a3[u3];
            long word1 = word & mask;
            if (word1 != 0L) {
                this.compute(base + u3, word1);
            }
            return word == 0L;
        }

        @Override
        protected boolean block(int base, int u3, int v3, long[] a3, long[] b3) {
            boolean isZero = true;
            for (int w3 = 0; w3 != v3; ++w3) {
                long word = a3[w3];
                if (word == 0L) continue;
                isZero = false;
                this.compute(base + w3, word);
            }
            return isZero;
        }

        @Override
        protected void finish(int a2Count, int a3Count) {
            SparseBitSet.this.cache.a2Count = a2Count;
            SparseBitSet.this.cache.a3Count = a3Count;
            SparseBitSet.this.cache.count = this.count;
            SparseBitSet.this.cache.cardinality = this.cardinality;
            SparseBitSet.this.cache.length = (this.wMax + 1) * 64 - Long.numberOfLeadingZeros(this.wordMax);
            SparseBitSet.this.cache.size = SparseBitSet.this.cache.length - this.wMin * 64 - Long.numberOfTrailingZeros(this.wordMin);
            SparseBitSet.this.cache.hash = (int)(this.hash >> 32 ^ this.hash);
        }

        private void compute(int index, long word) {
            ++this.count;
            this.hash ^= word * (long)(index + 1);
            if (this.wMin < 0) {
                this.wMin = index;
                this.wordMin = word;
            }
            this.wMax = index;
            this.wordMax = word;
            this.cardinality += Long.bitCount(word);
        }
    }

    protected static class SetStrategy
    extends AbstractStrategy {
        protected SetStrategy() {
        }

        @Override
        protected int properties() {
            return 0;
        }

        @Override
        protected boolean start(SparseBitSet b2) {
            return true;
        }

        @Override
        protected boolean word(int base, int u3, long[] a3, long[] b3, long mask) {
            int n2 = u3;
            a3[n2] = a3[n2] | mask;
            return false;
        }

        @Override
        protected boolean block(int base, int u3, int v3, long[] a3, long[] b3) {
            for (int w3 = u3; w3 != v3; ++w3) {
                a3[w3] = -1L;
            }
            return false;
        }
    }

    protected static class OrStrategy
    extends AbstractStrategy {
        protected OrStrategy() {
        }

        @Override
        protected int properties() {
            return 9;
        }

        @Override
        protected boolean start(SparseBitSet b2) {
            if (b2 == null) {
                throw new NullPointerException();
            }
            return true;
        }

        @Override
        protected boolean word(int base, int u3, long[] a3, long[] b3, long mask) {
            int n2 = u3;
            long l2 = a3[n2] | b3[u3] & mask;
            a3[n2] = l2;
            return l2 == 0L;
        }

        @Override
        protected boolean block(int base, int u3, int v3, long[] a3, long[] b3) {
            boolean isZero = true;
            for (int w3 = u3; w3 != v3; ++w3) {
                int n2 = w3;
                long l2 = a3[n2] | b3[w3];
                a3[n2] = l2;
                isZero &= l2 == 0L;
            }
            return isZero;
        }
    }

    protected static class IntersectsStrategy
    extends AbstractStrategy {
        protected boolean result;

        protected IntersectsStrategy() {
        }

        @Override
        protected int properties() {
            return 3;
        }

        @Override
        protected boolean start(SparseBitSet b2) {
            if (b2 == null) {
                throw new NullPointerException();
            }
            this.result = false;
            return false;
        }

        @Override
        protected boolean word(int base, int u3, long[] a3, long[] b3, long mask) {
            long word = a3[u3];
            this.result |= (word & b3[u3] & mask) != 0L;
            return word == 0L;
        }

        @Override
        protected boolean block(int base, int u3, int v3, long[] a3, long[] b3) {
            boolean isZero = true;
            for (int w3 = u3; w3 != v3; ++w3) {
                long word = a3[w3];
                this.result |= (word & b3[w3]) != 0L;
                isZero &= word == 0L;
            }
            return isZero;
        }
    }

    protected static class FlipStrategy
    extends AbstractStrategy {
        protected FlipStrategy() {
        }

        @Override
        protected int properties() {
            return 0;
        }

        @Override
        protected boolean start(SparseBitSet b2) {
            return true;
        }

        @Override
        protected boolean word(int base, int u3, long[] a3, long[] b3, long mask) {
            int n2 = u3;
            long l2 = a3[n2] ^ mask;
            a3[n2] = l2;
            return l2 == 0L;
        }

        @Override
        protected boolean block(int base, int u3, int v3, long[] a3, long[] b3) {
            boolean isZero = true;
            for (int w3 = u3; w3 != v3; ++w3) {
                int n2 = w3;
                long l2 = a3[n2] ^ 0xFFFFFFFFFFFFFFFFL;
                a3[n2] = l2;
                isZero &= l2 == 0L;
            }
            return isZero;
        }
    }

    protected static class EqualsStrategy
    extends AbstractStrategy {
        boolean result;

        protected EqualsStrategy() {
        }

        @Override
        protected int properties() {
            return 1;
        }

        @Override
        protected boolean start(SparseBitSet b2) {
            if (b2 == null) {
                throw new NullPointerException();
            }
            this.result = true;
            return false;
        }

        @Override
        protected boolean word(int base, int u3, long[] a3, long[] b3, long mask) {
            long word = a3[u3];
            this.result &= (word & mask) == (b3[u3] & mask);
            return word == 0L;
        }

        @Override
        protected boolean block(int base, int u3, int v3, long[] a3, long[] b3) {
            boolean isZero = true;
            for (int w3 = u3; w3 != v3; ++w3) {
                long word = a3[w3];
                this.result &= word == b3[w3];
                isZero &= word == 0L;
            }
            return isZero;
        }
    }

    protected static class CopyStrategy
    extends AbstractStrategy {
        protected CopyStrategy() {
        }

        @Override
        protected int properties() {
            return 5;
        }

        @Override
        protected boolean start(SparseBitSet b2) {
            return true;
        }

        @Override
        protected boolean word(int base, int u3, long[] a3, long[] b3, long mask) {
            a3[u3] = b3[u3] & mask;
            return a3[u3] == 0L;
        }

        @Override
        protected boolean block(int base, int u3, int v3, long[] a3, long[] b3) {
            boolean isZero = true;
            for (int w3 = u3; w3 != v3; ++w3) {
                a3[w3] = b3[w3];
                isZero &= a3[w3] == 0L;
            }
            return isZero;
        }
    }

    protected static class ClearStrategy
    extends AbstractStrategy {
        protected ClearStrategy() {
        }

        @Override
        protected int properties() {
            return 3;
        }

        @Override
        protected boolean start(SparseBitSet b2) {
            return true;
        }

        @Override
        protected boolean word(int base, int u3, long[] a3, long[] b3, long mask) {
            int n2 = u3;
            long l2 = a3[n2] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            a3[n2] = l2;
            return l2 == 0L;
        }

        @Override
        protected boolean block(int base, int u3, int v3, long[] a3, long[] b3) {
            if (u3 != 0 || v3 != 32) {
                for (int w3 = u3; w3 != v3; ++w3) {
                    a3[w3] = 0L;
                }
            }
            return true;
        }
    }

    protected static class AndNotStrategy
    extends AbstractStrategy {
        protected AndNotStrategy() {
        }

        @Override
        protected int properties() {
            return 11;
        }

        @Override
        protected boolean start(SparseBitSet b2) {
            if (b2 == null) {
                throw new NullPointerException();
            }
            return true;
        }

        @Override
        protected boolean word(int base, int u3, long[] a3, long[] b3, long mask) {
            int n2 = u3;
            long l2 = a3[n2] & (b3[u3] & mask ^ 0xFFFFFFFFFFFFFFFFL);
            a3[n2] = l2;
            return l2 == 0L;
        }

        @Override
        protected boolean block(int base, int u3, int v3, long[] a3, long[] b3) {
            boolean isZero = true;
            for (int w3 = u3; w3 != v3; ++w3) {
                int n2 = w3;
                long l2 = a3[n2] & (b3[w3] ^ 0xFFFFFFFFFFFFFFFFL);
                a3[n2] = l2;
                isZero &= l2 == 0L;
            }
            return isZero;
        }
    }

    protected static class AndStrategy
    extends AbstractStrategy {
        protected AndStrategy() {
        }

        @Override
        protected int properties() {
            return 7;
        }

        @Override
        protected boolean start(SparseBitSet b2) {
            if (b2 == null) {
                throw new NullPointerException();
            }
            return true;
        }

        @Override
        protected boolean word(int base, int u3, long[] a3, long[] b3, long mask) {
            int n2 = u3;
            long l2 = a3[n2] & (b3[u3] | mask ^ 0xFFFFFFFFFFFFFFFFL);
            a3[n2] = l2;
            return l2 == 0L;
        }

        @Override
        protected boolean block(int base, int u3, int v3, long[] a3, long[] b3) {
            boolean isZero = true;
            for (int w3 = u3; w3 != v3; ++w3) {
                int n2 = w3;
                long l2 = a3[n2] & b3[w3];
                a3[n2] = l2;
                isZero &= l2 == 0L;
            }
            return isZero;
        }
    }

    protected static abstract class AbstractStrategy {
        static final int F_OP_F_EQ_F = 1;
        static final int F_OP_X_EQ_F = 2;
        static final int X_OP_F_EQ_F = 4;
        static final int X_OP_F_EQ_X = 8;

        protected AbstractStrategy() {
        }

        protected abstract int properties();

        protected abstract boolean start(SparseBitSet var1);

        protected abstract boolean word(int var1, int var2, long[] var3, long[] var4, long var5);

        protected abstract boolean block(int var1, int var2, int var3, long[] var4, long[] var5);

        protected void finish(int a2Count, int a3Count) {
        }

        protected final boolean isZeroBlock(long[] a3) {
            for (long word : a3) {
                if (word == 0L) continue;
                return false;
            }
            return true;
        }
    }

    protected class Cache {
        protected transient int hash;
        protected transient int size;
        protected transient int cardinality;
        protected transient int length;
        protected transient int count;
        protected transient int a2Count;
        protected transient int a3Count;

        protected Cache() {
        }
    }

    public static enum Statistics {
        Size,
        Length,
        Cardinality,
        Total_words,
        Set_array_length,
        Set_array_max_length,
        Level2_areas,
        Level2_area_length,
        Level3_blocks,
        Level3_block_length,
        Compaction_count_value;

    }
}

