/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.net.Socket;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.MetricsEnabledSSLSocketFactoryWrapper;
import oracle.security.jps.service.keystore.KeyStoreServiceLoadStoreParameter;

public class CustomSSLSocketFactory {
    public static final String DEFAULT_SSO_WALLET_FILE_NAME = "cwallet.sso";
    public static final String DEFAULT_PKCS12_WALLET_FILE_NAME = "ewallet.p12";
    public static final String SSO_WALLET_TYPE = "SSO";
    public static final String PKCS12_WALLET_TYPE = "PKCS12";
    public static final String PKCS11_WALLET_TYPE = "PKCS11";
    public static final String WINDOWS_MY_WALLET_TYPE = "Windows-MY";
    public static final String JKS_TYPE = "JKS";
    public static final String KSS_TYPE = "KSS";
    public static final String SUPPORTED_METHOD_TYPE = "FILE";
    private static final String SSO_FILE_EXTENSION = ".sso";
    private static final String P12_FILE_EXTENSION = ".p12";
    private static final String PFX_FILE_EXTENSION = ".pfx";
    private static final String JKS_FILE_EXTENSION = ".jks";
    private static final String KSS_URI_SCHEME = "kss://";
    private static final String ORACLE_PKI_PROVIDER_CLASS = "oracle.security.pki.OraclePKIProvider";
    private static final String KSS_PROVIDER_CLASS = "oracle.security.jps.internal.keystore.provider.FarmKeyStoreProvider";
    public static SSLSocketFactory defSSLFactory;
    public static boolean initDefFactory;
    private static final Monitor DEF_FACTORY_INIT_MONITOR;
    public static SSLContext defSSLContext;
    public static boolean initDefSSLContext;
    private static final Monitor DEF_CONTEXT_INIT_MONITOR;
    public static String defPropString;
    DMSFactory.DMSNoun dmsParent = null;

    private CustomSSLSocketFactory() {
    }

    public static SSLSocketFactory getSSLSocketFactory(Properties properties, DMSFactory.DMSNoun dMSNoun) throws IOException {
        SSLSocketFactory sSLSocketFactory = null;
        SSLConfig sSLConfig = CustomSSLSocketFactory.readSSLConfig(properties);
        if (sSLConfig.keyStore != null && sSLConfig.keyStore.equalsIgnoreCase("NONE") || sSLConfig.trustStore != null && sSLConfig.trustStore.equalsIgnoreCase("NONE")) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        SSLContext sSLContext = CustomSSLSocketFactory.getSSLContext(sSLConfig);
        if (sSLContext == defSSLContext) {
            if (!initDefFactory) {
                try (Monitor.CloseableLock closeableLock = DEF_FACTORY_INIT_MONITOR.acquireCloseableLock();){
                    if (!initDefFactory) {
                        defSSLFactory = sSLContext.getSocketFactory();
                        initDefFactory = true;
                    }
                }
            }
            sSLSocketFactory = defSSLFactory;
        } else {
            sSLSocketFactory = sSLContext.getSocketFactory();
            sSLSocketFactory = new MetricsEnabledSSLSocketFactoryWrapper(sSLSocketFactory, dMSNoun);
        }
        return sSLSocketFactory;
    }

    public static SSLEngine getSSLSocketEngine(String string, int n2, @Blind(value=PropertiesBlinder.class) Properties properties) throws IOException {
        SSLConfig sSLConfig = CustomSSLSocketFactory.readSSLConfig(properties);
        if (sSLConfig.keyStore != null && sSLConfig.keyStore.equalsIgnoreCase("NONE") || sSLConfig.trustStore != null && sSLConfig.trustStore.equalsIgnoreCase("NONE")) {
            try {
                SSLEngine sSLEngine = SSLContext.getDefault().createSSLEngine();
                sSLEngine.setUseClientMode(true);
                return sSLEngine;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException(noSuchAlgorithmException);
            }
        }
        SSLEngine sSLEngine = CustomSSLSocketFactory.getSSLContext(sSLConfig).createSSLEngine(string, n2);
        sSLEngine.setUseClientMode(true);
        return sSLEngine;
    }

    private static SSLContext getSSLContext(SSLConfig sSLConfig) throws IOException {
        SSLContext sSLContext;
        if (sSLConfig.propConcatenation.equals(defPropString)) {
            if (!initDefSSLContext) {
                try (Monitor.CloseableLock closeableLock = DEF_CONTEXT_INIT_MONITOR.acquireCloseableLock();){
                    if (!initDefSSLContext) {
                        defSSLContext = CustomSSLSocketFactory.createSSLContext(sSLConfig);
                        initDefSSLContext = true;
                    }
                }
            }
            sSLContext = defSSLContext;
        } else {
            sSLContext = CustomSSLSocketFactory.createSSLContext(sSLConfig);
        }
        return sSLContext;
    }

    private static SSLContext createSSLContext(SSLConfig sSLConfig) throws NetException {
        try {
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = null;
            if (sSLConfig.keyStore != null) {
                keyManagerArray = CustomSSLSocketFactory.getKeyManagerArray(sSLConfig.keyStore, sSLConfig.keyStorePassword, sSLConfig.keyStoreType, sSLConfig.keyManagerFacAlgo);
            }
            if (sSLConfig.certificateAlias != null && sSLConfig.certificateAlias.trim().length() != 0 && keyManagerArray != null) {
                keyManagerArray = CustomSSLSocketFactory.wrapWithAliasKeyManager(keyManagerArray, sSLConfig.certificateAlias);
            }
            if (sSLConfig.trustStore != null) {
                trustManagerArray = CustomSSLSocketFactory.getTrustManagerArray(sSLConfig.trustStore, sSLConfig.trustStorePassword, sSLConfig.trustStoreType, sSLConfig.trustManagerFacAlgo);
            }
            SSLContext sSLContext = SSLContext.getInstance(sSLConfig.sslContextProtocol);
            sSLContext.init(keyManagerArray, trustManagerArray, null);
            return sSLContext;
        }
        catch (Exception exception) {
            throw (NetException)new NetException(410).initCause(exception);
        }
    }

    private static X509ExtendedKeyManager[] wrapWithAliasKeyManager(KeyManager[] keyManagerArray, String string) {
        X509ExtendedKeyManager[] x509ExtendedKeyManagerArray = new X509ExtendedKeyManager[keyManagerArray.length];
        for (int i2 = 0; i2 < keyManagerArray.length; ++i2) {
            x509ExtendedKeyManagerArray[i2] = new AliasKeyManager((X509KeyManager)keyManagerArray[i2], string);
        }
        return x509ExtendedKeyManagerArray;
    }

    private static SSLConfig readSSLConfig(@Blind(value=PropertiesBlinder.class) Properties properties) throws NetException {
        String string = (String)properties.get(5);
        SSLConfig sSLConfig = string == null ? CustomSSLSocketFactory.readJavaxNetSSLConfig(properties) : CustomSSLSocketFactory.readWalletSSLConfig(properties);
        sSLConfig.sslContextProtocol = (String)properties.get(38);
        SSLConfig sSLConfig2 = sSLConfig;
        sSLConfig2.propConcatenation = sSLConfig2.propConcatenation + "#" + sSLConfig.sslContextProtocol;
        return sSLConfig;
    }

    private static SSLConfig readJavaxNetSSLConfig(@Blind(value=PropertiesBlinder.class) Properties properties) {
        SSLConfig sSLConfig = new SSLConfig();
        sSLConfig.keyStore = (String)properties.get(8);
        sSLConfig.certificateAlias = (String)properties.get(29);
        if (sSLConfig.keyStore != null) {
            sSLConfig.keyStoreType = (String)properties.get(9);
            if (sSLConfig.keyStoreType == null) {
                sSLConfig.keyStoreType = CustomSSLSocketFactory.resolveKeyStoreType(sSLConfig.keyStore);
            }
            sSLConfig.keyStorePassword = (OpaqueString)properties.get(10);
            if (sSLConfig.keyStorePassword == null || sSLConfig.keyStorePassword == OpaqueString.NULL) {
                sSLConfig.keyStorePassword = OpaqueString.EMPTY;
            }
            sSLConfig.keyManagerFacAlgo = (String)properties.get(14);
            if (sSLConfig.keyManagerFacAlgo == null) {
                sSLConfig.keyManagerFacAlgo = Security.getProperty("ssl.keyManagerFactory.algorithm");
            }
            if (sSLConfig.keyManagerFacAlgo == null) {
                sSLConfig.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            }
        }
        sSLConfig.trustStore = (String)properties.get(11);
        if (sSLConfig.trustStore != null) {
            sSLConfig.trustStoreType = (String)properties.get(12);
            if (sSLConfig.trustStoreType == null) {
                sSLConfig.trustStoreType = CustomSSLSocketFactory.resolveKeyStoreType(sSLConfig.trustStore);
            }
            sSLConfig.trustStorePassword = (OpaqueString)properties.get(13);
            if (sSLConfig.trustStorePassword == null || sSLConfig.trustStorePassword == OpaqueString.NULL) {
                sSLConfig.trustStorePassword = OpaqueString.EMPTY;
            }
            sSLConfig.trustManagerFacAlgo = (String)properties.get(15);
            if (sSLConfig.trustManagerFacAlgo == null) {
                sSLConfig.trustManagerFacAlgo = Security.getProperty("ssl.trustManagerFactory.algorithm");
            }
            if (sSLConfig.trustManagerFacAlgo == null) {
                sSLConfig.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
            }
        }
        sSLConfig.propConcatenation = sSLConfig.keyStore + "#" + sSLConfig.keyStoreType + "#" + sSLConfig.keyStorePassword.get() + "#" + sSLConfig.trustStore + "#" + sSLConfig.trustStoreType + "#" + sSLConfig.trustStorePassword.get() + "#" + sSLConfig.keyManagerFacAlgo + "#" + sSLConfig.trustManagerFacAlgo;
        return sSLConfig;
    }

    private static SSLConfig readWalletSSLConfig(@Blind(value=PropertiesBlinder.class) Properties properties) throws NetException {
        Serializable serializable;
        String string;
        SSLConfig sSLConfig = new SSLConfig();
        sSLConfig.certificateAlias = (String)properties.get(29);
        boolean bl = false;
        String string2 = (String)properties.get(5);
        if (string2.startsWith("(")) {
            string = CustomSSLSocketFactory.processWalletLocation(string2);
        } else {
            string = string2.startsWith("file:") ? string2.substring("file:".length()) : string2;
            serializable = new File(string);
            if (!((File)serializable).exists()) {
                throw new NetException(407, "Couldn't find file at " + string);
            }
            if (!((File)serializable).isDirectory()) {
                bl = true;
            }
        }
        serializable = (OpaqueString)properties.get(16);
        if (serializable == null || serializable == OpaqueString.NULL) {
            if (!bl) {
                sSLConfig.keyStore = string + System.getProperty("file.separator") + DEFAULT_SSO_WALLET_FILE_NAME;
            } else {
                sSLConfig.keyStore = string;
            }
            sSLConfig.keyStoreType = SSO_WALLET_TYPE;
            sSLConfig.keyStorePassword = OpaqueString.EMPTY;
            sSLConfig.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            sSLConfig.trustStore = sSLConfig.keyStore;
            sSLConfig.trustStoreType = SSO_WALLET_TYPE;
            sSLConfig.trustStorePassword = OpaqueString.EMPTY;
            sSLConfig.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
        } else {
            if (!bl) {
                sSLConfig.keyStore = string + System.getProperty("file.separator") + DEFAULT_PKCS12_WALLET_FILE_NAME;
            } else {
                sSLConfig.keyStore = string;
            }
            sSLConfig.keyStoreType = PKCS12_WALLET_TYPE;
            sSLConfig.keyStorePassword = (OpaqueString)serializable;
            sSLConfig.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            sSLConfig.trustStore = sSLConfig.keyStore;
            sSLConfig.trustStoreType = PKCS12_WALLET_TYPE;
            sSLConfig.trustStorePassword = (OpaqueString)serializable;
            sSLConfig.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
        }
        sSLConfig.propConcatenation = string2 + "#" + sSLConfig.keyManagerFacAlgo + "#" + sSLConfig.trustManagerFacAlgo;
        return sSLConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyManager[] getKeyManagerArray(String string, OpaqueString opaqueString, String string2, String string3) throws IOException {
        try {
            KeyStore keyStore = CustomSSLSocketFactory.loadKeyStore(string, string2, opaqueString);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string3);
            char[] cArray = opaqueString.getChars();
            try {
                keyManagerFactory.init(keyStore, cArray);
                if (cArray == null) return keyManagerFactory.getKeyManagers();
            }
            catch (Throwable throwable) {
                if (cArray == null) throw throwable;
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    cArray[i2] = '\u0000';
                }
                throw throwable;
            }
            for (int i3 = 0; i3 < cArray.length; ++i3) {
                cArray[i3] = '\u0000';
            }
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception exception) {
            throw (NetException)new NetException(408).initCause(exception);
        }
    }

    public static TrustManager[] getTrustManagerArray(String string, OpaqueString opaqueString, String string2, String string3) throws IOException {
        try {
            KeyStore keyStore = CustomSSLSocketFactory.loadKeyStore(string, string2, opaqueString);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string3);
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception exception) {
            throw (NetException)new NetException(409).initCause(exception);
        }
    }

    public static String processWalletLocation(String string) throws NetException {
        String string2 = null;
        try {
            NVNavigator nVNavigator = new NVNavigator();
            NVPair nVPair = new NVFactory().createNVPair(string);
            NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "METHOD");
            NVPair nVPair3 = nVNavigator.findNVPair(nVPair, "METHOD_DATA");
            NVPair nVPair4 = nVNavigator.findNVPair(nVPair3, "DIRECTORY");
            string2 = nVPair2.getAtom();
            if (string2.equalsIgnoreCase(SUPPORTED_METHOD_TYPE)) {
                String string3 = nVPair4.getAtom();
                return string3;
            }
            throw new NetException(412, string2);
        }
        catch (Exception exception) {
            throw (NetException)new NetException(407).initCause(exception);
        }
    }

    public static String getDefaultPropertiesString() {
        String string = null;
        String string2 = null;
        Object var2_2 = null;
        String string3 = null;
        String string4 = null;
        string2 = System.getProperty("oracle.net.wallet_location");
        string = string2 != null ? string2 : System.getProperty("javax.net.ssl.keyStore", "") + "#" + System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.keyStorePassword", "") + "#" + System.getProperty("javax.net.ssl.trustStore", "") + "#" + System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.trustStorePassword", "");
        if (string3 == null) {
            string3 = KeyManagerFactory.getDefaultAlgorithm();
        }
        if (string4 == null) {
            string4 = TrustManagerFactory.getDefaultAlgorithm();
        }
        return string + "#" + string3 + "#" + string4;
    }

    private static KeyStore getKeyStoreInstance(String string) throws KeyStoreException {
        try {
            return KeyStore.getInstance(string);
        }
        catch (KeyStoreException keyStoreException) {
            try {
                Provider provider = CustomSSLSocketFactory.loadKnownProvider(string);
                if (provider == null) {
                    throw keyStoreException;
                }
                return KeyStore.getInstance(string, provider);
            }
            catch (Exception exception) {
                throw keyStoreException;
            }
        }
    }

    private static Provider loadKnownProvider(String string) throws Exception {
        Object object;
        String string2;
        Provider provider = null;
        switch (string.toUpperCase()) {
            case "SSO": {
                string2 = ORACLE_PKI_PROVIDER_CLASS;
                break;
            }
            case "KSS": {
                string2 = KSS_PROVIDER_CLASS;
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null && (object = Class.forName(string2)) != null && Provider.class.isAssignableFrom((Class<?>)object)) {
            provider = AccessController.doPrivileged(() -> CustomSSLSocketFactory.lambda$loadKnownProvider$0((Class)object));
        }
        return provider;
    }

    private static String resolveKeyStoreType(String string) {
        if (string == null || string.length() == 0) {
            return KeyStore.getDefaultType();
        }
        String string2 = string.toLowerCase();
        if (string2.endsWith(SSO_FILE_EXTENSION)) {
            return SSO_WALLET_TYPE;
        }
        if (string2.endsWith(P12_FILE_EXTENSION) || string2.endsWith(PFX_FILE_EXTENSION)) {
            return PKCS12_WALLET_TYPE;
        }
        if (string2.endsWith(JKS_FILE_EXTENSION)) {
            return JKS_TYPE;
        }
        if (string2.startsWith(KSS_URI_SCHEME)) {
            return KSS_TYPE;
        }
        return KeyStore.getDefaultType();
    }

    @Log
    protected static void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, CustomSSLSocketFactory.class, executable, string);
    }

    private static KeyStore loadKeyStore(String string, String string2, OpaqueString opaqueString) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        KeyStore keyStore = CustomSSLSocketFactory.getKeyStoreInstance(string2);
        if (KSS_TYPE.equals(string2)) {
            CustomSSLSocketFactory.loadKSSKeyStore(keyStore, string, opaqueString);
        } else {
            CustomSSLSocketFactory.loadFileBasedKeyStore(keyStore, string, opaqueString);
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadFileBasedKeyStore(KeyStore keyStore, String string, OpaqueString opaqueString) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (InputStream inputStream = Channels.newInputStream(FileChannel.open(Paths.get(string, new String[0]), StandardOpenOption.READ));){
            char[] cArray = opaqueString.getChars();
            try {
                keyStore.load(inputStream, cArray);
                if (cArray == null) return;
            }
            catch (Throwable throwable) {
                if (cArray == null) throw throwable;
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    cArray[i2] = '\u0000';
                }
                throw throwable;
            }
            for (int i3 = 0; i3 < cArray.length; ++i3) {
                cArray[i3] = '\u0000';
            }
            return;
        }
    }

    private static void loadKSSKeyStore(KeyStore keyStore, String string, OpaqueString opaqueString) throws IOException, NoSuchAlgorithmException, CertificateException {
        final class KSSLoader {
            KSSLoader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void load(KeyStore keyStore, String string, OpaqueString opaqueString) throws IOException, NoSuchAlgorithmException, CertificateException {
                KeyStoreServiceLoadStoreParameter keyStoreServiceLoadStoreParameter = new KeyStoreServiceLoadStoreParameter();
                if (opaqueString != null && opaqueString != OpaqueString.NULL) {
                    char[] cArray = opaqueString.getChars();
                    try {
                        keyStoreServiceLoadStoreParameter.setProtectionParameter((KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(cArray));
                    }
                    catch (Throwable throwable) {
                        for (int i2 = 0; i2 < cArray.length; ++i2) {
                            cArray[i2] = '\u0000';
                        }
                        throw throwable;
                    }
                    for (int i3 = 0; i3 < cArray.length; ++i3) {
                        cArray[i3] = '\u0000';
                    }
                }
                keyStoreServiceLoadStoreParameter.setKssUri(string);
                keyStore.load((KeyStore.LoadStoreParameter)keyStoreServiceLoadStoreParameter);
            }
        }
        new KSSLoader().load(keyStore, string, opaqueString);
    }

    private static /* synthetic */ Provider lambda$loadKnownProvider$0(Class clazz) throws Exception {
        return (Provider)clazz.newInstance();
    }

    static {
        DEF_FACTORY_INIT_MONITOR = Monitor.newInstance();
        DEF_CONTEXT_INIT_MONITOR = Monitor.newInstance();
        defPropString = CustomSSLSocketFactory.getDefaultPropertiesString();
    }

    static class AliasKeyManager
    extends X509ExtendedKeyManager {
        private final String alias;
        private final X509KeyManager keyManager;

        AliasKeyManager(X509KeyManager x509KeyManager, String string) {
            this.keyManager = x509KeyManager;
            this.alias = string;
        }

        @Override
        public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
            return this.chooseEngineClientAlias(stringArray, principalArray, null);
        }

        @Override
        public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
            for (String string : stringArray) {
                if (!this.isMatchFound(this.keyManager.getClientAliases(string, principalArray), this.alias)) continue;
                return this.alias;
            }
            return null;
        }

        @Override
        public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
            return this.chooseEngineServerAlias(string, principalArray, null);
        }

        @Override
        public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
            String[] stringArray = this.keyManager.getServerAliases(string, principalArray);
            if (this.isMatchFound(stringArray, this.alias)) {
                return this.alias;
            }
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String string) {
            return this.keyManager.getCertificateChain(string);
        }

        @Override
        public String[] getClientAliases(String string, Principal[] principalArray) {
            return this.keyManager.getClientAliases(string, principalArray);
        }

        @Override
        public PrivateKey getPrivateKey(String string) {
            return this.keyManager.getPrivateKey(string);
        }

        @Override
        public String[] getServerAliases(String string, Principal[] principalArray) {
            return this.keyManager.getServerAliases(string, principalArray);
        }

        private boolean isMatchFound(String[] stringArray, String string) {
            if (stringArray == null) {
                return false;
            }
            for (String string2 : stringArray) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
    }

    private static class SSLConfig {
        private String keyStore;
        private String keyStoreType;
        private OpaqueString keyStorePassword = OpaqueString.NULL;
        private String certificateAlias;
        private String keyManagerFacAlgo;
        private String trustStore;
        private String trustStoreType;
        private OpaqueString trustStorePassword = OpaqueString.NULL;
        private String trustManagerFacAlgo;
        private String sslContextProtocol;
        private String propConcatenation;

        private SSLConfig() {
        }
    }
}

