/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.zone.ZoneRules;
import java.util.Calendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleTimestampWithTimeZone;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class TIMESTAMPTZ
extends Datum
implements OracleTimestampWithTimeZone {
    static final long serialVersionUID = 6708361144588335769L;
    static final Calendar CAL_GMT_US = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
    static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int SECOND_MILLISECOND = 1000;
    private static int HOUR_SECOND = 3600;
    private static int MINUTE_SECOND = 60;
    private static int OFFSET_HOUR = 20;
    private static int OFFSET_MINUTE = 60;
    private static byte REGIONIDBIT = (byte)-128;

    public TIMESTAMPTZ() {
        super(TIMESTAMPTZ.initTimestamptz());
    }

    public TIMESTAMPTZ(byte[] byArray) {
        super(byArray);
    }

    public TIMESTAMPTZ(Connection connection, Date date) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, date));
    }

    public TIMESTAMPTZ(Connection connection, Date date, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, date, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Time time) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, time));
    }

    public TIMESTAMPTZ(Connection connection, Time time, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, time, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, timestamp));
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, timestamp, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp, ZoneId zoneId) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, timestamp, zoneId));
    }

    public TIMESTAMPTZ(Connection connection, DATE dATE) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, dATE));
    }

    public TIMESTAMPTZ(Connection connection, String string) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, string));
    }

    public TIMESTAMPTZ(Connection connection, String string, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, string, calendar));
    }

    public TIMESTAMPTZ(OffsetDateTime offsetDateTime) throws SQLException {
        super(TIMESTAMPTZ.toBytes(offsetDateTime));
    }

    public TIMESTAMPTZ(ZonedDateTime zonedDateTime) throws SQLException {
        super(TIMESTAMPTZ.toBytes(zonedDateTime));
    }

    public TIMESTAMPTZ(Connection connection, LocalDateTime localDateTime) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, localDateTime));
    }

    public TIMESTAMPTZ(OffsetTime offsetTime) throws SQLException {
        super(TIMESTAMPTZ.toBytes(offsetTime));
    }

    public static Date toDate(Connection connection, byte[] byArray) throws SQLException {
        int n2;
        int[] nArray = new int[13];
        for (n2 = 0; n2 < 13; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        int n3 = TIMESTAMP.getNanos(byArray, 7) / 1000000;
        calendar.set(14, n3);
        if ((nArray[11] & REGIONIDBIT) != 0) {
            int n4 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            TIMEZONETAB tIMEZONETAB = TIMESTAMPTZ.getTIMEZONETAB(connection);
            if (tIMEZONETAB.checkID(n4 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                tIMEZONETAB.updateTable(connection, n4);
            }
            int n5 = tIMEZONETAB.getOffset(calendar, n4);
            calendar.add(10, n5 / HOUR_MILLISECOND);
            calendar.add(12, n5 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
        } else {
            calendar.add(10, nArray[11] - OFFSET_HOUR);
            calendar.add(12, nArray[12] - OFFSET_MINUTE);
        }
        long l2 = calendar.getTime().getTime();
        return new Date(l2);
    }

    public static Date toDate2(Connection connection, byte[] byArray) throws SQLException {
        int n2;
        int[] nArray = new int[13];
        for (n2 = 0; n2 < 13; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        int n3 = TIMESTAMP.getNanos(byArray, 7) / 1000000;
        calendar.set(14, n3);
        long l2 = calendar.getTime().getTime();
        return new Date(l2);
    }

    public static Time toTime(Connection connection, byte[] byArray) throws SQLException {
        int n2 = byArray[4] & 0xFF;
        int n3 = byArray[5] & 0xFF;
        int n4 = byArray[6] & 0xFF;
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, n2 - 1);
        calendar.set(12, n3 - 1);
        calendar.set(13, n4 - 1);
        calendar.set(14, 0);
        return new Time(calendar.getTimeInMillis());
    }

    public static DATE toDATE(Connection connection, byte[] byArray) throws SQLException {
        return new DATE(TIMESTAMPTZ.toTimestampInSessionTimezone(connection, byArray));
    }

    public static TIMESTAMP toTIMESTAMP(Connection connection, byte[] byArray) throws SQLException {
        return new TIMESTAMP(TIMESTAMPTZ.toTimestampInSessionTimezone(connection, byArray));
    }

    public static Timestamp toTimestamp(Connection connection, byte[] byArray) throws SQLException {
        Cloneable cloneable;
        int[] nArray = new int[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = (Calendar)CAL_GMT_US.clone();
        Calendar calendar3 = Calendar.getInstance();
        int n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        calendar2.set(1, n2);
        calendar2.set(2, nArray[2] - 1);
        calendar2.set(5, nArray[3]);
        calendar2.set(11, nArray[4] - 1);
        calendar2.set(12, nArray[5] - 1);
        calendar2.set(13, nArray[6] - 1);
        calendar2.set(14, 0);
        long l2 = calendar.getTime().getTime();
        if ((nArray[11] & REGIONIDBIT) != 0) {
            int n3 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            TIMEZONETAB tIMEZONETAB = TIMESTAMPTZ.getTIMEZONETAB(connection);
            if (tIMEZONETAB.checkID(n3 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                tIMEZONETAB.updateTable(connection, n3);
            }
            int n4 = tIMEZONETAB.getOffset(calendar2, n3);
            TimeZone timeZone = calendar.getTimeZone();
            cloneable = calendar3.getTimeZone();
            if (!timeZone.inDaylightTime(calendar.getTime()) && ((TimeZone)cloneable).inDaylightTime(new Timestamp(l2 += (long)n4))) {
                l2 = cloneable instanceof SimpleTimeZone ? (l2 -= (long)((SimpleTimeZone)cloneable).getDSTSavings()) : (l2 -= (long)HOUR_MILLISECOND);
            }
            if (timeZone.inDaylightTime(calendar.getTime()) && !((TimeZone)cloneable).inDaylightTime(new Timestamp(l2))) {
                l2 = cloneable instanceof SimpleTimeZone ? (l2 += (long)((SimpleTimeZone)timeZone).getDSTSavings()) : (l2 += (long)HOUR_MILLISECOND);
            }
        } else {
            calendar.add(10, nArray[11] - OFFSET_HOUR);
            calendar.add(12, nArray[12] - OFFSET_MINUTE);
            l2 = calendar.getTime().getTime();
        }
        Timestamp timestamp = new Timestamp(l2);
        long l3 = calendar2.getTime().getTime();
        cloneable = Calendar.getInstance();
        ((Calendar)cloneable).setTimeInMillis(l3);
        Calendar calendar4 = Calendar.getInstance();
        calendar4.setTime(timestamp);
        boolean bl = ((Calendar)cloneable).getTimeZone().inDaylightTime(((Calendar)cloneable).getTime());
        boolean bl2 = calendar4.getTimeZone().inDaylightTime(calendar4.getTime());
        if (bl && !bl2) {
            timestamp = new Timestamp(l2 - (long)((Calendar)cloneable).getTimeZone().getDSTSavings());
        } else if (!bl && bl2) {
            timestamp = new Timestamp(l2 + (long)calendar4.getTimeZone().getDSTSavings());
        }
        int n5 = TIMESTAMP.getNanos(byArray, 7);
        timestamp.setNanos(n5);
        return timestamp;
    }

    public static Timestamp toTimestamp2(Connection connection, byte[] byArray) throws SQLException {
        int n2;
        int[] nArray = new int[13];
        for (n2 = 0; n2 < 13; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        calendar.clear();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        long l2 = calendar.getTime().getTime();
        Timestamp timestamp = new Timestamp(l2);
        int n3 = TIMESTAMP.getNanos(byArray, 7);
        timestamp.setNanos(n3);
        return timestamp;
    }

    static Timestamp toTimestampInSessionTimezone(Connection connection, byte[] byArray) throws SQLException {
        int n2;
        int[] nArray = new int[13];
        for (n2 = 0; n2 < 13; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        calendar.clear();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        Calendar calendar2 = TIMESTAMPLTZ.getSessCalendar(connection);
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, calendar2);
        long l2 = calendar2.getTime().getTime();
        Timestamp timestamp = new Timestamp(l2);
        int n3 = TIMESTAMP.getNanos(byArray, 7);
        timestamp.setNanos(n3);
        return timestamp;
    }

    @DisableTrace
    public static String toString(Connection connection, byte[] byArray) throws SQLException {
        int n2;
        String string;
        int n3;
        int[] nArray = new int[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        int n4 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        calendar.set(1, n4);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        if ((nArray[11] & REGIONIDBIT) != 0) {
            n3 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
            TIMEZONETAB tIMEZONETAB = oracleConnection.getTIMEZONETAB();
            if (tIMEZONETAB.checkID(n3 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                tIMEZONETAB.updateTable(oracleConnection, n3);
            }
            string = ZONEIDMAP.getRegion(n3);
            n2 = tIMEZONETAB.getOffset(calendar, n3);
            calendar.add(14, n2);
        } else {
            n3 = nArray[11] - OFFSET_HOUR;
            int n5 = nArray[12] - OFFSET_MINUTE;
            string = n3 + ":";
            string = n5 == 0 ? string + "00" : string + "" + n5;
            calendar.add(10, n3);
            calendar.add(12, n5);
        }
        n4 = calendar.get(1);
        if (calendar.get(0) == 0) {
            n4 = -(n4 - 1);
        }
        n3 = calendar.get(2) + 1;
        int n6 = calendar.get(5);
        int n7 = calendar.get(11);
        n2 = calendar.get(12);
        int n8 = calendar.get(13);
        int n9 = TIMESTAMP.getNanos(byArray, 7);
        return TIMESTAMPTZ.toString(n4, n3, n6, n7, n2, n8, n9, string);
    }

    public static OffsetDateTime toOffsetDateTime(Connection connection, byte[] byArray) throws SQLException {
        int n2;
        int n3;
        int[] nArray = new int[13];
        for (n3 = 0; n3 < 13; ++n3) {
            nArray[n3] = byArray[n3] & 0xFF;
        }
        n3 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        int n4 = TIMESTAMP.getNanos(byArray, 7);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(n3, nArray[2], nArray[3], nArray[4] - 1, nArray[5] - 1, nArray[6] - 1, n4, ZoneOffset.UTC);
        ZoneOffset zoneOffset = null;
        if ((nArray[11] & REGIONIDBIT) != 0) {
            n2 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
            TIMEZONETAB tIMEZONETAB = oracleConnection.getTIMEZONETAB();
            if (tIMEZONETAB.checkID(n2 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                tIMEZONETAB.updateTable(oracleConnection, n2);
            }
            int n5 = tIMEZONETAB.getOffset(offsetDateTime.toInstant().toEpochMilli(), n2);
            zoneOffset = ZoneOffset.ofTotalSeconds(n5 / SECOND_MILLISECOND);
        } else {
            n2 = nArray[11] - OFFSET_HOUR;
            int n6 = nArray[12] - OFFSET_MINUTE;
            zoneOffset = ZoneOffset.ofHoursMinutes(n2, n6);
        }
        OffsetDateTime offsetDateTime2 = offsetDateTime.withOffsetSameInstant(zoneOffset);
        return offsetDateTime2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OffsetDateTime toOffsetDateTime(byte[] byArray) throws SQLException {
        int n2;
        int n3;
        int[] nArray = new int[13];
        for (n3 = 0; n3 < 13; ++n3) {
            nArray[n3] = byArray[n3] & 0xFF;
        }
        n3 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        int n4 = TIMESTAMP.getNanos(byArray, 7);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(n3, nArray[2], nArray[3], nArray[4] - 1, nArray[5] - 1, nArray[6] - 1, n4, ZoneOffset.UTC);
        ZoneOffset zoneOffset = null;
        if ((nArray[11] & REGIONIDBIT) != 0) {
            n2 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            String string = ZONEIDMAP.getRegion(n2 += TIMESTAMPTZ.getLowOrderbits(nArray[12]));
            ZoneId zoneId = ZoneId.of(string);
            ZoneRules zoneRules = zoneId.getRules();
            if (!zoneRules.isFixedOffset()) throw new SQLException("Timezone not supported: " + string);
            zoneOffset = zoneRules.getOffset(offsetDateTime.toInstant());
            return offsetDateTime.withOffsetSameInstant(zoneOffset);
        } else {
            n2 = nArray[11] - OFFSET_HOUR;
            int n5 = nArray[12] - OFFSET_MINUTE;
            zoneOffset = ZoneOffset.ofHoursMinutes(n2, n5);
        }
        return offsetDateTime.withOffsetSameInstant(zoneOffset);
    }

    @DisableTrace
    public static final String toString(int n2, int n3, int n4, int n5, int n6, int n7, int n8, String string) {
        String string2 = "" + n2 + "-" + TIMESTAMPTZ.toStr(n3) + "-" + TIMESTAMPTZ.toStr(n4) + " " + TIMESTAMPTZ.toStr(n5) + ":" + TIMESTAMPTZ.toStr(n6) + ":" + TIMESTAMPTZ.toStr(n7);
        if (n8 >= 0) {
            int n9;
            String string3 = String.format("%09d", n8);
            char[] cArray = string3.toCharArray();
            for (n9 = cArray.length; n9 > 1 && cArray[n9 - 1] == '0'; --n9) {
            }
            string3 = string3.substring(0, n9);
            string2 = string2 + "." + string3;
        }
        if (string != null) {
            string2 = string2 + " " + string;
        }
        return string2;
    }

    private static final String toStr(int n2) {
        return n2 < 10 ? "0" + n2 : Integer.toString(n2);
    }

    public Timestamp timestampValue(Connection connection) throws SQLException {
        if (((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getTimestamptzInGmt()) {
            return TIMESTAMPTZ.toTimestamp2(connection, this.getBytes());
        }
        return TIMESTAMPTZ.toTimestamp(connection, this.getBytes());
    }

    @Override
    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Connection connection, Date date) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, date, null);
    }

    public static byte[] toBytes(Connection connection, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            return null;
        }
        byte[] byArray = new byte[13];
        Calendar calendar2 = TIMESTAMPTZ.getWorkCal(connection, calendar);
        calendar2.setTime(date);
        if (OracleDriver.getSystemPropertyDateZeroTime()) {
            calendar2.set(11, 0);
            calendar2.set(12, 0);
            calendar2.set(13, 0);
        }
        Calendar calendar3 = TIMESTAMPTZ.doCalWork(connection, calendar2, byArray);
        int n2 = TIMESTAMP.getOracleYear(calendar3);
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar3.get(2) + 1);
        byArray[3] = (byte)calendar3.get(5);
        byArray[4] = (byte)(calendar3.get(11) + 1);
        byArray[5] = (byte)(calendar3.get(12) + 1);
        byArray[6] = (byte)(calendar3.get(13) + 1);
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Time time) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, time, (Calendar)null);
    }

    public static byte[] toBytes(Connection connection, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            return null;
        }
        byte[] byArray = new byte[13];
        Calendar calendar2 = TIMESTAMPTZ.getWorkCal(connection, calendar);
        calendar2.setTime(time);
        int n2 = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getUse1900AsYearForTime() ? 1900 : 1970;
        calendar2.set(1, n2);
        calendar2.set(2, 0);
        calendar2.set(5, 1);
        Calendar calendar3 = TIMESTAMPTZ.doCalWork(connection, calendar2, byArray);
        int n3 = TIMESTAMP.getOracleYear(calendar3);
        byArray[0] = (byte)(n3 / 100 + 100);
        byArray[1] = (byte)(n3 % 100 + 100);
        byArray[2] = (byte)(calendar3.get(2) + 1);
        byArray[3] = (byte)calendar3.get(5);
        byArray[4] = (byte)(calendar3.get(11) + 1);
        byArray[5] = (byte)(calendar3.get(12) + 1);
        byArray[6] = (byte)(calendar3.get(13) + 1);
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] toBytes(Connection connection, Time time, ZoneId zoneId) throws SQLException {
        if (time == null) {
            return null;
        }
        byte[] byArray = new byte[13];
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        calendar.setTime(time);
        int n2 = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getUse1900AsYearForTime() ? 1900 : 1970;
        calendar.set(1, n2);
        calendar.set(2, 0);
        calendar.set(5, 1);
        Calendar calendar2 = TIMESTAMPTZ.doCalWork(connection, calendar, byArray);
        int n3 = TIMESTAMP.getOracleYear(calendar2);
        byArray[0] = (byte)(n3 / 100 + 100);
        byArray[1] = (byte)(n3 % 100 + 100);
        byArray[2] = (byte)(calendar2.get(2) + 1);
        byArray[3] = (byte)calendar2.get(5);
        byArray[4] = (byte)(calendar2.get(11) + 1);
        byArray[5] = (byte)(calendar2.get(12) + 1);
        byArray[6] = (byte)(calendar2.get(13) + 1);
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        String string = zoneId.getId();
        int n4 = ZONEIDMAP.getID(string);
        if (!ZONEIDMAP.isValidID(n4)) {
            ZoneRules zoneRules = zoneId.getRules();
            if (!zoneRules.isFixedOffset()) throw new SQLException("Timezone not supported: " + string);
            ZoneOffset zoneOffset = zoneRules.getOffset(time.toInstant());
            int n5 = zoneOffset.getTotalSeconds();
            byArray[11] = (byte)(n5 / HOUR_SECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n5 % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
            return byArray;
        } else {
            byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(n4);
            byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
            byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(n4);
        }
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, timestamp, (Calendar)null);
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        byte[] byArray = new byte[13];
        Calendar calendar2 = TIMESTAMPTZ.getWorkCal(connection, calendar);
        calendar2.setTime(timestamp);
        Calendar calendar3 = TIMESTAMPTZ.doCalWork(connection, calendar2, byArray);
        int n2 = TIMESTAMP.getOracleYear(calendar3);
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar3.get(2) + 1);
        byArray[3] = (byte)calendar3.get(5);
        byArray[4] = (byte)(calendar3.get(11) + 1);
        byArray[5] = (byte)(calendar3.get(12) + 1);
        byArray[6] = (byte)(calendar3.get(13) + 1);
        int n3 = timestamp.getNanos();
        byArray[7] = (byte)(n3 >> 24);
        byArray[8] = (byte)(n3 >> 16 & 0xFF);
        byArray[9] = (byte)(n3 >> 8 & 0xFF);
        byArray[10] = (byte)(n3 & 0xFF);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp, ZoneId zoneId) throws SQLException {
        return TIMESTAMPTZ.toBytes(timestamp, zoneId, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] toBytes(Timestamp timestamp, ZoneId zoneId, boolean bl) throws SQLException {
        byte[] byArray = new byte[13];
        Calendar calendar = (Calendar)CAL_GMT_US.clone();
        if (bl) {
            Calendar calendar2 = Calendar.getInstance(TimeZone.getTimeZone(zoneId));
            calendar2.setTime(timestamp);
            calendar.setTime(calendar2.getTime());
        } else {
            calendar.setTime(timestamp);
        }
        int n2 = TIMESTAMP.getOracleYear(calendar);
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        byArray[7] = (byte)(timestamp.getNanos() >> 24);
        byArray[8] = (byte)(timestamp.getNanos() >> 16 & 0xFF);
        byArray[9] = (byte)(timestamp.getNanos() >> 8 & 0xFF);
        byArray[10] = (byte)(timestamp.getNanos() & 0xFF);
        String string = zoneId.getId();
        int n3 = ZONEIDMAP.getID(string);
        if (!ZONEIDMAP.isValidID(n3)) {
            ZoneRules zoneRules = zoneId.getRules();
            if (!zoneRules.isFixedOffset()) throw new SQLException("Timezone not supported: " + string);
            ZoneOffset zoneOffset = zoneRules.getOffset(timestamp.toInstant());
            int n4 = zoneOffset.getTotalSeconds();
            byArray[11] = (byte)(n4 / HOUR_SECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n4 % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
            return byArray;
        } else {
            byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(n3);
            byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
            byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(n3);
        }
        return byArray;
    }

    public static byte[] toBytes(Connection connection, DATE dATE) throws SQLException {
        if (dATE == null) {
            return null;
        }
        byte[] byArray = new byte[13];
        Calendar calendar = TIMESTAMPTZ.getWorkCal(connection, null);
        calendar.setTime(DATE.toDate(dATE.toBytes()));
        Calendar calendar2 = TIMESTAMPTZ.doCalWork(connection, calendar, byArray);
        int n2 = TIMESTAMP.getOracleYear(calendar2);
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar2.get(2) + 1);
        byArray[3] = (byte)calendar2.get(5);
        byArray[4] = (byte)(calendar2.get(11) + 1);
        byArray[5] = (byte)(calendar2.get(12) + 1);
        byArray[6] = (byte)(calendar2.get(13) + 1);
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        return byArray;
    }

    public static byte[] toBytes(Connection connection, String string) throws SQLException {
        byte[] byArray;
        try {
            byArray = TIMESTAMPTZ.toBytes(connection, Timestamp.valueOf(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            byArray = TIMESTAMPTZ.parseTimestampTz(connection, string);
        }
        return byArray;
    }

    public static byte[] toBytes(Connection connection, String string, Calendar calendar) throws SQLException {
        Calendar calendar2 = (Calendar)CAL_GMT_US.clone();
        Timestamp timestamp = TIMESTAMPTZ.parseTimestamp(string);
        calendar2.setTime(timestamp);
        Calendar calendar3 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
        calendar3.set(1, calendar2.get(1));
        calendar3.set(2, calendar2.get(2));
        calendar3.set(5, calendar2.get(5));
        calendar3.set(11, calendar2.get(11));
        calendar3.set(12, calendar2.get(12));
        calendar3.set(13, calendar2.get(13));
        calendar3.set(14, calendar2.get(14));
        int n2 = timestamp.getNanos();
        timestamp = new Timestamp(calendar3.getTime().getTime());
        timestamp.setNanos(n2);
        return TIMESTAMPTZ.toBytes(connection, timestamp, calendar);
    }

    @Override
    public String stringValue(Connection connection) throws SQLException {
        return TIMESTAMPTZ.toString(connection, this.getBytes());
    }

    public static byte[] toBytes(OffsetDateTime offsetDateTime) throws SQLException {
        if (offsetDateTime == null) {
            return null;
        }
        byte[] byArray = new byte[13];
        OffsetDateTime offsetDateTime2 = offsetDateTime.withOffsetSameInstant(ZoneOffset.UTC);
        int n2 = offsetDateTime2.getYear();
        int n3 = offsetDateTime2.getMonthValue();
        int n4 = offsetDateTime2.getDayOfMonth();
        int n5 = offsetDateTime2.getHour();
        int n6 = offsetDateTime2.getMinute();
        int n7 = offsetDateTime2.getSecond();
        int n8 = offsetDateTime2.getNano();
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)n3;
        byArray[3] = (byte)n4;
        byArray[4] = (byte)(n5 + 1);
        byArray[5] = (byte)(n6 + 1);
        byArray[6] = (byte)(n7 + 1);
        byArray[7] = (byte)(n8 >> 24);
        byArray[8] = (byte)(n8 >> 16 & 0xFF);
        byArray[9] = (byte)(n8 >> 8 & 0xFF);
        byArray[10] = (byte)(n8 & 0xFF);
        int n9 = offsetDateTime.getOffset().getTotalSeconds();
        byArray[11] = (byte)(n9 / HOUR_SECOND + OFFSET_HOUR);
        byArray[12] = (byte)(n9 % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] toBytes(ZonedDateTime zonedDateTime) throws SQLException {
        if (zonedDateTime == null) {
            return null;
        }
        byte[] byArray = new byte[13];
        OffsetDateTime offsetDateTime = zonedDateTime.toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC);
        int n2 = offsetDateTime.getYear();
        int n3 = offsetDateTime.getMonthValue();
        int n4 = offsetDateTime.getDayOfMonth();
        int n5 = offsetDateTime.getHour();
        int n6 = offsetDateTime.getMinute();
        int n7 = offsetDateTime.getSecond();
        int n8 = offsetDateTime.getNano();
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)n3;
        byArray[3] = (byte)n4;
        byArray[4] = (byte)(n5 + 1);
        byArray[5] = (byte)(n6 + 1);
        byArray[6] = (byte)(n7 + 1);
        byArray[7] = (byte)(n8 >> 24);
        byArray[8] = (byte)(n8 >> 16 & 0xFF);
        byArray[9] = (byte)(n8 >> 8 & 0xFF);
        byArray[10] = (byte)(n8 & 0xFF);
        ZoneId zoneId = zonedDateTime.getZone();
        String string = zoneId.getId();
        int n9 = ZONEIDMAP.getID(string);
        if (!ZONEIDMAP.isValidID(n9)) {
            ZoneRules zoneRules = zoneId.getRules();
            if (!zoneRules.isFixedOffset()) throw new SQLException("Timezone not supported: " + string);
            ZoneOffset zoneOffset = zoneRules.getOffset(zonedDateTime.toInstant());
            int n10 = zoneOffset.getTotalSeconds();
            byArray[11] = (byte)(n10 / HOUR_SECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n10 % HOUR_SECOND / MINUTE_SECOND + OFFSET_MINUTE);
            return byArray;
        } else {
            byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(n9);
            byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
            byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(n9);
        }
        return byArray;
    }

    public static byte[] toBytes(Connection connection, LocalDateTime localDateTime) throws SQLException {
        if (localDateTime == null) {
            return null;
        }
        ZoneId zoneId = null;
        String string = ((oracle.jdbc.OracleConnection)connection).getSessionTimeZone();
        zoneId = string != null ? ZoneId.of(string) : ZoneId.systemDefault();
        return TIMESTAMPTZ.toBytes(ZonedDateTime.of(localDateTime, zoneId));
    }

    public static byte[] toBytes(OffsetTime offsetTime) throws SQLException {
        if (offsetTime == null) {
            return null;
        }
        return TIMESTAMPTZ.toBytes(offsetTime.atDate(LocalDate.of(1970, 1, 1)));
    }

    public OffsetDateTime offsetDateTimeValue(Connection connection) throws SQLException {
        return TIMESTAMPTZ.toOffsetDateTime(connection, this.getBytes());
    }

    public ZonedDateTime zonedDateTimeValue() throws SQLException {
        return TIMESTAMPTZ.toZonedDateTime(this.getBytes());
    }

    public LocalDateTime localDateTimeValue() throws SQLException {
        return TIMESTAMPTZ.toLocalDateTime(this.getBytes());
    }

    public Date dateValue(Connection connection) throws SQLException {
        if (((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getTimestamptzInGmt()) {
            return TIMESTAMPTZ.toDate2(connection, this.getBytes());
        }
        return TIMESTAMPTZ.toDate(connection, this.getBytes());
    }

    public Time timeValue(Connection connection) throws SQLException {
        return TIMESTAMPTZ.toTime(connection, this.getBytes());
    }

    public TimeZone getTimeZone() throws SQLException {
        return TIMESTAMPTZ.getTimeZone(this.shareBytes());
    }

    private static TimeZone getTimeZone(byte[] byArray) throws SQLException {
        String string;
        if ((byArray[11] & REGIONIDBIT) != 0) {
            int n2 = TIMESTAMPTZ.getHighOrderbits(byArray[11]);
            string = ZONEIDMAP.getRegion(n2 += TIMESTAMPTZ.getLowOrderbits(byArray[12]));
        } else {
            int n3 = byArray[11] - OFFSET_HOUR;
            int n4 = byArray[12] - OFFSET_MINUTE;
            String string2 = n3 + ":";
            string2 = n4 == 0 ? string2 + "00" : string2 + "" + n4;
            string = "GMT" + (n3 >= 0 ? "+" : "") + string2;
        }
        return TimeZone.getTimeZone(string);
    }

    public static TIMESTAMPTZ of(ZonedDateTime zonedDateTime) throws SQLException {
        return new TIMESTAMPTZ(TIMESTAMPTZ.toBytes(zonedDateTime));
    }

    public ZonedDateTime toZonedDateTime() throws SQLException {
        return TIMESTAMPTZ.toZonedDateTime(this.getBytes());
    }

    public LocalDateTime toLocalDateTime() throws SQLException {
        return TIMESTAMPTZ.toLocalDateTime(this.getBytes());
    }

    public static LocalDateTime toLocalDateTime(byte[] byArray) throws SQLException {
        return TIMESTAMPTZ.toZonedDateTime(byArray).toLocalDateTime();
    }

    public static ZonedDateTime toZonedDateTime(byte[] byArray) throws SQLException {
        int n2;
        int n3;
        int[] nArray = new int[13];
        for (n3 = 0; n3 < 13; ++n3) {
            nArray[n3] = byArray[n3] & 0xFF;
        }
        n3 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        int n4 = TIMESTAMP.getNanos(byArray, 7);
        ZonedDateTime zonedDateTime = ZonedDateTime.of(n3, nArray[2], nArray[3], nArray[4] - 1, nArray[5] - 1, nArray[6] - 1, n4, ZoneId.of("UTC"));
        ZoneId zoneId = null;
        if ((nArray[11] & REGIONIDBIT) != 0) {
            n2 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            zoneId = ZoneId.of(ZONEIDMAP.getRegion(n2 += TIMESTAMPTZ.getLowOrderbits(nArray[12])));
        } else {
            n2 = nArray[11] - OFFSET_HOUR;
            int n5 = nArray[12] - OFFSET_MINUTE;
            zoneId = ZoneId.of(ZoneOffset.ofHoursMinutes(n2, n5).toString());
        }
        ZonedDateTime zonedDateTime2 = zonedDateTime.withZoneSameInstant(zoneId);
        return zonedDateTime2;
    }

    public OffsetTime toOffsetTime() throws SQLException {
        return TIMESTAMPTZ.toOffsetDateTime(this.getBytes()).toOffsetTime();
    }

    public static TIMESTAMPTZ of(OffsetDateTime offsetDateTime) throws SQLException {
        return new TIMESTAMPTZ(offsetDateTime);
    }

    public static TIMESTAMPTZ of(Connection connection, LocalDateTime localDateTime) throws SQLException {
        return new TIMESTAMPTZ(connection, localDateTime);
    }

    public OffsetDateTime toOffsetDateTime() throws SQLException {
        return TIMESTAMPTZ.toOffsetDateTime(this.getBytes());
    }

    private static Calendar getWorkCal(Connection connection, Calendar calendar) {
        String string;
        Calendar calendar2 = calendar == null ? ((string = ((oracle.jdbc.OracleConnection)connection).getSessionTimeZone()) != null ? Calendar.getInstance(TimeZone.getTimeZone(string)) : Calendar.getInstance()) : Calendar.getInstance(calendar.getTimeZone());
        return calendar2;
    }

    private static Calendar doCalWork(Connection connection, Calendar calendar, byte[] byArray) throws SQLException {
        Object object;
        int n2;
        if (calendar.getTimeZone().getID() == "Custom") {
            n2 = calendar.getTimeZone().getRawOffset();
            byArray[11] = (byte)(n2 / HOUR_MILLISECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n2 % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
        } else {
            object = calendar.getTimeZone().getID();
            int n3 = ZONEIDMAP.getID((String)object);
            if (!ZONEIDMAP.isValidID(n3)) {
                if (calendar.getTimeZone().useDaylightTime()) {
                    throw new SQLException("Timezone not supported: " + (String)object);
                }
                n2 = calendar.getTimeZone().getRawOffset();
                byArray[11] = (byte)(n2 / HOUR_MILLISECOND + OFFSET_HOUR);
                byArray[12] = (byte)(n2 % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
            } else {
                TIMEZONETAB tIMEZONETAB = TIMESTAMPTZ.getTIMEZONETAB(connection);
                if (tIMEZONETAB.checkID(n3)) {
                    tIMEZONETAB.updateTable(connection, n3);
                }
                OffsetDST offsetDST = new OffsetDST();
                byte by = tIMEZONETAB.getLocalOffset(calendar, n3, offsetDST);
                n2 = offsetDST.getOFFSET();
                boolean bl = calendar.getTimeZone().inDaylightTime(calendar.getTime());
                if (bl && by == 1) {
                    if (offsetDST.getDSTFLAG() == 0) {
                        n2 += HOUR_MILLISECOND;
                    } else {
                        throw new SQLException();
                    }
                }
                byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(n3);
                byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
                byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(n3);
            }
        }
        object = (Calendar)CAL_GMT_US.clone();
        ((Calendar)object).set(0, calendar.get(0));
        ((Calendar)object).set(1, calendar.get(1));
        ((Calendar)object).set(2, calendar.get(2));
        ((Calendar)object).set(5, calendar.get(5));
        ((Calendar)object).set(11, calendar.get(11));
        ((Calendar)object).set(12, calendar.get(12));
        ((Calendar)object).set(13, calendar.get(13));
        ((Calendar)object).add(14, -1 * n2);
        return object;
    }

    private static byte[] initTimestamptz() {
        byte[] byArray = new byte[13];
        Calendar calendar = Calendar.getInstance();
        byArray[0] = 119;
        byArray[1] = -86;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        String string = calendar.getTimeZone().getID();
        byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(string));
        byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
        byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(string));
        return byArray;
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }

    @Override
    public Object makeJdbcArray(int n2) {
        Timestamp[] timestampArray = new Timestamp[n2];
        return timestampArray;
    }

    @Override
    public boolean isConvertibleTo(Class<?> clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    private static Timestamp parseTimestamp(String string) throws SQLException {
        Object object;
        Object object2;
        int n2;
        String string2;
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string3 = string.trim();
        int n3 = string3.indexOf(32);
        if (n3 == -1) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string4 = string3.substring(0, n3).trim();
        if (string4 == null | (string2 = string3.substring(n3 + 1).trim()) == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int n4 = string4.indexOf(45);
        int n5 = string4.indexOf(45, n4 + 1);
        if (n4 < 1 || n5 < 1 || n5 == string4.length()) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string5 = string4.substring(0, n4);
        String string6 = string4.substring(n4 + 1, n5);
        String string7 = string4.substring(n5 + 1);
        if (string5.length() != 4 || string6.length() != 2 || string7.length() != 2) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int n6 = Integer.parseInt(string5);
        int n7 = Integer.parseInt(string6) - 1;
        int n8 = Integer.parseInt(string7);
        int n9 = string2.indexOf(58);
        int n10 = string2.indexOf(58, n9 + 1);
        if (n9 < 1 || n10 < 1 || n10 == string2.length()) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string8 = string2.substring(0, n9);
        String string9 = string2.substring(n9 + 1, n10);
        if (string8.length() != 2 || string9.length() != 2) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int n11 = Integer.parseInt(string8);
        int n12 = Integer.parseInt(string9);
        int n13 = 0;
        int n14 = string2.indexOf(46, n10 + 1);
        if (n14 == -1) {
            n2 = Integer.parseInt(string2.substring(n10 + 1));
        } else if (n14 > 0 && n14 < string2.length() - 1) {
            n2 = Integer.parseInt(string2.substring(n10 + 1, n14));
            object2 = string2.substring(n14 + 1);
            object = "000000000";
            if (((String)object2).length() > ((String)object).length() || !Character.isDigit(((String)object2).charAt(0))) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            object2 = (String)object2 + ((String)object).substring(0, ((String)object).length() - ((String)object2).length());
            n13 = Integer.parseInt((String)object2);
        } else {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        object2 = (Calendar)CAL_GMT_US.clone();
        ((Calendar)object2).set(1, n6);
        ((Calendar)object2).set(2, n7);
        ((Calendar)object2).set(5, n8);
        ((Calendar)object2).set(11, n11);
        ((Calendar)object2).set(12, n12);
        ((Calendar)object2).set(13, n2);
        ((Calendar)object2).set(14, 0);
        object = new Timestamp(((Calendar)object2).getTime().getTime());
        ((Timestamp)object).setNanos(n13);
        return object;
    }

    private static byte[] parseTimestampTz(Connection connection, String string) throws SQLException {
        Object object;
        Object object2;
        int n2;
        String string2;
        String string3;
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string4 = string.trim();
        int n3 = string4.indexOf(32);
        if (n3 == -1) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string5 = string4.substring(0, n3).trim();
        if (string5 == null | (string3 = string4.substring(n3 + 1).trim()) == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        boolean bl = false;
        if (string5.charAt(0) == '-') {
            bl = true;
            if (string5.length() > 1) {
                string5 = string5.substring(1);
            } else {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
        }
        int n4 = string5.indexOf(45);
        int n5 = string5.indexOf(45, n4 + 1);
        if (n4 < 1 || n5 < 1 || n5 == string5.length()) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string6 = string5.substring(0, n4);
        String string7 = string5.substring(n4 + 1, n5);
        String string8 = string5.substring(n5 + 1);
        if (string6.length() != 4 || string7.length() != 2 || string8.length() != 2) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int n6 = Integer.parseInt(string6);
        int n7 = Integer.parseInt(string7) - 1;
        int n8 = Integer.parseInt(string8);
        if (bl) {
            n6 = -n6;
        }
        int n9 = string3.indexOf(58);
        int n10 = string3.indexOf(58, n9 + 1);
        n3 = string3.indexOf(32);
        if (n3 != -1) {
            string2 = string3.substring(n3 + 1).trim();
            string3 = string3.substring(0, n3).trim();
        } else {
            string2 = null;
        }
        if (n9 < 1 || n10 < 1 || n10 == string3.length()) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        String string9 = string3.substring(0, n9);
        String string10 = string3.substring(n9 + 1, n10);
        if (string9.length() != 2 || string10.length() != 2) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int n11 = Integer.parseInt(string9);
        int n12 = Integer.parseInt(string10);
        int n13 = 0;
        int n14 = string3.indexOf(46, n10 + 1);
        if (n14 == -1) {
            n2 = Integer.parseInt(string3.substring(n10 + 1));
        } else if (n14 > 0 && n14 < string3.length() - 1) {
            n2 = Integer.parseInt(string3.substring(n10 + 1, n14));
            object2 = string3.substring(n14 + 1);
            object = "000000000";
            if (((String)object2).length() > ((String)object).length() || !Character.isDigit(((String)object2).charAt(0))) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            object2 = (String)object2 + ((String)object).substring(0, ((String)object).length() - ((String)object2).length());
            n13 = Integer.parseInt((String)object2);
        } else {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        object2 = null;
        if (string2 != null) {
            char c2 = string2.charAt(0);
            if (c2 == '-') {
                string2 = "GMT" + string2;
            } else if (Character.isDigit(c2)) {
                string2 = "GMT+" + string2;
            }
            object2 = Calendar.getInstance(TimeZone.getTimeZone(string2));
        }
        object = object2 == null ? (Calendar)CAL_GMT_US.clone() : object2;
        ((Calendar)object).set(1, n6);
        ((Calendar)object).set(2, n7);
        ((Calendar)object).set(5, n8);
        ((Calendar)object).set(11, n11);
        ((Calendar)object).set(12, n12);
        ((Calendar)object).set(13, n2);
        ((Calendar)object).set(14, 0);
        Timestamp timestamp = new Timestamp(((Calendar)object).getTime().getTime());
        timestamp.setNanos(n13);
        return TIMESTAMPTZ.toBytes(connection, timestamp, (Calendar)object2);
    }

    private static int setHighOrderbits(int n2) {
        return (n2 & 0x1FC0) >> 6;
    }

    private static int setLowOrderbits(int n2) {
        return (n2 & 0x3F) << 2;
    }

    private static int getHighOrderbits(int n2) {
        return (n2 & 0x7F) << 6;
    }

    private static int getLowOrderbits(int n2) {
        return (n2 & 0xFC) >> 2;
    }

    static TIMEZONETAB getTIMEZONETAB(Connection connection) throws SQLException {
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        return oracleConnection.getTIMEZONETAB();
    }
}

