/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.polynomials;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolynomialsUtils {
    private static final List<BigFraction> CHEBYSHEV_COEFFICIENTS = new ArrayList<BigFraction>();
    private static final List<BigFraction> HERMITE_COEFFICIENTS;
    private static final List<BigFraction> LAGUERRE_COEFFICIENTS;
    private static final List<BigFraction> LEGENDRE_COEFFICIENTS;
    private static final Map<JacobiKey, List<BigFraction>> JACOBI_COEFFICIENTS;

    private PolynomialsUtils() {
    }

    public static PolynomialFunction createChebyshevPolynomial(int degree) {
        return PolynomialsUtils.buildPolynomial(degree, CHEBYSHEV_COEFFICIENTS, new RecurrenceCoefficientsGenerator(){
            private final BigFraction[] coeffs = new BigFraction[]{BigFraction.ZERO, BigFraction.TWO, BigFraction.ONE};

            public BigFraction[] generate(int k2) {
                return this.coeffs;
            }
        });
    }

    public static PolynomialFunction createHermitePolynomial(int degree) {
        return PolynomialsUtils.buildPolynomial(degree, HERMITE_COEFFICIENTS, new RecurrenceCoefficientsGenerator(){

            public BigFraction[] generate(int k2) {
                return new BigFraction[]{BigFraction.ZERO, BigFraction.TWO, new BigFraction(2 * k2)};
            }
        });
    }

    public static PolynomialFunction createLaguerrePolynomial(int degree) {
        return PolynomialsUtils.buildPolynomial(degree, LAGUERRE_COEFFICIENTS, new RecurrenceCoefficientsGenerator(){

            public BigFraction[] generate(int k2) {
                int kP1 = k2 + 1;
                return new BigFraction[]{new BigFraction(2 * k2 + 1, kP1), new BigFraction(-1, kP1), new BigFraction(k2, kP1)};
            }
        });
    }

    public static PolynomialFunction createLegendrePolynomial(int degree) {
        return PolynomialsUtils.buildPolynomial(degree, LEGENDRE_COEFFICIENTS, new RecurrenceCoefficientsGenerator(){

            public BigFraction[] generate(int k2) {
                int kP1 = k2 + 1;
                return new BigFraction[]{BigFraction.ZERO, new BigFraction(k2 + kP1, kP1), new BigFraction(k2, kP1)};
            }
        });
    }

    public static PolynomialFunction createJacobiPolynomial(int degree, final int v2, final int w2) {
        JacobiKey key = new JacobiKey(v2, w2);
        if (!JACOBI_COEFFICIENTS.containsKey(key)) {
            ArrayList<BigFraction> list = new ArrayList<BigFraction>();
            JACOBI_COEFFICIENTS.put(key, list);
            list.add(BigFraction.ONE);
            list.add(new BigFraction(v2 - w2, 2));
            list.add(new BigFraction(2 + v2 + w2, 2));
        }
        return PolynomialsUtils.buildPolynomial(degree, JACOBI_COEFFICIENTS.get(key), new RecurrenceCoefficientsGenerator(){

            public BigFraction[] generate(int k2) {
                int kvw = ++k2 + v2 + w2;
                int twoKvw = kvw + k2;
                int twoKvwM1 = twoKvw - 1;
                int twoKvwM2 = twoKvw - 2;
                int den = 2 * k2 * kvw * twoKvwM2;
                return new BigFraction[]{new BigFraction(twoKvwM1 * (v2 * v2 - w2 * w2), den), new BigFraction(twoKvwM1 * twoKvw * twoKvwM2, den), new BigFraction(2 * (k2 + v2 - 1) * (k2 + w2 - 1) * twoKvw, den)};
            }
        });
    }

    public static double[] shift(double[] coefficients, double shift) {
        int i2;
        int dp1 = coefficients.length;
        double[] newCoefficients = new double[dp1];
        int[][] coeff = new int[dp1][dp1];
        for (i2 = 0; i2 < dp1; ++i2) {
            for (int j2 = 0; j2 <= i2; ++j2) {
                coeff[i2][j2] = (int)CombinatoricsUtils.binomialCoefficient(i2, j2);
            }
        }
        for (i2 = 0; i2 < dp1; ++i2) {
            newCoefficients[0] = newCoefficients[0] + coefficients[i2] * FastMath.pow(shift, i2);
        }
        int d2 = dp1 - 1;
        for (int i3 = 0; i3 < d2; ++i3) {
            for (int j3 = i3; j3 < d2; ++j3) {
                int n2 = i3 + 1;
                newCoefficients[n2] = newCoefficients[n2] + (double)coeff[j3 + 1][j3 - i3] * coefficients[j3 + 1] * FastMath.pow(shift, j3 - i3);
            }
        }
        return newCoefficients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PolynomialFunction buildPolynomial(int degree, List<BigFraction> coefficients, RecurrenceCoefficientsGenerator generator) {
        List<BigFraction> list = coefficients;
        synchronized (list) {
            int maxDegree = (int)FastMath.floor(FastMath.sqrt(2 * coefficients.size())) - 1;
            if (degree > maxDegree) {
                PolynomialsUtils.computeUpToDegree(degree, maxDegree, generator, coefficients);
            }
        }
        int start = degree * (degree + 1) / 2;
        double[] a2 = new double[degree + 1];
        for (int i2 = 0; i2 <= degree; ++i2) {
            a2[i2] = coefficients.get(start + i2).doubleValue();
        }
        return new PolynomialFunction(a2);
    }

    private static void computeUpToDegree(int degree, int maxDegree, RecurrenceCoefficientsGenerator generator, List<BigFraction> coefficients) {
        int startK = (maxDegree - 1) * maxDegree / 2;
        for (int k2 = maxDegree; k2 < degree; ++k2) {
            int startKm1 = startK;
            BigFraction[] ai2 = generator.generate(k2);
            BigFraction ck = coefficients.get(startK += k2);
            BigFraction ckm1 = coefficients.get(startKm1);
            coefficients.add(ck.multiply(ai2[0]).subtract(ckm1.multiply(ai2[2])));
            for (int i2 = 1; i2 < k2; ++i2) {
                BigFraction ckPrev = ck;
                ck = coefficients.get(startK + i2);
                ckm1 = coefficients.get(startKm1 + i2);
                coefficients.add(ck.multiply(ai2[0]).add(ckPrev.multiply(ai2[1])).subtract(ckm1.multiply(ai2[2])));
            }
            BigFraction ckPrev = ck;
            ck = coefficients.get(startK + k2);
            coefficients.add(ck.multiply(ai2[0]).add(ckPrev.multiply(ai2[1])));
            coefficients.add(ck.multiply(ai2[1]));
        }
    }

    static {
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ONE);
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ZERO);
        CHEBYSHEV_COEFFICIENTS.add(BigFraction.ONE);
        HERMITE_COEFFICIENTS = new ArrayList<BigFraction>();
        HERMITE_COEFFICIENTS.add(BigFraction.ONE);
        HERMITE_COEFFICIENTS.add(BigFraction.ZERO);
        HERMITE_COEFFICIENTS.add(BigFraction.TWO);
        LAGUERRE_COEFFICIENTS = new ArrayList<BigFraction>();
        LAGUERRE_COEFFICIENTS.add(BigFraction.ONE);
        LAGUERRE_COEFFICIENTS.add(BigFraction.ONE);
        LAGUERRE_COEFFICIENTS.add(BigFraction.MINUS_ONE);
        LEGENDRE_COEFFICIENTS = new ArrayList<BigFraction>();
        LEGENDRE_COEFFICIENTS.add(BigFraction.ONE);
        LEGENDRE_COEFFICIENTS.add(BigFraction.ZERO);
        LEGENDRE_COEFFICIENTS.add(BigFraction.ONE);
        JACOBI_COEFFICIENTS = new HashMap<JacobiKey, List<BigFraction>>();
    }

    private static interface RecurrenceCoefficientsGenerator {
        public BigFraction[] generate(int var1);
    }

    private static class JacobiKey {
        private final int v;
        private final int w;

        JacobiKey(int v2, int w2) {
            this.v = v2;
            this.w = w2;
        }

        public int hashCode() {
            return this.v << 16 ^ this.w;
        }

        public boolean equals(Object key) {
            if (key == null || !(key instanceof JacobiKey)) {
                return false;
            }
            JacobiKey otherK = (JacobiKey)key;
            return this.v == otherK.v && this.w == otherK.w;
        }
    }
}

