/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.analysis.solvers.AbstractPolynomialSolver;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.complex.ComplexUtils;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;

public class LaguerreSolver
extends AbstractPolynomialSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private final ComplexSolver complexSolver = new ComplexSolver();

    public LaguerreSolver() {
        this(1.0E-6);
    }

    public LaguerreSolver(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    public LaguerreSolver(double relativeAccuracy, double absoluteAccuracy) {
        super(relativeAccuracy, absoluteAccuracy);
    }

    public LaguerreSolver(double relativeAccuracy, double absoluteAccuracy, double functionValueAccuracy) {
        super(relativeAccuracy, absoluteAccuracy, functionValueAccuracy);
    }

    public double doSolve() throws TooManyEvaluationsException, NumberIsTooLargeException, NoBracketingException {
        double min2 = this.getMin();
        double max = this.getMax();
        double initial = this.getStartValue();
        double functionValueAccuracy = this.getFunctionValueAccuracy();
        this.verifySequence(min2, initial, max);
        double yInitial = this.computeObjectiveValue(initial);
        if (FastMath.abs(yInitial) <= functionValueAccuracy) {
            return initial;
        }
        double yMin = this.computeObjectiveValue(min2);
        if (FastMath.abs(yMin) <= functionValueAccuracy) {
            return min2;
        }
        if (yInitial * yMin < 0.0) {
            return this.laguerre(min2, initial, yMin, yInitial);
        }
        double yMax = this.computeObjectiveValue(max);
        if (FastMath.abs(yMax) <= functionValueAccuracy) {
            return max;
        }
        if (yInitial * yMax < 0.0) {
            return this.laguerre(initial, max, yInitial, yMax);
        }
        throw new NoBracketingException(min2, max, yMin, yMax);
    }

    @Deprecated
    public double laguerre(double lo, double hi, double fLo, double fHi) {
        Complex initial;
        Complex[] c2 = ComplexUtils.convertToComplex(this.getCoefficients());
        Complex z2 = this.complexSolver.solve(c2, initial = new Complex(0.5 * (lo + hi), 0.0));
        if (this.complexSolver.isRoot(lo, hi, z2)) {
            return z2.getReal();
        }
        double r2 = Double.NaN;
        Complex[] root = this.complexSolver.solveAll(c2, initial);
        for (int i2 = 0; i2 < root.length; ++i2) {
            if (!this.complexSolver.isRoot(lo, hi, root[i2])) continue;
            r2 = root[i2].getReal();
            break;
        }
        return r2;
    }

    public Complex[] solveAllComplex(double[] coefficients, double initial) throws NullArgumentException, NoDataException, TooManyEvaluationsException {
        return this.solveAllComplex(coefficients, initial, Integer.MAX_VALUE);
    }

    public Complex[] solveAllComplex(double[] coefficients, double initial, int maxEval) throws NullArgumentException, NoDataException, TooManyEvaluationsException {
        this.setup(maxEval, new PolynomialFunction(coefficients), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, initial);
        return this.complexSolver.solveAll(ComplexUtils.convertToComplex(coefficients), new Complex(initial, 0.0));
    }

    public Complex solveComplex(double[] coefficients, double initial) throws NullArgumentException, NoDataException, TooManyEvaluationsException {
        return this.solveComplex(coefficients, initial, Integer.MAX_VALUE);
    }

    public Complex solveComplex(double[] coefficients, double initial, int maxEval) throws NullArgumentException, NoDataException, TooManyEvaluationsException {
        this.setup(maxEval, new PolynomialFunction(coefficients), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, initial);
        return this.complexSolver.solve(ComplexUtils.convertToComplex(coefficients), new Complex(initial, 0.0));
    }

    private class ComplexSolver {
        private ComplexSolver() {
        }

        public boolean isRoot(double min2, double max, Complex z2) {
            if (LaguerreSolver.this.isSequence(min2, z2.getReal(), max)) {
                double tolerance = FastMath.max(LaguerreSolver.this.getRelativeAccuracy() * z2.abs(), LaguerreSolver.this.getAbsoluteAccuracy());
                return FastMath.abs(z2.getImaginary()) <= tolerance || z2.abs() <= LaguerreSolver.this.getFunctionValueAccuracy();
            }
            return false;
        }

        public Complex[] solveAll(Complex[] coefficients, Complex initial) throws NullArgumentException, NoDataException, TooManyEvaluationsException {
            if (coefficients == null) {
                throw new NullArgumentException();
            }
            int n2 = coefficients.length - 1;
            if (n2 == 0) {
                throw new NoDataException(LocalizedFormats.POLYNOMIAL);
            }
            Complex[] c2 = new Complex[n2 + 1];
            for (int i2 = 0; i2 <= n2; ++i2) {
                c2[i2] = coefficients[i2];
            }
            Complex[] root = new Complex[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                Complex[] subarray = new Complex[n2 - i3 + 1];
                System.arraycopy(c2, 0, subarray, 0, subarray.length);
                root[i3] = this.solve(subarray, initial);
                Complex newc = c2[n2 - i3];
                Complex oldc = null;
                for (int j2 = n2 - i3 - 1; j2 >= 0; --j2) {
                    oldc = c2[j2];
                    c2[j2] = newc;
                    newc = oldc.add(newc.multiply(root[i3]));
                }
            }
            return root;
        }

        public Complex solve(Complex[] coefficients, Complex initial) throws NullArgumentException, NoDataException, TooManyEvaluationsException {
            if (coefficients == null) {
                throw new NullArgumentException();
            }
            int n2 = coefficients.length - 1;
            if (n2 == 0) {
                throw new NoDataException(LocalizedFormats.POLYNOMIAL);
            }
            double absoluteAccuracy = LaguerreSolver.this.getAbsoluteAccuracy();
            double relativeAccuracy = LaguerreSolver.this.getRelativeAccuracy();
            double functionValueAccuracy = LaguerreSolver.this.getFunctionValueAccuracy();
            Complex nC = new Complex(n2, 0.0);
            Complex n1C = new Complex(n2 - 1, 0.0);
            Complex z2 = initial;
            Complex oldz = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            while (true) {
                Complex denominator;
                Complex pv = coefficients[n2];
                Complex dv = Complex.ZERO;
                Complex d2v = Complex.ZERO;
                for (int j2 = n2 - 1; j2 >= 0; --j2) {
                    d2v = dv.add(z2.multiply(d2v));
                    dv = pv.add(z2.multiply(dv));
                    pv = coefficients[j2].add(z2.multiply(pv));
                }
                d2v = d2v.multiply(new Complex(2.0, 0.0));
                double tolerance = FastMath.max(relativeAccuracy * z2.abs(), absoluteAccuracy);
                if (z2.subtract(oldz).abs() <= tolerance) {
                    return z2;
                }
                if (pv.abs() <= functionValueAccuracy) {
                    return z2;
                }
                Complex G = dv.divide(pv);
                Complex G2 = G.multiply(G);
                Complex H = G2.subtract(d2v.divide(pv));
                Complex delta = n1C.multiply(nC.multiply(H).subtract(G2));
                Complex deltaSqrt = delta.sqrt();
                Complex dplus = G.add(deltaSqrt);
                Complex dminus = G.subtract(deltaSqrt);
                Complex complex = denominator = dplus.abs() > dminus.abs() ? dplus : dminus;
                if (denominator.equals(new Complex(0.0, 0.0))) {
                    z2 = z2.add(new Complex(absoluteAccuracy, absoluteAccuracy));
                    oldz = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                } else {
                    oldz = z2;
                    z2 = z2.subtract(nC.divide(denominator));
                }
                LaguerreSolver.this.incrementEvaluationCount();
            }
        }
    }
}

