/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.ExceptionContext;
import org.apache.commons.math3.linear.DefaultIterativeLinearSolverEvent;
import org.apache.commons.math3.linear.NonPositiveDefiniteOperatorException;
import org.apache.commons.math3.linear.NonSquareOperatorException;
import org.apache.commons.math3.linear.PreconditionedIterativeLinearSolver;
import org.apache.commons.math3.linear.RealLinearOperator;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.IterationManager;

public class ConjugateGradient
extends PreconditionedIterativeLinearSolver {
    public static final String OPERATOR = "operator";
    public static final String VECTOR = "vector";
    private boolean check;
    private final double delta;

    public ConjugateGradient(int maxIterations, double delta, boolean check) {
        super(maxIterations);
        this.delta = delta;
        this.check = check;
    }

    public ConjugateGradient(IterationManager manager, double delta, boolean check) throws NullArgumentException {
        super(manager);
        this.delta = delta;
        this.check = check;
    }

    public final boolean getCheck() {
        return this.check;
    }

    public RealVector solveInPlace(RealLinearOperator a2, RealLinearOperator m3, RealVector b2, RealVector x0) throws NullArgumentException, NonPositiveDefiniteOperatorException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException {
        ConjugateGradient.checkParameters(a2, m3, b2, x0);
        IterationManager manager = this.getIterationManager();
        manager.resetIterationCount();
        double rmax = this.delta * b2.getNorm();
        RealVector bro = RealVector.unmodifiableRealVector(b2);
        manager.incrementIterationCount();
        RealVector x2 = x0;
        RealVector xro = RealVector.unmodifiableRealVector(x2);
        RealVector p2 = x2.copy();
        RealVector q2 = a2.operate(p2);
        RealVector r2 = b2.combine(1.0, -1.0, q2);
        RealVector rro = RealVector.unmodifiableRealVector(r2);
        double rnorm = r2.getNorm();
        RealVector z2 = m3 == null ? r2 : null;
        DefaultIterativeLinearSolverEvent evt = new DefaultIterativeLinearSolverEvent(this, manager.getIterations(), xro, bro, rro, rnorm);
        manager.fireInitializationEvent(evt);
        if (rnorm <= rmax) {
            manager.fireTerminationEvent(evt);
            return x2;
        }
        double rhoPrev = 0.0;
        do {
            manager.incrementIterationCount();
            evt = new DefaultIterativeLinearSolverEvent(this, manager.getIterations(), xro, bro, rro, rnorm);
            manager.fireIterationStartedEvent(evt);
            if (m3 != null) {
                z2 = m3.operate(r2);
            }
            double rhoNext = r2.dotProduct(z2);
            if (this.check && rhoNext <= 0.0) {
                NonPositiveDefiniteOperatorException e2 = new NonPositiveDefiniteOperatorException();
                ExceptionContext context = e2.getContext();
                context.setValue(OPERATOR, m3);
                context.setValue(VECTOR, r2);
                throw e2;
            }
            if (manager.getIterations() == 2) {
                p2.setSubVector(0, z2);
            } else {
                p2.combineToSelf(rhoNext / rhoPrev, 1.0, z2);
            }
            q2 = a2.operate(p2);
            double pq = p2.dotProduct(q2);
            if (this.check && pq <= 0.0) {
                NonPositiveDefiniteOperatorException e3 = new NonPositiveDefiniteOperatorException();
                ExceptionContext context = e3.getContext();
                context.setValue(OPERATOR, a2);
                context.setValue(VECTOR, p2);
                throw e3;
            }
            double alpha = rhoNext / pq;
            x2.combineToSelf(1.0, alpha, p2);
            r2.combineToSelf(1.0, -alpha, q2);
            rhoPrev = rhoNext;
            rnorm = r2.getNorm();
            evt = new DefaultIterativeLinearSolverEvent(this, manager.getIterations(), xro, bro, rro, rnorm);
            manager.fireIterationPerformedEvent(evt);
        } while (!(rnorm <= rmax));
        manager.fireTerminationEvent(evt);
        return x2;
    }
}

