/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.special;

import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.ContinuedFraction;
import org.apache.commons.math3.util.FastMath;

public class Beta {
    private static final double DEFAULT_EPSILON = 1.0E-14;
    private static final double HALF_LOG_TWO_PI = 0.9189385332046727;
    private static final double[] DELTA = new double[]{0.08333333333333333, -2.777777777777778E-5, 7.936507936507937E-8, -5.952380952380953E-10, 8.417508417508329E-12, -1.917526917518546E-13, 6.410256405103255E-15, -2.955065141253382E-16, 1.7964371635940225E-17, -1.3922896466162779E-18, 1.338028550140209E-19, -1.542460098679661E-20, 1.9770199298095743E-21, -2.3406566479399704E-22, 1.713480149663986E-23};

    private Beta() {
    }

    public static double regularizedBeta(double x2, double a2, double b2) {
        return Beta.regularizedBeta(x2, a2, b2, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double regularizedBeta(double x2, double a2, double b2, double epsilon) {
        return Beta.regularizedBeta(x2, a2, b2, epsilon, Integer.MAX_VALUE);
    }

    public static double regularizedBeta(double x2, double a2, double b2, int maxIterations) {
        return Beta.regularizedBeta(x2, a2, b2, 1.0E-14, maxIterations);
    }

    public static double regularizedBeta(double x2, final double a2, final double b2, double epsilon, int maxIterations) {
        double ret;
        if (Double.isNaN(x2) || Double.isNaN(a2) || Double.isNaN(b2) || x2 < 0.0 || x2 > 1.0 || a2 <= 0.0 || b2 <= 0.0) {
            ret = Double.NaN;
        } else if (x2 > (a2 + 1.0) / (2.0 + b2 + a2) && 1.0 - x2 <= (b2 + 1.0) / (2.0 + b2 + a2)) {
            ret = 1.0 - Beta.regularizedBeta(1.0 - x2, b2, a2, epsilon, maxIterations);
        } else {
            ContinuedFraction fraction = new ContinuedFraction(){

                protected double getB(int n2, double x2) {
                    double ret;
                    if (n2 % 2 == 0) {
                        double m3 = (double)n2 / 2.0;
                        ret = m3 * (b2 - m3) * x2 / ((a2 + 2.0 * m3 - 1.0) * (a2 + 2.0 * m3));
                    } else {
                        double m4 = ((double)n2 - 1.0) / 2.0;
                        ret = -((a2 + m4) * (a2 + b2 + m4) * x2) / ((a2 + 2.0 * m4) * (a2 + 2.0 * m4 + 1.0));
                    }
                    return ret;
                }

                protected double getA(int n2, double x2) {
                    return 1.0;
                }
            };
            ret = FastMath.exp(a2 * FastMath.log(x2) + b2 * FastMath.log1p(-x2) - FastMath.log(a2) - Beta.logBeta(a2, b2)) * 1.0 / fraction.evaluate(x2, epsilon, maxIterations);
        }
        return ret;
    }

    @Deprecated
    public static double logBeta(double a2, double b2, double epsilon, int maxIterations) {
        return Beta.logBeta(a2, b2);
    }

    private static double logGammaSum(double a2, double b2) throws OutOfRangeException {
        if (a2 < 1.0 || a2 > 2.0) {
            throw new OutOfRangeException(a2, (Number)1.0, 2.0);
        }
        if (b2 < 1.0 || b2 > 2.0) {
            throw new OutOfRangeException(b2, (Number)1.0, 2.0);
        }
        double x2 = a2 - 1.0 + (b2 - 1.0);
        if (x2 <= 0.5) {
            return Gamma.logGamma1p(1.0 + x2);
        }
        if (x2 <= 1.5) {
            return Gamma.logGamma1p(x2) + FastMath.log1p(x2);
        }
        return Gamma.logGamma1p(x2 - 1.0) + FastMath.log(x2 * (1.0 + x2));
    }

    private static double logGammaMinusLogGammaSum(double a2, double b2) throws NumberIsTooSmallException {
        double w2;
        double d2;
        if (a2 < 0.0) {
            throw new NumberIsTooSmallException(a2, (Number)0.0, true);
        }
        if (b2 < 10.0) {
            throw new NumberIsTooSmallException(b2, (Number)10.0, true);
        }
        if (a2 <= b2) {
            d2 = b2 + (a2 - 0.5);
            w2 = Beta.deltaMinusDeltaSum(a2, b2);
        } else {
            d2 = a2 + (b2 - 0.5);
            w2 = Beta.deltaMinusDeltaSum(b2, a2);
        }
        double u2 = d2 * FastMath.log1p(a2 / b2);
        double v2 = a2 * (FastMath.log(b2) - 1.0);
        return u2 <= v2 ? w2 - u2 - v2 : w2 - v2 - u2;
    }

    private static double deltaMinusDeltaSum(double a2, double b2) throws OutOfRangeException, NumberIsTooSmallException {
        if (a2 < 0.0 || a2 > b2) {
            throw new OutOfRangeException(a2, (Number)0, b2);
        }
        if (b2 < 10.0) {
            throw new NumberIsTooSmallException(b2, (Number)10, true);
        }
        double h2 = a2 / b2;
        double p2 = h2 / (1.0 + h2);
        double q2 = 1.0 / (1.0 + h2);
        double q22 = q2 * q2;
        double[] s2 = new double[DELTA.length];
        s2[0] = 1.0;
        for (int i2 = 1; i2 < s2.length; ++i2) {
            s2[i2] = 1.0 + (q2 + q22 * s2[i2 - 1]);
        }
        double sqrtT = 10.0 / b2;
        double t2 = sqrtT * sqrtT;
        double w2 = DELTA[DELTA.length - 1] * s2[s2.length - 1];
        for (int i3 = DELTA.length - 2; i3 >= 0; --i3) {
            w2 = t2 * w2 + DELTA[i3] * s2[i3];
        }
        return w2 * p2 / b2;
    }

    private static double sumDeltaMinusDeltaSum(double p2, double q2) {
        if (p2 < 10.0) {
            throw new NumberIsTooSmallException(p2, (Number)10.0, true);
        }
        if (q2 < 10.0) {
            throw new NumberIsTooSmallException(q2, (Number)10.0, true);
        }
        double a2 = FastMath.min(p2, q2);
        double b2 = FastMath.max(p2, q2);
        double sqrtT = 10.0 / a2;
        double t2 = sqrtT * sqrtT;
        double z2 = DELTA[DELTA.length - 1];
        for (int i2 = DELTA.length - 2; i2 >= 0; --i2) {
            z2 = t2 * z2 + DELTA[i2];
        }
        return z2 / a2 + Beta.deltaMinusDeltaSum(a2, b2);
    }

    public static double logBeta(double p2, double q2) {
        if (Double.isNaN(p2) || Double.isNaN(q2) || p2 <= 0.0 || q2 <= 0.0) {
            return Double.NaN;
        }
        double a2 = FastMath.min(p2, q2);
        double b2 = FastMath.max(p2, q2);
        if (a2 >= 10.0) {
            double v2;
            double w2 = Beta.sumDeltaMinusDeltaSum(a2, b2);
            double h2 = a2 / b2;
            double c2 = h2 / (1.0 + h2);
            double u2 = -(a2 - 0.5) * FastMath.log(c2);
            if (u2 <= (v2 = b2 * FastMath.log1p(h2))) {
                return -0.5 * FastMath.log(b2) + 0.9189385332046727 + w2 - u2 - v2;
            }
            return -0.5 * FastMath.log(b2) + 0.9189385332046727 + w2 - v2 - u2;
        }
        if (a2 > 2.0) {
            if (b2 > 1000.0) {
                int n2 = (int)FastMath.floor(a2 - 1.0);
                double prod = 1.0;
                double ared = a2;
                for (int i2 = 0; i2 < n2; ++i2) {
                    prod *= (ared -= 1.0) / (1.0 + ared / b2);
                }
                return FastMath.log(prod) - (double)n2 * FastMath.log(b2) + (Gamma.logGamma(ared) + Beta.logGammaMinusLogGammaSum(ared, b2));
            }
            double prod1 = 1.0;
            double ared = a2;
            while (ared > 2.0) {
                double h3 = (ared -= 1.0) / b2;
                prod1 *= h3 / (1.0 + h3);
            }
            if (b2 < 10.0) {
                double prod2 = 1.0;
                double bred = b2;
                while (bred > 2.0) {
                    prod2 *= (bred -= 1.0) / (ared + bred);
                }
                return FastMath.log(prod1) + FastMath.log(prod2) + (Gamma.logGamma(ared) + (Gamma.logGamma(bred) - Beta.logGammaSum(ared, bred)));
            }
            return FastMath.log(prod1) + Gamma.logGamma(ared) + Beta.logGammaMinusLogGammaSum(ared, b2);
        }
        if (a2 >= 1.0) {
            if (b2 > 2.0) {
                if (b2 < 10.0) {
                    double prod = 1.0;
                    double bred = b2;
                    while (bred > 2.0) {
                        prod *= (bred -= 1.0) / (a2 + bred);
                    }
                    return FastMath.log(prod) + (Gamma.logGamma(a2) + (Gamma.logGamma(bred) - Beta.logGammaSum(a2, bred)));
                }
                return Gamma.logGamma(a2) + Beta.logGammaMinusLogGammaSum(a2, b2);
            }
            return Gamma.logGamma(a2) + Gamma.logGamma(b2) - Beta.logGammaSum(a2, b2);
        }
        if (b2 >= 10.0) {
            return Gamma.logGamma(a2) + Beta.logGammaMinusLogGammaSum(a2, b2);
        }
        return FastMath.log(Gamma.gamma(a2) * Gamma.gamma(b2) / Gamma.gamma(a2 + b2));
    }
}

