/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;

public final class OptionConverter {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int ONE_K = 1024;

    private OptionConverter() {
    }

    public static String[] concatenateArrays(String[] l2, String[] r2) {
        int len = l2.length + r2.length;
        String[] a2 = new String[len];
        System.arraycopy(l2, 0, a2, 0, l2.length);
        System.arraycopy(r2, 0, a2, l2.length, r2.length);
        return a2;
    }

    public static String convertSpecialChars(String s2) {
        int len = s2.length();
        StringBuilder sbuf = new StringBuilder(len);
        int i2 = 0;
        while (i2 < len) {
            int c2;
            if ((c2 = s2.charAt(i2++)) == 92) {
                c2 = s2.charAt(i2++);
                switch (c2) {
                    case 110: {
                        c2 = 10;
                        break;
                    }
                    case 114: {
                        c2 = 13;
                        break;
                    }
                    case 116: {
                        c2 = 9;
                        break;
                    }
                    case 102: {
                        c2 = 12;
                        break;
                    }
                    case 98: {
                        c2 = 8;
                        break;
                    }
                    case 34: {
                        c2 = 34;
                        break;
                    }
                    case 39: {
                        c2 = 39;
                        break;
                    }
                    case 92: {
                        c2 = 92;
                        break;
                    }
                }
            }
            sbuf.append((char)c2);
        }
        return sbuf.toString();
    }

    public static Object instantiateByKey(Properties props, String key, Class<?> superClass, Object defaultValue) {
        String className = OptionConverter.findAndSubst(key, props);
        if (className == null) {
            LOGGER.error("Could not find value for key {}", (Object)key);
            return defaultValue;
        }
        return OptionConverter.instantiateByClassName(className.trim(), superClass, defaultValue);
    }

    public static boolean toBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String trimmedVal = value.trim();
        if ("true".equalsIgnoreCase(trimmedVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmedVal)) {
            return false;
        }
        return defaultValue;
    }

    public static int toInt(String value, int defaultValue) {
        if (value != null) {
            String s2 = value.trim();
            try {
                return Integer.parseInt(s2);
            }
            catch (NumberFormatException e2) {
                LOGGER.error("[{}] is not in proper int form.", (Object)s2, (Object)e2);
            }
        }
        return defaultValue;
    }

    public static Level toLevel(String value, Level defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        int hashIndex = (value = value.trim()).indexOf(35);
        if (hashIndex == -1) {
            if ("NULL".equalsIgnoreCase(value)) {
                return null;
            }
            return Level.toLevel(value, defaultValue);
        }
        Level result = defaultValue;
        String clazz = value.substring(hashIndex + 1);
        String levelName = value.substring(0, hashIndex);
        if ("NULL".equalsIgnoreCase(levelName)) {
            return null;
        }
        LOGGER.debug("toLevel:class=[" + clazz + "]:pri=[" + levelName + "]");
        try {
            Class<?> customLevel = Loader.loadClass(clazz);
            Class[] paramTypes = new Class[]{String.class, Level.class};
            Method toLevelMethod = customLevel.getMethod("toLevel", paramTypes);
            Object[] params = new Object[]{levelName, defaultValue};
            Object o2 = toLevelMethod.invoke(null, params);
            result = (Level)o2;
        }
        catch (ClassNotFoundException e2) {
            LOGGER.warn("custom level class [" + clazz + "] not found.");
        }
        catch (NoSuchMethodException e3) {
            LOGGER.warn("custom level class [" + clazz + "] does not have a class function toLevel(String, Level)", (Throwable)e3);
        }
        catch (InvocationTargetException e4) {
            if (e4.getTargetException() instanceof InterruptedException || e4.getTargetException() instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LOGGER.warn("custom level class [" + clazz + "] could not be instantiated", (Throwable)e4);
        }
        catch (ClassCastException e5) {
            LOGGER.warn("class [" + clazz + "] is not a subclass of org.apache.log4j.Level", (Throwable)e5);
        }
        catch (IllegalAccessException e6) {
            LOGGER.warn("class [" + clazz + "] cannot be instantiated due to access restrictions", (Throwable)e6);
        }
        catch (RuntimeException e7) {
            LOGGER.warn("class [" + clazz + "], level [" + levelName + "] conversion failed.", (Throwable)e7);
        }
        return result;
    }

    public static long toFileSize(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String str = value.trim().toUpperCase(Locale.ENGLISH);
        long multiplier = 1L;
        int index = str.indexOf("KB");
        if (index != -1) {
            multiplier = 1024L;
            str = str.substring(0, index);
        } else {
            index = str.indexOf("MB");
            if (index != -1) {
                multiplier = 0x100000L;
                str = str.substring(0, index);
            } else {
                index = str.indexOf("GB");
                if (index != -1) {
                    multiplier = 0x40000000L;
                    str = str.substring(0, index);
                }
            }
        }
        try {
            return Long.parseLong(str) * multiplier;
        }
        catch (NumberFormatException e2) {
            LOGGER.error("[{}] is not in proper int form.", (Object)str);
            LOGGER.error("[{}] not in expected format.", (Object)value, (Object)e2);
            return defaultValue;
        }
    }

    public static String findAndSubst(String key, Properties props) {
        String value = props.getProperty(key);
        if (value == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(value, props);
        }
        catch (IllegalArgumentException e2) {
            LOGGER.error("Bad option value [{}].", (Object)value, (Object)e2);
            return value;
        }
    }

    public static Object instantiateByClassName(String className, Class<?> superClass, Object defaultValue) {
        if (className != null) {
            try {
                Class<?> classObj = Loader.loadClass(className);
                if (!superClass.isAssignableFrom(classObj)) {
                    LOGGER.error("A \"{}\" object is not assignable to a \"{}\" variable.", (Object)className, (Object)superClass.getName());
                    LOGGER.error("The class \"{}\" was loaded by [{}] whereas object of type [{}] was loaded by [{}].", (Object)superClass.getName(), (Object)superClass.getClassLoader(), (Object)classObj.getTypeName(), (Object)classObj.getName());
                    return defaultValue;
                }
                return classObj.newInstance();
            }
            catch (Exception e2) {
                LOGGER.error("Could not instantiate class [{}].", (Object)className, (Object)e2);
            }
        }
        return defaultValue;
    }

    public static String substVars(String val, Properties props) throws IllegalArgumentException {
        return StrSubstitutor.replace((Object)val, props);
    }
}

