/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.IOException;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.poi.common.Duplicatable;
import org.apache.poi.common.usermodel.GenericRecord;
import org.apache.poi.hssf.record.HSSFRecordTypes;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.GenericRecordJsonWriter;

public abstract class Record
extends RecordBase
implements Duplicatable,
GenericRecord {
    protected Record() {
    }

    protected Record(Record other) {
    }

    public final byte[] serialize() {
        byte[] retval = new byte[this.getRecordSize()];
        this.serialize(0, retval);
        return retval;
    }

    public final String toString() {
        return GenericRecordJsonWriter.marshal(this);
    }

    public abstract short getSid();

    public Record cloneViaReserialise() {
        byte[] b2 = this.serialize();
        RecordInputStream rinp = null;
        try {
            rinp = new RecordInputStream(UnsynchronizedByteArrayInputStream.builder().setByteArray(b2).get());
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
        rinp.nextRecord();
        Record[] r2 = RecordFactory.createRecord(rinp);
        if (r2.length != 1) {
            throw new IllegalStateException("Re-serialised a record to clone it, but got " + r2.length + " records back!");
        }
        return r2[0];
    }

    @Override
    public abstract Record copy();

    public abstract HSSFRecordTypes getGenericRecordType();
}

