/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.HashSet;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.StyleRecord;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;

public class HSSFOptimiser {
    public static void optimiseFonts(HSSFWorkbook workbook) {
        int i2;
        short[] newPos = new short[workbook.getWorkbook().getNumberOfFontRecords() + 1];
        boolean[] zapRecords = new boolean[newPos.length];
        for (int i3 = 0; i3 < newPos.length; ++i3) {
            newPos[i3] = (short)i3;
            zapRecords[i3] = false;
        }
        FontRecord[] frecs = new FontRecord[newPos.length];
        for (i2 = 0; i2 < newPos.length; ++i2) {
            if (i2 == 4) continue;
            frecs[i2] = workbook.getWorkbook().getFontRecordAt(i2);
        }
        for (i2 = 5; i2 < newPos.length; ++i2) {
            int earlierDuplicate = -1;
            for (int j2 = 0; j2 < i2 && earlierDuplicate == -1; ++j2) {
                FontRecord frCheck;
                if (j2 == 4 || !(frCheck = workbook.getWorkbook().getFontRecordAt(j2)).sameProperties(frecs[i2])) continue;
                earlierDuplicate = j2;
            }
            if (earlierDuplicate == -1) continue;
            newPos[i2] = (short)earlierDuplicate;
            zapRecords[i2] = true;
        }
        for (i2 = 5; i2 < newPos.length; ++i2) {
            int preDeletePos;
            int newPosition = preDeletePos = newPos[i2];
            for (int j3 = 0; j3 < preDeletePos; ++j3) {
                if (!zapRecords[j3]) continue;
                newPosition = (short)(newPosition - 1);
            }
            newPos[i2] = newPosition;
        }
        for (i2 = 5; i2 < newPos.length; ++i2) {
            if (!zapRecords[i2]) continue;
            workbook.getWorkbook().removeFontRecord(frecs[i2]);
        }
        workbook.resetFontCache();
        for (i2 = 0; i2 < workbook.getWorkbook().getNumExFormats(); ++i2) {
            ExtendedFormatRecord xfr = workbook.getWorkbook().getExFormatAt(i2);
            xfr.setFontIndex(newPos[xfr.getFontIndex()]);
        }
        HashSet<UnicodeString> doneUnicodeStrings = new HashSet<UnicodeString>();
        for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); ++sheetNum) {
            HSSFSheet s2 = workbook.getSheetAt(sheetNum);
            for (Row row : s2) {
                for (Cell cell : row) {
                    HSSFRichTextString rtr;
                    UnicodeString u2;
                    if (cell.getCellType() != CellType.STRING || doneUnicodeStrings.contains(u2 = (rtr = (HSSFRichTextString)cell.getRichStringCellValue()).getRawUnicodeString())) continue;
                    for (short i4 = 5; i4 < newPos.length; i4 = (short)((short)(i4 + 1))) {
                        if (i4 == newPos[i4]) continue;
                        u2.swapFontUse(i4, newPos[i4]);
                    }
                    doneUnicodeStrings.add(u2);
                }
            }
        }
    }

    public static void optimiseCellStyles(HSSFWorkbook workbook) {
        int i2;
        short[] newPos = new short[workbook.getWorkbook().getNumExFormats()];
        boolean[] isUsed = new boolean[newPos.length];
        boolean[] zapRecords = new boolean[newPos.length];
        boolean[] userDefined = new boolean[newPos.length];
        ExtendedFormatRecord[] xfrs = new ExtendedFormatRecord[newPos.length];
        for (i2 = 0; i2 < newPos.length; ++i2) {
            isUsed[i2] = false;
            newPos[i2] = (short)i2;
            zapRecords[i2] = false;
            userDefined[i2] = HSSFOptimiser.isUserDefined(workbook, i2);
            xfrs[i2] = workbook.getWorkbook().getExFormatAt(i2);
        }
        for (i2 = 21; i2 < newPos.length; ++i2) {
            int earlierDuplicate = -1;
            for (int j2 = 0; j2 < i2; ++j2) {
                ExtendedFormatRecord xfCheck = workbook.getWorkbook().getExFormatAt(j2);
                if (!xfCheck.equals(xfrs[i2]) || userDefined[j2]) continue;
                earlierDuplicate = j2;
                break;
            }
            if (earlierDuplicate == -1) continue;
            newPos[i2] = (short)earlierDuplicate;
            zapRecords[i2] = true;
        }
        for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); ++sheetNum) {
            HSSFSheet s2 = workbook.getSheetAt(sheetNum);
            for (Row row : s2) {
                for (Cell cellI : row) {
                    HSSFCell cell = (HSSFCell)cellI;
                    short oldXf = cell.getCellValueRecord().getXFIndex();
                    if (oldXf >= newPos.length) continue;
                    isUsed[oldXf] = true;
                }
                short oldXf = ((HSSFRow)row).getRowRecord().getXFIndex();
                if (oldXf >= newPos.length) continue;
                isUsed[oldXf] = true;
            }
            for (int col = s2.getSheet().getMinColumnIndex(); col <= s2.getSheet().getMaxColumnIndex(); ++col) {
                short oldXf = s2.getSheet().getXFIndexForColAt((short)col);
                if (oldXf >= newPos.length) continue;
                isUsed[oldXf] = true;
            }
        }
        for (i2 = 21; i2 < isUsed.length; ++i2) {
            if (HSSFOptimiser.isUserDefined(workbook, i2)) {
                isUsed[i2] = true;
            }
            if (newPos[i2] == i2 || !isUsed[i2]) continue;
            isUsed[newPos[i2]] = true;
        }
        for (i2 = 21; i2 < isUsed.length; ++i2) {
            if (isUsed[i2]) continue;
            zapRecords[i2] = true;
            newPos[i2] = 0;
        }
        for (i2 = 21; i2 < newPos.length; ++i2) {
            int preDeletePos;
            int newPosition = preDeletePos = newPos[i2];
            for (int j3 = 0; j3 < preDeletePos; ++j3) {
                if (!zapRecords[j3]) continue;
                newPosition = (short)(newPosition - 1);
            }
            newPos[i2] = newPosition;
            if (i2 == newPosition || newPosition == 0) continue;
            workbook.getWorkbook().updateStyleRecord(i2, newPosition);
            ExtendedFormatRecord exFormat = workbook.getWorkbook().getExFormatAt(i2);
            short oldParent = exFormat.getParentIndex();
            if (oldParent >= newPos.length) continue;
            short newParent = newPos[oldParent];
            exFormat.setParentIndex(newParent);
        }
        int max = newPos.length;
        int removed = 0;
        for (int i3 = 21; i3 < max; ++i3) {
            if (!zapRecords[i3 + removed]) continue;
            workbook.getWorkbook().removeExFormatRecord(i3);
            --i3;
            --max;
            ++removed;
        }
        for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); ++sheetNum) {
            HSSFSheet s3 = workbook.getSheetAt(sheetNum);
            for (Row row : s3) {
                for (Cell cell : row) {
                    short oldXf = ((HSSFCell)cell).getCellValueRecord().getXFIndex();
                    if (oldXf >= newPos.length) continue;
                    HSSFCellStyle newStyle = workbook.getCellStyleAt(newPos[oldXf]);
                    cell.setCellStyle(newStyle);
                }
                short oldXf = ((HSSFRow)row).getRowRecord().getXFIndex();
                if (oldXf >= newPos.length) continue;
                HSSFCellStyle newStyle = workbook.getCellStyleAt(newPos[oldXf]);
                row.setRowStyle(newStyle);
            }
            for (int col = s3.getSheet().getMinColumnIndex(); col <= s3.getSheet().getMaxColumnIndex(); ++col) {
                short oldXf = s3.getSheet().getXFIndexForColAt((short)col);
                if (oldXf >= newPos.length) continue;
                HSSFCellStyle newStyle = workbook.getCellStyleAt(newPos[oldXf]);
                s3.setDefaultColumnStyle(col, newStyle);
            }
        }
    }

    private static boolean isUserDefined(HSSFWorkbook workbook, int index) {
        StyleRecord styleRecord = workbook.getWorkbook().getStyleRecord(index);
        return styleRecord != null && !styleRecord.isBuiltin() && styleRecord.getName() != null;
    }
}

