/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.poi.util.SuppressForbidden;

public class FontMetricsDumper {
    @SuppressForbidden(value="command line tool")
    public static void main(String[] args) throws IOException {
        Font[] allFonts;
        Properties props = new Properties();
        for (Font allFont : allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            int c2;
            char c3;
            String fontName = allFont.getFontName();
            Font font = new Font(fontName, 1, 10);
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            int fontHeight = fontMetrics.getHeight();
            props.setProperty("font." + fontName + ".height", fontHeight + "");
            StringBuilder characters = new StringBuilder();
            for (c3 = 'a'; c3 <= 'z'; c3 = (char)(c3 + '\u0001')) {
                characters.append(c3).append(", ");
            }
            for (c3 = 'A'; c3 <= 'Z'; c3 = (char)(c3 + '\u0001')) {
                characters.append(c3).append(", ");
            }
            for (c3 = '0'; c3 <= '9'; c3 = (char)(c3 + '\u0001')) {
                characters.append(c3).append(", ");
            }
            StringBuilder widths = new StringBuilder();
            for (c2 = 97; c2 <= 122; c2 = (int)((char)(c2 + 1))) {
                widths.append(fontMetrics.getWidths()[c2]).append(", ");
            }
            for (c2 = 65; c2 <= 90; c2 = (int)((char)(c2 + 1))) {
                widths.append(fontMetrics.getWidths()[c2]).append(", ");
            }
            for (c2 = 48; c2 <= 57; c2 = (int)((char)(c2 + 1))) {
                widths.append(fontMetrics.getWidths()[c2]).append(", ");
            }
            props.setProperty("font." + fontName + ".characters", characters.toString());
            props.setProperty("font." + fontName + ".widths", widths.toString());
        }
        try (OutputStream fileOut = Files.newOutputStream(Paths.get("font_metrics.properties", new String[0]), new OpenOption[0]);){
            props.store(fileOut, "Font Metrics");
        }
    }
}

