/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCalcCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCalcChain;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CalcChainDocument;

public class CalculationChain
extends POIXMLDocumentPart {
    private CTCalcChain chain;

    public CalculationChain() {
        this.chain = CTCalcChain.Factory.newInstance();
    }

    public CalculationChain(PackagePart part) throws IOException {
        super(part);
        try (InputStream stream = part.getInputStream();){
            this.readFrom(stream);
        }
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            CalcChainDocument doc = (CalcChainDocument)CalcChainDocument.Factory.parse(is, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            this.chain = doc.getCalcChain();
        }
        catch (XmlException e2) {
            throw new IOException(e2.getLocalizedMessage());
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        CalcChainDocument doc = CalcChainDocument.Factory.newInstance();
        doc.setCalcChain(this.chain);
        doc.save(out, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        try (OutputStream out = part.getOutputStream();){
            this.writeTo(out);
        }
    }

    public CTCalcChain getCTCalcChain() {
        return this.chain;
    }

    public void removeItem(int sheetId, String ref) {
        int id = -1;
        CTCalcCell[] c2 = this.chain.getCArray();
        for (int i2 = 0; i2 < c2.length; ++i2) {
            if (c2[i2].isSetI()) {
                id = c2[i2].getI();
            }
            if (id != sheetId || !c2[i2].getR().equals(ref)) continue;
            if (c2[i2].isSetI() && i2 < c2.length - 1 && !c2[i2 + 1].isSetI()) {
                c2[i2 + 1].setI(id);
            }
            this.chain.removeC(i2);
            break;
        }
    }
}

