/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.util.Internal;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFAbstractFootnotesEndnotes;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdn;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

public abstract class XWPFAbstractFootnoteEndnote
implements Iterable<XWPFParagraph>,
IBody {
    private final List<XWPFParagraph> paragraphs = new ArrayList<XWPFParagraph>();
    private final List<XWPFTable> tables = new ArrayList<XWPFTable>();
    private final List<XWPFPictureData> pictures = new ArrayList<XWPFPictureData>();
    private final List<IBodyElement> bodyElements = new ArrayList<IBodyElement>();
    protected CTFtnEdn ctFtnEdn;
    protected XWPFAbstractFootnotesEndnotes footnotes;
    protected XWPFDocument document;

    public XWPFAbstractFootnoteEndnote() {
    }

    @Internal
    protected XWPFAbstractFootnoteEndnote(XWPFDocument document, CTFtnEdn body) {
        this.ctFtnEdn = body;
        this.document = document;
        this.init();
    }

    @Internal
    protected XWPFAbstractFootnoteEndnote(CTFtnEdn note, XWPFAbstractFootnotesEndnotes footnotes) {
        this.footnotes = footnotes;
        this.ctFtnEdn = note;
        this.document = footnotes.getXWPFDocument();
        this.init();
    }

    protected void init() {
        try (XmlCursor cursor = this.ctFtnEdn.newCursor();){
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o2 = cursor.getObject();
                if (o2 instanceof CTP) {
                    XWPFParagraph p2 = new XWPFParagraph((CTP)o2, this);
                    this.bodyElements.add(p2);
                    this.paragraphs.add(p2);
                    continue;
                }
                if (o2 instanceof CTTbl) {
                    XWPFTable t2 = new XWPFTable((CTTbl)o2, this, false);
                    this.bodyElements.add(t2);
                    this.tables.add(t2);
                    continue;
                }
                if (!(o2 instanceof CTSdtBlock)) continue;
                XWPFSDT c2 = new XWPFSDT((CTSdtBlock)o2, (IBody)this);
                this.bodyElements.add(c2);
            }
        }
    }

    @Override
    public List<XWPFParagraph> getParagraphs() {
        return this.paragraphs;
    }

    @Override
    public Iterator<XWPFParagraph> iterator() {
        return this.paragraphs.iterator();
    }

    @Override
    public Spliterator<XWPFParagraph> spliterator() {
        return this.paragraphs.spliterator();
    }

    @Override
    public List<XWPFTable> getTables() {
        return this.tables;
    }

    public List<XWPFPictureData> getPictures() {
        return this.pictures;
    }

    @Override
    public List<IBodyElement> getBodyElements() {
        return this.bodyElements;
    }

    public CTFtnEdn getCTFtnEdn() {
        return this.ctFtnEdn;
    }

    public void setCTFtnEdn(CTFtnEdn footnote) {
        this.ctFtnEdn = footnote;
    }

    @Override
    public XWPFTable getTableArray(int pos) {
        if (pos >= 0 && pos < this.tables.size()) {
            return this.tables.get(pos);
        }
        return null;
    }

    @Override
    public void insertTable(int pos, XWPFTable table) {
        this.bodyElements.add(pos, table);
        int i2 = 0;
        for (CTTbl tbl : this.ctFtnEdn.getTblList()) {
            if (tbl == table.getCTTbl()) break;
            ++i2;
        }
        this.tables.add(i2, table);
    }

    @Override
    public XWPFTable getTable(CTTbl ctTable) {
        for (XWPFTable table : this.tables) {
            if (table == null) {
                return null;
            }
            if (!table.getCTTbl().equals(ctTable)) continue;
            return table;
        }
        return null;
    }

    @Override
    public XWPFParagraph getParagraph(CTP p2) {
        for (XWPFParagraph paragraph : this.paragraphs) {
            if (!paragraph.getCTP().equals(p2)) continue;
            return paragraph;
        }
        return null;
    }

    @Override
    public XWPFParagraph getParagraphArray(int pos) {
        if (pos >= 0 && pos < this.paragraphs.size()) {
            return this.paragraphs.get(pos);
        }
        return null;
    }

    @Override
    public XWPFTableCell getTableCell(CTTc cell) {
        CTRow row;
        XmlObject o2;
        try (XmlCursor cursor = cell.newCursor();){
            cursor.toParent();
            o2 = cursor.getObject();
            if (!(o2 instanceof CTRow)) {
                XWPFTableCell xWPFTableCell = null;
                return xWPFTableCell;
            }
            row = (CTRow)o2;
            cursor.toParent();
            o2 = cursor.getObject();
        }
        if (!(o2 instanceof CTTbl)) {
            return null;
        }
        CTTbl tbl = (CTTbl)o2;
        XWPFTable table = this.getTable(tbl);
        if (table == null) {
            return null;
        }
        XWPFTableRow tableRow = table.getRow(row);
        if (tableRow == null) {
            return null;
        }
        return tableRow.getTableCell(cell);
    }

    private boolean isCursorInFtn(XmlCursor cursor) {
        try (XmlCursor verify = cursor.newCursor();){
            verify.toParent();
            boolean bl = verify.getObject() == this.ctFtnEdn;
            return bl;
        }
    }

    public POIXMLDocumentPart getOwner() {
        return this.footnotes;
    }

    @Override
    public XWPFTable insertNewTbl(XmlCursor cursor) {
        if (this.isCursorInFtn(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t2 = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t2, this);
            cursor.removeXmlContents();
            XmlObject o2 = null;
            while (!(o2 instanceof CTTbl) && cursor.toPrevSibling()) {
                o2 = cursor.getObject();
            }
            if (!(o2 instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o2)) + 1;
                this.tables.add(pos, newT);
            }
            int i2 = 0;
            try (XmlCursor cursor1 = t2.newCursor();){
                while (cursor1.toPrevSibling()) {
                    o2 = cursor1.getObject();
                    if (!(o2 instanceof CTP) && !(o2 instanceof CTTbl)) continue;
                    ++i2;
                }
                this.bodyElements.add(i2, newT);
            }
            var9_9 = null;
            try (XmlCursor c2 = t2.newCursor();){
                cursor.toCursor(c2);
                cursor.toEndToken();
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            return newT;
        }
        return null;
    }

    @Override
    public XWPFParagraph insertNewParagraph(XmlCursor cursor) {
        if (this.isCursorInFtn(cursor)) {
            String uri = CTP.type.getName().getNamespaceURI();
            String localPart = "p";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTP p2 = (CTP)cursor.getObject();
            XWPFParagraph newP = new XWPFParagraph(p2, this);
            XmlObject o2 = null;
            while (!(o2 instanceof CTP) && cursor.toPrevSibling()) {
                o2 = cursor.getObject();
            }
            if (!(o2 instanceof CTP) || o2 == p2) {
                this.paragraphs.add(0, newP);
            } else {
                int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o2)) + 1;
                this.paragraphs.add(pos, newP);
            }
            int i2 = 0;
            try (XmlCursor p22 = p2.newCursor();){
                cursor.toCursor(p22);
            }
            while (cursor.toPrevSibling()) {
                o2 = cursor.getObject();
                if (!(o2 instanceof CTP) && !(o2 instanceof CTTbl)) continue;
                ++i2;
            }
            this.bodyElements.add(i2, newP);
            p22 = p2.newCursor();
            var9_9 = null;
            try {
                cursor.toCursor(p22);
                cursor.toEndToken();
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            finally {
                if (p22 != null) {
                    if (var9_9 != null) {
                        try {
                            p22.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        p22.close();
                    }
                }
            }
            return newP;
        }
        return null;
    }

    public XWPFTable addNewTbl(CTTbl table) {
        CTTbl newTable = this.ctFtnEdn.addNewTbl();
        newTable.set(table);
        XWPFTable xTable = new XWPFTable(newTable, this);
        this.tables.add(xTable);
        return xTable;
    }

    public XWPFParagraph addNewParagraph(CTP paragraph) {
        CTP newPara = this.ctFtnEdn.addNewP();
        newPara.set(paragraph);
        XWPFParagraph xPara = new XWPFParagraph(newPara, this);
        this.paragraphs.add(xPara);
        return xPara;
    }

    @Override
    public XWPFDocument getXWPFDocument() {
        return this.document;
    }

    @Override
    public POIXMLDocumentPart getPart() {
        return this.footnotes;
    }

    @Override
    public BodyType getPartType() {
        return BodyType.FOOTNOTE;
    }

    public BigInteger getId() {
        return this.ctFtnEdn.getId();
    }

    public XWPFParagraph createParagraph() {
        XWPFParagraph p2 = new XWPFParagraph(this.ctFtnEdn.addNewP(), this);
        this.paragraphs.add(p2);
        this.bodyElements.add(p2);
        if (p2.equals(this.getParagraphs().get(0))) {
            this.ensureFootnoteRef(p2);
        }
        return p2;
    }

    public abstract void ensureFootnoteRef(XWPFParagraph var1);

    public XWPFTable createTable() {
        XWPFTable table = new XWPFTable(this.ctFtnEdn.addNewTbl(), this);
        if (this.bodyElements.isEmpty()) {
            XWPFParagraph p2 = this.createParagraph();
            this.ensureFootnoteRef(p2);
        }
        this.bodyElements.add(table);
        this.tables.add(table);
        return table;
    }

    public XWPFTable createTable(int rows, int cols) {
        XWPFTable table = new XWPFTable(this.ctFtnEdn.addNewTbl(), this, rows, cols);
        this.bodyElements.add(table);
        this.tables.add(table);
        return table;
    }
}

