/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;
import org.apache.xmlbeans.impl.util.XsTypeConverter;
import org.apache.xmlbeans.impl.values.NamespaceManager;
import org.apache.xmlbeans.impl.values.XmlObjectBase;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;

public abstract class JavaIntHolder
extends XmlObjectBase {
    private int _value;
    static final BigInteger _max = BigInteger.valueOf(Integer.MAX_VALUE);
    static final BigInteger _min = BigInteger.valueOf(Integer.MIN_VALUE);

    @Override
    public SchemaType schemaType() {
        return BuiltinSchemaTypeSystem.ST_INT;
    }

    @Override
    public String compute_text(NamespaceManager nsm) {
        return Long.toString(this._value);
    }

    @Override
    protected void set_text(String s2) {
        try {
            this.set_int(XsTypeConverter.lexInt(s2));
        }
        catch (Exception e2) {
            throw new XmlValueOutOfRangeException("int", new Object[]{s2});
        }
    }

    @Override
    protected void set_nil() {
        this._value = 0;
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        this.check_dated();
        return BigDecimal.valueOf((double)this._value);
    }

    @Override
    public BigInteger getBigIntegerValue() {
        this.check_dated();
        return BigInteger.valueOf(this._value);
    }

    @Override
    public long getLongValue() {
        this.check_dated();
        return this._value;
    }

    @Override
    public int getIntValue() {
        this.check_dated();
        return this._value;
    }

    @Override
    protected void set_BigDecimal(BigDecimal v2) {
        this.set_BigInteger(v2.toBigInteger());
    }

    @Override
    protected void set_BigInteger(BigInteger v2) {
        if (v2.compareTo(_max) > 0 || v2.compareTo(_min) < 0) {
            throw new XmlValueOutOfRangeException();
        }
        this.set_int(v2.intValue());
    }

    @Override
    protected void set_long(long l2) {
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw new XmlValueOutOfRangeException();
        }
        this.set_int((int)l2);
    }

    @Override
    protected void set_int(int i2) {
        this._value = i2;
    }

    @Override
    protected int compare_to(XmlObject i2) {
        if (((SimpleValue)i2).instanceType().getDecimalSize() > 32) {
            return -i2.compareTo(this);
        }
        return Integer.compare(this._value, ((XmlObjectBase)i2).getIntValue());
    }

    @Override
    protected boolean equal_to(XmlObject i2) {
        if (((SimpleValue)i2).instanceType().getDecimalSize() > 32) {
            return i2.valueEquals(this);
        }
        return this._value == ((XmlObjectBase)i2).getIntValue();
    }

    @Override
    protected int value_hash_code() {
        return this._value;
    }
}

