/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.soap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.impl.common.PrefixResolver;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.XmlWhitespace;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;

public final class SOAPArrayType {
    private QName _type;
    private int[] _ranks;
    private int[] _dimensions;
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public boolean isSameRankAs(SOAPArrayType otherType) {
        return Arrays.equals(this._ranks, otherType._ranks) && this._dimensions.length == otherType._dimensions.length;
    }

    private static int[] internalParseCommaIntString(String csl) {
        ArrayList<String> dimStrings = new ArrayList<String>();
        int i2 = 0;
        while (true) {
            int j2;
            if ((j2 = csl.indexOf(44, i2)) < 0) break;
            dimStrings.add(csl.substring(i2, j2));
            i2 = j2 + 1;
        }
        dimStrings.add(csl.substring(i2));
        return dimStrings.stream().mapToInt(SOAPArrayType::collapseDimString).toArray();
    }

    private static int collapseDimString(String dimString2) {
        String dimString = XmlWhitespace.collapse(dimString2, 3);
        try {
            return "*".equals(dimString) || dimString.isEmpty() ? -1 : Integer.parseInt(dimString);
        }
        catch (Exception e2) {
            throw new XmlValueOutOfRangeException("Malformed integer in SOAP array index");
        }
    }

    public SOAPArrayType(String s2, PrefixResolver m3) {
        String uri;
        int firstbrace = s2.indexOf(91);
        if (firstbrace < 0) {
            throw new XmlValueOutOfRangeException();
        }
        String firstpart = XmlWhitespace.collapse(s2.substring(0, firstbrace), 3);
        int firstcolon = firstpart.indexOf(58);
        String prefix = "";
        if (firstcolon >= 0) {
            prefix = firstpart.substring(0, firstcolon);
        }
        if ((uri = m3.getNamespaceForPrefix(prefix)) == null) {
            throw new XmlValueOutOfRangeException();
        }
        this._type = QNameHelper.forLNS(firstpart.substring(firstcolon + 1), uri);
        this.initDimensions(s2, firstbrace);
    }

    public SOAPArrayType(QName name, String dimensions) {
        int firstbrace = dimensions.indexOf(91);
        if (firstbrace < 0) {
            this._type = name;
            this._ranks = EMPTY_INT_ARRAY;
            dimensions = XmlWhitespace.collapse(dimensions, 3);
            String[] dimStrings = dimensions.split(" ");
            for (int i2 = 0; i2 < dimStrings.length; ++i2) {
                String dimString = dimStrings[i2];
                if (dimString.equals("*")) {
                    this._dimensions[i2] = -1;
                    continue;
                }
                try {
                    this._dimensions[i2] = Integer.parseInt(dimStrings[i2]);
                    continue;
                }
                catch (Exception e2) {
                    throw new XmlValueOutOfRangeException();
                }
            }
        } else {
            this._type = name;
            this.initDimensions(dimensions, firstbrace);
        }
    }

    public SOAPArrayType(SOAPArrayType nested, int[] dimensions) {
        this._type = nested._type;
        this._ranks = new int[nested._ranks.length + 1];
        System.arraycopy(nested._ranks, 0, this._ranks, 0, nested._ranks.length);
        this._ranks[this._ranks.length - 1] = nested._dimensions.length;
        this._dimensions = new int[dimensions.length];
        System.arraycopy(dimensions, 0, this._dimensions, 0, dimensions.length);
    }

    private void initDimensions(String s2, int firstbrace) {
        ArrayList<String> braces = new ArrayList<String>();
        int lastbrace = -1;
        int i2 = firstbrace;
        while (i2 >= 0) {
            lastbrace = s2.indexOf(93, i2);
            if (lastbrace < 0) {
                throw new XmlValueOutOfRangeException();
            }
            braces.add(s2.substring(i2 + 1, lastbrace));
            i2 = s2.indexOf(91, lastbrace);
        }
        String trailer = s2.substring(lastbrace + 1);
        if (!XmlWhitespace.isAllSpace(trailer)) {
            throw new XmlValueOutOfRangeException();
        }
        this._ranks = new int[braces.size() - 1];
        for (int i3 = 0; i3 < this._ranks.length; ++i3) {
            String commas = (String)braces.get(i3);
            int commacount = 0;
            for (int j2 = 0; j2 < commas.length(); ++j2) {
                char ch = commas.charAt(j2);
                if (ch == ',') {
                    ++commacount;
                    continue;
                }
                if (XmlWhitespace.isSpace(ch)) continue;
                throw new XmlValueOutOfRangeException();
            }
            this._ranks[i3] = commacount + 1;
        }
        this._dimensions = SOAPArrayType.internalParseCommaIntString((String)braces.get(braces.size() - 1));
    }

    public QName getQName() {
        return this._type;
    }

    public int[] getRanks() {
        int[] result = new int[this._ranks.length];
        System.arraycopy(this._ranks, 0, result, 0, result.length);
        return result;
    }

    public int[] getDimensions() {
        int[] result = new int[this._dimensions.length];
        System.arraycopy(this._dimensions, 0, result, 0, result.length);
        return result;
    }

    public boolean containsNestedArrays() {
        return this._ranks.length > 0;
    }

    public String soap11DimensionString() {
        return this.soap11DimensionString(this._dimensions);
    }

    public String soap11DimensionString(int[] actualDimensions) {
        StringBuilder sb = new StringBuilder();
        for (int rank : this._ranks) {
            sb.append('[');
            for (int j2 = 1; j2 < rank; ++j2) {
                sb.append(',');
            }
            sb.append(']');
        }
        sb.append(IntStream.of(actualDimensions).mapToObj(i2 -> i2 >= 0 ? Integer.toString(i2) : "").collect(Collectors.joining(",", "[", "]")));
        return sb.toString();
    }

    private SOAPArrayType() {
    }

    public static SOAPArrayType newSoap12Array(QName itemType, String arraySize) {
        arraySize = XmlWhitespace.collapse(arraySize, 3);
        String[] dimStrings = arraySize.split(" ");
        int[] dimensions = new int[dimStrings.length];
        for (int i2 = 0; i2 < dimStrings.length; ++i2) {
            String dimString = dimStrings[i2];
            if (i2 == 0 && dimString.equals("*")) {
                dimensions[i2] = -1;
                continue;
            }
            try {
                dimensions[i2] = Integer.parseInt(dimStrings[i2]);
                continue;
            }
            catch (Exception e2) {
                throw new XmlValueOutOfRangeException();
            }
        }
        SOAPArrayType sot = new SOAPArrayType();
        sot._ranks = EMPTY_INT_ARRAY;
        sot._type = itemType;
        sot._dimensions = dimensions;
        return sot;
    }

    public String soap12DimensionString(int[] actualDimensions) {
        return IntStream.of(actualDimensions).mapToObj(i2 -> i2 >= 0 ? Integer.toString(i2) : "").collect(Collectors.joining(" "));
    }

    public SOAPArrayType nestedArrayType() {
        if (!this.containsNestedArrays()) {
            throw new IllegalStateException();
        }
        SOAPArrayType result = new SOAPArrayType();
        result._type = this._type;
        result._ranks = new int[this._ranks.length - 1];
        System.arraycopy(this._ranks, 0, result._ranks, 0, result._ranks.length);
        result._dimensions = new int[this._ranks[this._ranks.length - 1]];
        Arrays.fill(result._dimensions, -1);
        return result;
    }

    public int hashCode() {
        return this._type.hashCode() + this._dimensions.length + this._ranks.length + (this._dimensions.length == 0 ? 0 : this._dimensions[0]);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SOAPArrayType)) {
            return false;
        }
        SOAPArrayType sat = (SOAPArrayType)obj;
        return this._type.equals(sat._type) && Arrays.equals(this._ranks, sat._ranks) && Arrays.equals(this._dimensions, sat._dimensions);
    }
}

