/*
 * Decompiled with CFR 0.152.
 */
package top.tanmw.db2dict.db;

import cn.hutool.core.util.StrUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tanmw.db2dict.db.DbConfig;
import top.tanmw.db2dict.entity.DbConstant;
import top.tanmw.db2dict.entity.TableInfo;

public abstract class AbstractDbConfig
implements DbConfig {
    private static final Logger log = LoggerFactory.getLogger(AbstractDbConfig.class);
    public Connection connection = null;
    public DatabaseMetaData metaData = null;
    public String username = "";
    public String[] excludePrefixList = new String[0];
    public String[] includePrefixList = new String[0];

    @Override
    public void init(Properties properties) {
        try {
            String includePrefix;
            log.info("...\u8fde\u63a5\u6570\u636e\u5e93...");
            String driver = properties.getProperty(DbConstant.DRIVER);
            String url = properties.getProperty(DbConstant.URL);
            this.username = properties.getProperty(DbConstant.USERNAME);
            String password = properties.getProperty(DbConstant.PASSWORD);
            Class.forName(driver);
            this.connection = DriverManager.getConnection(url, this.username, password);
            this.metaData = this.connection.getMetaData();
            String excludePrefix = properties.getProperty(DbConstant.EXCLUDE_PREFIX);
            if (StrUtil.isNotBlank(excludePrefix)) {
                this.excludePrefixList = excludePrefix.split(",");
                this.excludePrefixList = (String[])Arrays.stream(this.excludePrefixList).map(String::toLowerCase).toArray(String[]::new);
            }
            if (StrUtil.isNotBlank(includePrefix = properties.getProperty(DbConstant.INCLUDE_PREFIX))) {
                this.includePrefixList = includePrefix.split(",");
                this.includePrefixList = (String[])Arrays.stream(this.includePrefixList).map(String::toLowerCase).toArray(String[]::new);
            }
        }
        catch (Exception e2) {
            log.error("\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25", e2);
        }
    }

    @Override
    public List<TableInfo> getTableList() throws Exception {
        log.info("...\u5f00\u59cb\u8bfb\u53d6\u8868\u4fe1\u606f...");
        ResultSet tableResultSet = this.metaData.getTables(null, "%", "%", new String[]{"TABLE"});
        ArrayList<TableInfo> tableInfoList = new ArrayList<TableInfo>(64);
        while (tableResultSet.next()) {
            String tableName = tableResultSet.getString("TABLE_NAME");
            String remarkes = tableResultSet.getString("REMARKS");
            remarkes = StrUtil.isNotBlank(remarkes) ? remarkes : tableName;
            ArrayList<List<String>> fieldList = new ArrayList<List<String>>(64);
            if (!StrUtil.isNotBlank(tableName) || StrUtil.startWithAnyIgnoreCase(tableName.toLowerCase(), this.excludePrefixList) || this.includePrefixList.length > 0 && !StrUtil.startWithAnyIgnoreCase(tableName.toLowerCase(), this.includePrefixList)) continue;
            log.info("...\u8bfb\u53d6 {} \u8868\u7ed3\u6784...", (Object)tableName);
            ResultSet resultSet = this.metaData.getColumns(null, "%", tableName, "%");
            while (resultSet.next()) {
                ArrayList columnList = new ArrayList();
                for (String fieldName : DbConstant.TABLE_RELATION.keySet()) {
                    String column = resultSet.getString(fieldName);
                    if (StrUtil.equalsIgnoreCase(fieldName, "REMARKS") && StrUtil.isBlank(column)) {
                        columnList.add(columnList.get(0));
                        continue;
                    }
                    columnList.add(column);
                }
                fieldList.add(columnList);
            }
            TableInfo tableInfo = TableInfo.builder().tableName(tableName).tableComment(remarkes).title(tableName + "(" + remarkes + ")").fieldList(fieldList).build();
            tableInfoList.add(tableInfo);
        }
        return tableInfoList;
    }
}

