/*
 * Decompiled with CFR 0.152.
 */
package top.tanmw.db2dict.word;

import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.util.List;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJcTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrGeneral;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJcTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STStyleType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tanmw.db2dict.entity.DbConstant;
import top.tanmw.db2dict.entity.TableInfo;
import top.tanmw.db2dict.word.WordConfig;

public class WordUtil {
    private static final Logger log = LoggerFactory.getLogger(WordUtil.class);
    private static XWPFDocument DOCUMENT = new XWPFDocument();

    public void writeTableToWord(List<TableInfo> tableList) throws Exception {
        this.createTableListNormal(tableList);
        for (TableInfo tableInfo : tableList) {
            int index = tableList.indexOf(tableInfo) + 1;
            tableInfo.setTitle(index + ". " + tableInfo.getTitle());
            this.createSimpleTableNormal(tableInfo);
        }
        this.saveDOCUMENT(WordConfig.EXPORT_FILE_PATH);
        log.info("\u6587\u4ef6\u5199\u5165\u6210\u529f.");
        log.info("\u6210\u529f\u5c06\u6587\u4ef6\u4fdd\u5b58\u5728 >>>" + WordConfig.EXPORT_FILE_PATH);
    }

    private void createSimpleTableNormal(TableInfo tableInfo) throws Exception {
        this.addNewPage(BreakType.TEXT_WRAPPING);
        this.setTableTitle(tableInfo.getTitle());
        List<List<String>> fieldList = tableInfo.getFieldList();
        XWPFTable table = this.createTable(fieldList.size(), DbConstant.TABLE_RELATION.size());
        this.setRowText(table, tableInfo);
        this.setFirstRowText(table);
    }

    private void createTableListNormal(List<TableInfo> tableInfoList) throws Exception {
        this.addNewPage(BreakType.TEXT_WRAPPING);
        this.setTableTitle("\u8868\u6e05\u5355");
        XWPFTable table = this.createTable(tableInfoList.size(), DbConstant.TABLE_INFO_RELATION.size());
        Integer count = 0;
        for (TableInfo tableInfo : tableInfoList) {
            this.setRowTableText(table, tableInfo, count);
            Integer n2 = count;
            Integer n3 = count = Integer.valueOf(count + 1);
        }
        this.setTableFirstRowText(table);
    }

    private XWPFTable createTable(int rowNum, int celNum) {
        XWPFTable table = DOCUMENT.createTable(rowNum, celNum);
        CTTbl ttbl = table.getCTTbl();
        CTTblPr tblPr = ttbl.getTblPr() == null ? ttbl.addNewTblPr() : ttbl.getTblPr();
        CTTblWidth tblWidth = tblPr.isSetTblW() ? tblPr.getTblW() : tblPr.addNewTblW();
        CTJcTable cTJc = tblPr.addNewJc();
        cTJc.setVal(STJcTable.Enum.forString("center"));
        tblWidth.setW(new BigInteger("10000"));
        tblWidth.setType(STTblWidth.DXA);
        return table;
    }

    private void setTableTitle(String tableTitle) {
        XWPFParagraph p2 = DOCUMENT.createParagraph();
        WordUtil.addCustomHeadingStyle(DOCUMENT, "\u6807\u9898 2", 2);
        p2.setAlignment(WordConfig.TITLE_ALIGNMENT);
        XWPFRun r2 = p2.createRun();
        p2.setStyle("\u6807\u9898 2");
        r2.setText(tableTitle);
        r2.setBold(true);
        r2.setFontFamily("\u6977\u4f53");
        r2.setFontSize(22);
    }

    private void setFirstRowText(XWPFTable table) {
        XWPFTableRow firstRow = null;
        XWPFTableCell firstCell = null;
        firstRow = table.insertNewTableRow(0);
        firstRow.setHeight(450);
        for (String fieldValue : DbConstant.TABLE_RELATION.values()) {
            firstCell = firstRow.addNewTableCell();
            this.createVSpanCell(firstCell, fieldValue, "C3BED4", 2000, STMerge.RESTART);
        }
    }

    private void setTableFirstRowText(XWPFTable table) {
        XWPFTableRow firstRow = null;
        XWPFTableCell firstCell = null;
        firstRow = table.insertNewTableRow(0);
        firstRow.setHeight(450);
        for (String fieldValue : DbConstant.TABLE_INFO_RELATION.values()) {
            firstCell = firstRow.addNewTableCell();
            this.createVSpanCell(firstCell, fieldValue, "C3BED4", 2000, STMerge.RESTART);
        }
    }

    private void setRowText(XWPFTable table, TableInfo tableInfo) {
        XWPFTableRow firstRow = null;
        XWPFTableCell firstCell = null;
        List<List<String>> fieldList = tableInfo.getFieldList();
        List<String> fieldValues = null;
        int fieldListSize = fieldList.size();
        for (int i2 = 0; i2 < fieldListSize; ++i2) {
            firstRow = table.getRow(i2);
            firstRow.setHeight(380);
            fieldValues = fieldList.get(i2);
            int fieldValuesSize = fieldValues.size();
            for (int j2 = 0; j2 < fieldValuesSize; ++j2) {
                firstCell = firstRow.getCell(j2);
                this.setCellText(firstCell, fieldValues.get(j2), "EEEEFF", 2000);
            }
        }
    }

    private void setRowTableText(XWPFTable table, TableInfo tableInfo, Integer index) {
        XWPFTableRow firstRow = null;
        XWPFTableCell firstCell = null;
        firstRow = table.getRow(index);
        if (firstRow == null) {
            firstRow = table.createRow();
        }
        firstRow.setHeight(380);
        firstCell = firstRow.getCell(0);
        this.setCellText(firstCell, tableInfo.getTableName(), "EEEEFF", 2000);
        firstRow = table.getRow(index);
        if (firstRow == null) {
            firstRow = table.createRow();
        }
        firstRow.setHeight(380);
        firstCell = firstRow.getCell(1);
        this.setCellText(firstCell, tableInfo.getTableComment(), "EEEEFF", 2000);
    }

    private void setCellText(XWPFTableCell cell, String value, String bgcolor, int width) {
        CTTc cttc = cell.getCTTc();
        CTTcPr cellPr = cttc.addNewTcPr();
        cellPr.addNewTcW().setW(BigInteger.valueOf(width));
        cell.setColor(bgcolor);
        XWPFParagraph p2 = this.getXWPFParagraph(WordConfig.ROW_ALIGNMENT, false, "\u6977\u4f53", 10, "FE4C40", value);
        cell.setParagraph(p2);
    }

    private void createVSpanCell(XWPFTableCell cell, String value, String bgcolor, int width, STMerge.Enum stMerge) {
        CTTc cttc = cell.getCTTc();
        CTTcPr cellPr = cttc.addNewTcPr();
        cellPr.addNewTcW().setW(BigInteger.valueOf(width));
        XWPFParagraph p2 = this.getXWPFParagraph(WordConfig.FIRST_ROW_ALIGNMENT, true, "\u9ed1\u4f53", 11, "000000", value);
        cell.setParagraph(p2);
    }

    private XWPFParagraph getXWPFParagraph(ParagraphAlignment alignment, boolean isBold, String fontFamily, int fontSize, String fontColor, String celValue) {
        XWPFDocument doc = new XWPFDocument();
        XWPFParagraph p2 = doc.createParagraph();
        XWPFRun r2 = p2.createRun();
        p2.setAlignment(alignment);
        if (isBold) {
            r2.setBold(isBold);
        }
        r2.setFontFamily(fontFamily);
        r2.setFontSize(fontSize);
        r2.setText(celValue);
        r2.setColor(fontColor);
        return p2;
    }

    private void addNewPage(BreakType breakType) {
        XWPFParagraph xp = DOCUMENT.createParagraph();
        xp.createRun().addBreak(breakType);
    }

    public void saveDOCUMENT(String savePath) throws Exception {
        File file = new File(savePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(savePath);
        DOCUMENT.write(fos);
        fos.close();
    }

    private static void addCustomHeadingStyle(XWPFDocument docxDocument, String strStyleId, int headingLevel) {
        CTStyle ctStyle = CTStyle.Factory.newInstance();
        ctStyle.setStyleId(strStyleId);
        CTString styleName = CTString.Factory.newInstance();
        styleName.setVal(strStyleId);
        ctStyle.setName(styleName);
        CTDecimalNumber indentNumber = CTDecimalNumber.Factory.newInstance();
        indentNumber.setVal(BigInteger.valueOf(headingLevel));
        ctStyle.setUiPriority(indentNumber);
        CTOnOff onoffnull = CTOnOff.Factory.newInstance();
        ctStyle.setUnhideWhenUsed(onoffnull);
        ctStyle.setQFormat(onoffnull);
        CTPPrGeneral ppr = CTPPrGeneral.Factory.newInstance();
        ppr.setOutlineLvl(indentNumber);
        ctStyle.setPPr(ppr);
        XWPFStyle style = new XWPFStyle(ctStyle);
        XWPFStyles styles = docxDocument.createStyles();
        style.setType(STStyleType.PARAGRAPH);
        styles.addStyle(style);
    }
}

