/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ImplicitActionDataBase;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.DependencyDefinition;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class ModelInterpretationContext
extends ContextAwareBase
implements PropertyContainer {
    Stack<Object> objectStack;
    Stack<Model> modelStack;
    Stack<ImplicitActionDataBase> implicitActionDataStack;
    Map<String, Object> objectMap;
    Map<String, String> propertiesMap;
    Map<String, String> importMap;
    private final BeanDescriptionCache beanDescriptionCache;
    final DefaultNestedComponentRegistry defaultNestedComponentRegistry = new DefaultNestedComponentRegistry();
    List<DependencyDefinition> dependencyDefinitionList = new ArrayList<DependencyDefinition>();
    final List<String> startedDependencies = new ArrayList<String>();

    public ModelInterpretationContext(Context context) {
        this.context = context;
        this.objectStack = new Stack();
        this.modelStack = new Stack();
        this.implicitActionDataStack = new Stack();
        this.beanDescriptionCache = new BeanDescriptionCache(context);
        this.objectMap = new HashMap<String, Object>(5);
        this.propertiesMap = new HashMap<String, String>(5);
        this.importMap = new HashMap<String, String>(5);
    }

    public Map<String, Object> getObjectMap() {
        return this.objectMap;
    }

    public void pushModel(Model m3) {
        this.modelStack.push(m3);
    }

    public Model peekModel() {
        return this.modelStack.peek();
    }

    public boolean isModelStackEmpty() {
        return this.modelStack.isEmpty();
    }

    public Model popModel() {
        return this.modelStack.pop();
    }

    public Stack<Object> getObjectStack() {
        return this.objectStack;
    }

    public boolean isObjectStackEmpty() {
        return this.objectStack.isEmpty();
    }

    public Object peekObject() {
        return this.objectStack.peek();
    }

    public void pushObject(Object o2) {
        this.objectStack.push(o2);
    }

    public Object popObject() {
        return this.objectStack.pop();
    }

    public Object getObject(int i2) {
        return this.objectStack.get(i2);
    }

    public BeanDescriptionCache getBeanDescriptionCache() {
        return this.beanDescriptionCache;
    }

    public String subst(String ref) {
        if (ref == null) {
            return null;
        }
        try {
            return OptionHelper.substVars(ref, this, this.context);
        }
        catch (ScanException | IllegalArgumentException e2) {
            this.addError("Problem while parsing [" + ref + "]", e2);
            return ref;
        }
    }

    public void addSubstitutionProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        value = value.trim();
        this.propertiesMap.put(key, value);
    }

    public void addSubstitutionProperties(Properties props) {
        if (props == null) {
            return;
        }
        for (Object keyObject : props.keySet()) {
            String key = (String)keyObject;
            String val = props.getProperty(key);
            this.addSubstitutionProperty(key, val);
        }
    }

    public DefaultNestedComponentRegistry getDefaultNestedComponentRegistry() {
        return this.defaultNestedComponentRegistry;
    }

    public Stack<ImplicitActionDataBase> getImplcitActionDataStack() {
        return this.implicitActionDataStack;
    }

    public void addDependencyDefinition(DependencyDefinition dd) {
        this.dependencyDefinitionList.add(dd);
    }

    public List<DependencyDefinition> getDependencyDefinitions() {
        return Collections.unmodifiableList(this.dependencyDefinitionList);
    }

    public List<String> getDependencyNamesForModel(Model model) {
        for (DependencyDefinition dd : this.dependencyDefinitionList) {
            if (dd.getDependee() != model) continue;
            return Collections.unmodifiableList(dd.dependenciesList);
        }
        return Collections.emptyList();
    }

    public boolean hasDependencies(String name) {
        if (name == null || name.trim().length() == 0) {
            new IllegalArgumentException("Empty dependency name not allowed here");
        }
        for (DependencyDefinition dd : this.dependencyDefinitionList) {
            if (!dd.dependenciesList.contains(name)) continue;
            return true;
        }
        return false;
    }

    public void markStartOfNamedDependency(String name) {
        this.startedDependencies.add(name);
    }

    public boolean isNamedDependencyStarted(String name) {
        return this.startedDependencies.contains(name);
    }

    @Override
    public String getProperty(String key) {
        String v2 = this.propertiesMap.get(key);
        if (v2 != null) {
            return v2;
        }
        return this.context.getProperty(key);
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return new HashMap<String, String>(this.propertiesMap);
    }

    public void addImport(String stem, String fqcn) {
        this.importMap.put(stem, fqcn);
    }

    public String getImport(String stem) {
        if (stem == null) {
            return null;
        }
        String result = this.importMap.get(stem);
        if (result == null) {
            return stem;
        }
        return result;
    }
}

