/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.map;

import cn.hutool.core.map.FuncKeyMap;
import cn.hutool.core.map.MapBuilder;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class CamelCaseMap<K, V>
extends FuncKeyMap<K, V> {
    private static final long serialVersionUID = 4043263744224569870L;

    public CamelCaseMap() {
        this(16);
    }

    public CamelCaseMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CamelCaseMap(Map<? extends K, ? extends V> m3) {
        this(0.75f, m3);
    }

    public CamelCaseMap(float loadFactor, Map<? extends K, ? extends V> m3) {
        this(m3.size(), loadFactor);
        this.putAll(m3);
    }

    public CamelCaseMap(int initialCapacity, float loadFactor) {
        this(MapBuilder.create(new HashMap(initialCapacity, loadFactor)));
    }

    CamelCaseMap(MapBuilder<K, V> emptyMapBuilder) {
        super(emptyMapBuilder.build(), (Function<Object, Object> & Serializable)key -> {
            if (key instanceof CharSequence) {
                key = StrUtil.toCamelCase(key.toString());
            }
            return key;
        });
    }
}

