/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;

public class CardinalSpline
extends ParametricCurve {
    private static final ThreadLocal<SharedData> SHARED_DATA = new ThreadLocal<SharedData>(){

        @Override
        protected SharedData initialValue() {
            return new SharedData();
        }
    };
    private final SharedData sharedData = SHARED_DATA.get();
    private double alpha = 0.5;

    public CardinalSpline(ControlPath cp, GroupIterator gi) {
        super(cp, gi);
    }

    @Override
    protected void eval(double[] p2) {
        double t2 = p2[p2.length - 1];
        double t22 = t2 * t2;
        double t3 = t22 * t2;
        double a2 = 2.0 * t3 - 3.0 * t22 + 1.0;
        double b2 = -2.0 * t3 + 3.0 * t22;
        double c2 = this.alpha * (t3 - 2.0 * t22 + t2);
        double d2 = this.alpha * (t3 - t22);
        for (int i2 = 0; i2 < p2.length - 1; ++i2) {
            p2[i2] = a2 * this.sharedData.pt[1][i2] + b2 * this.sharedData.pt[2][i2] + c2 * (this.sharedData.pt[2][i2] - this.sharedData.pt[0][i2]) + d2 * (this.sharedData.pt[3][i2] - this.sharedData.pt[1][i2]);
        }
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double a2) {
        this.alpha = a2;
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    @Override
    public void appendTo(MultiPath mp) {
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("group iterator not in range");
        }
        if (this.gi.getGroupSize() < 4) {
            throw new IllegalArgumentException("more than 4 groups required");
        }
        this.gi.set(0, 0);
        for (int i2 = 0; i2 < 4; ++i2) {
            ((SharedData)this.sharedData).pt[i2] = this.cp.getPoint(this.gi.next()).getLocation();
        }
        double[] d2 = new double[mp.getDimension() + 1];
        this.eval(d2);
        if (this.connect) {
            mp.lineTo(d2);
        } else {
            mp.moveTo(d2);
        }
        this.gi.set(0, 0);
        while (true) {
            int index_i = this.gi.index_i();
            int count_j = this.gi.count_j();
            for (int i3 = 0; i3 < 4; ++i3) {
                if (!this.gi.hasNext()) {
                    return;
                }
                ((SharedData)this.sharedData).pt[i3] = this.cp.getPoint(this.gi.next()).getLocation();
            }
            this.gi.set(index_i, count_j);
            this.gi.next();
            BinaryCurveApproximationAlgorithm.genPts(this, 0.0, 1.0, mp);
        }
    }

    private static class SharedData {
        private double[][] pt = new double[4][];

        private SharedData() {
        }
    }
}

