/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

public class ValueVector {
    protected int size = 0;
    protected double[] value = null;

    public ValueVector() {
        this.value = new double[2];
    }

    public ValueVector(double[] value, int size) {
        if (value == null) {
            throw new IllegalArgumentException("value array cannot be null.");
        }
        if (size < 0 || size > value.length) {
            throw new IllegalArgumentException("size >= 0 && size <= value.length required");
        }
        this.value = value;
        this.size = size;
    }

    public ValueVector(int initialCapacity) {
        this.value = new double[initialCapacity];
    }

    public int size() {
        return this.size;
    }

    public double get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("required: (index >= 0 && index < size) but: (index = " + index + ", size = " + this.size + ")");
        }
        return this.value[index];
    }

    public void set(double d2, int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("required: (index >= 0 && index < size) but: (index = " + index + ", size = " + this.size + ")");
        }
        this.value[index] = d2;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("required: (index >= 0 && index < size) but: (index = " + index + ", size = " + this.size + ")");
        }
        for (int i2 = index + 1; i2 < this.size; ++i2) {
            this.value[i2 - 1] = this.value[i2];
        }
        --this.size;
    }

    public void add(double d2) {
        this.insert(d2, this.size);
    }

    public void insert(double d2, int index) {
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException("required: (index >= 0 && index <= size) but: (index = " + index + ", size = " + this.size + ")");
        }
        this.ensureCapacity(this.size + 1);
        for (int i2 = this.size; i2 > index; --i2) {
            this.value[i2] = this.value[i2 - 1];
        }
        this.value[index] = d2;
        ++this.size;
    }

    public void ensureCapacity(int capacity) {
        if (this.value.length < capacity) {
            int x2 = 2 * this.value.length;
            if (x2 < capacity) {
                x2 = capacity;
            }
            double[] arr = new double[x2];
            for (int i2 = 0; i2 < this.size; ++i2) {
                arr[i2] = this.value[i2];
            }
            this.value = arr;
        }
    }

    public void trimArray() {
        if (this.size < this.value.length) {
            double[] arr = new double[this.size];
            for (int i2 = 0; i2 < this.size; ++i2) {
                arr[i2] = this.value[i2];
            }
            this.value = arr;
        }
    }
}

