/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.math;

import com.graphbuilder.math.FuncMap;
import com.graphbuilder.math.FuncNode;
import com.graphbuilder.math.OpNode;
import com.graphbuilder.math.TermNode;
import com.graphbuilder.math.ValNode;
import com.graphbuilder.math.VarMap;
import com.graphbuilder.math.VarNode;
import com.graphbuilder.struc.Bag;

public abstract class Expression {
    protected Expression parent = null;

    public abstract double eval(VarMap var1, FuncMap var2);

    public boolean isDescendent(Expression x2) {
        Expression y2 = this;
        while (y2 != null) {
            if (y2 == x2) {
                return true;
            }
            y2 = y2.parent;
        }
        return false;
    }

    public Expression getParent() {
        return this.parent;
    }

    protected void checkBeforeAccept(Expression x2) {
        if (x2 == null) {
            throw new IllegalArgumentException("expression cannot be null");
        }
        if (x2.parent != null) {
            throw new IllegalArgumentException("expression must be removed parent");
        }
        if (this.isDescendent(x2)) {
            throw new IllegalArgumentException("cyclic reference");
        }
    }

    public String[] getVariableNames() {
        return this.getTermNames(true);
    }

    public String[] getFunctionNames() {
        return this.getTermNames(false);
    }

    private String[] getTermNames(boolean varNames) {
        Bag b2 = new Bag();
        Expression.getTermNames(this, b2, varNames);
        String[] arr = new String[b2.size()];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            arr[i2] = (String)b2.get(i2);
        }
        return arr;
    }

    private static void getTermNames(Expression x2, Bag b2, boolean varNames) {
        block4: {
            block5: {
                block3: {
                    if (!(x2 instanceof OpNode)) break block3;
                    OpNode o2 = (OpNode)x2;
                    Expression.getTermNames(o2.leftChild, b2, varNames);
                    Expression.getTermNames(o2.rightChild, b2, varNames);
                    break block4;
                }
                if (!(x2 instanceof VarNode)) break block5;
                if (!varNames) break block4;
                VarNode v2 = (VarNode)x2;
                if (b2.contains(v2.name)) break block4;
                b2.add(v2.name);
                break block4;
            }
            if (x2 instanceof FuncNode) {
                FuncNode f2 = (FuncNode)x2;
                if (!varNames && !b2.contains(f2.name)) {
                    b2.add(f2.name);
                }
                for (int i2 = 0; i2 < f2.numChildren(); ++i2) {
                    Expression.getTermNames(f2.child(i2), b2, varNames);
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Expression.toString(this, sb);
        return sb.toString();
    }

    private static void toString(Expression x2, StringBuffer sb) {
        if (x2 instanceof OpNode) {
            OpNode o2 = (OpNode)x2;
            sb.append("(");
            Expression.toString(o2.leftChild, sb);
            sb.append(o2.getSymbol());
            Expression.toString(o2.rightChild, sb);
            sb.append(")");
        } else if (x2 instanceof TermNode) {
            TermNode t2 = (TermNode)x2;
            if (t2.getNegate()) {
                sb.append("(");
                sb.append("-");
            }
            sb.append(t2.getName());
            if (t2 instanceof FuncNode) {
                FuncNode f2 = (FuncNode)t2;
                sb.append("(");
                if (f2.numChildren() > 0) {
                    Expression.toString(f2.child(0), sb);
                }
                for (int i2 = 1; i2 < f2.numChildren(); ++i2) {
                    sb.append(", ");
                    Expression.toString(f2.child(i2), sb);
                }
                sb.append(")");
            }
            if (t2.getNegate()) {
                sb.append(")");
            }
        } else if (x2 instanceof ValNode) {
            sb.append(((ValNode)x2).val);
        }
    }
}

