/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.math;

import com.graphbuilder.math.AddNode;
import com.graphbuilder.math.DivNode;
import com.graphbuilder.math.Expression;
import com.graphbuilder.math.ExpressionParseException;
import com.graphbuilder.math.FuncNode;
import com.graphbuilder.math.MultNode;
import com.graphbuilder.math.PowNode;
import com.graphbuilder.math.SubNode;
import com.graphbuilder.math.ValNode;
import com.graphbuilder.math.VarNode;
import com.graphbuilder.struc.Stack;

public class ExpressionTree {
    private static int MAX_LENGTH = 10000;

    private ExpressionTree() {
    }

    public static Expression parse(String s2) {
        if (s2 == null) {
            throw new ExpressionParseException("Expression string cannot be null.", -1);
        }
        if (s2.length() > MAX_LENGTH) {
            throw new ExpressionParseException("Expression string is too long.", -1);
        }
        return ExpressionTree.build(s2, 0);
    }

    private static Expression build(String s2, int indexErrorOffset) {
        if (s2.trim().length() == 0) {
            return null;
        }
        Stack s1 = new Stack();
        Stack s22 = new Stack();
        boolean term = true;
        boolean signed = false;
        boolean negate = false;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 == ' ' || c2 == '\t' || c2 == '\n') continue;
            if (term) {
                if (c2 == '(') {
                    if (negate) {
                        throw new ExpressionParseException("Open bracket found after negate.", i2);
                    }
                    s22.push("(");
                    continue;
                }
                if (!(signed || c2 != '+' && c2 != '-')) {
                    signed = true;
                    if (c2 != '-') continue;
                    negate = true;
                    continue;
                }
                if (c2 >= '0' && c2 <= '9' || c2 == '.') {
                    int j2;
                    for (j2 = i2 + 1; j2 < s2.length(); ++j2) {
                        c2 = s2.charAt(j2);
                        if (c2 >= '0' && c2 <= '9' || c2 == '.') {
                            continue;
                        }
                        if (c2 != 'e' && c2 != 'E') break;
                        if (++j2 < s2.length()) {
                            c2 = s2.charAt(j2);
                            if (c2 != '+' && c2 != '-' && (c2 < '0' || c2 > '9')) {
                                throw new ExpressionParseException("Expected digit, plus sign or minus sign but found: " + String.valueOf(c2), j2 + indexErrorOffset);
                            }
                            ++j2;
                        }
                        while (j2 < s2.length() && (c2 = s2.charAt(j2)) >= '0' && c2 <= '9') {
                            ++j2;
                        }
                        break block3;
                    }
                    double d2 = 0.0;
                    String _d = s2.substring(i2, j2);
                    try {
                        d2 = Double.parseDouble(_d);
                    }
                    catch (Throwable t2) {
                        throw new ExpressionParseException("Improperly formatted value: " + _d, i2 + indexErrorOffset);
                    }
                    if (negate) {
                        d2 = -d2;
                    }
                    s1.push(new ValNode(d2));
                    i2 = j2 - 1;
                    negate = false;
                    term = false;
                    signed = false;
                    continue;
                }
                if (c2 != ',' && c2 != ')' && c2 != '^' && c2 != '*' && c2 != '/' && c2 != '+' && c2 != '-') {
                    int j3;
                    for (j3 = i2 + 1; j3 < s2.length() && (c2 = s2.charAt(j3)) != ',' && c2 != ' ' && c2 != '\t' && c2 != '\n' && c2 != '(' && c2 != ')' && c2 != '^' && c2 != '*' && c2 != '/' && c2 != '+' && c2 != '-'; ++j3) {
                    }
                    if (j3 < s2.length()) {
                        int k2 = j3;
                        while ((c2 == ' ' || c2 == '\t' || c2 == '\n') && ++k2 != s2.length()) {
                            c2 = s2.charAt(k2);
                        }
                        if (c2 == '(') {
                            Expression o2;
                            FuncNode fn = new FuncNode(s2.substring(i2, j3), negate);
                            int b2 = 1;
                            int kOld = k2 + 1;
                            while (b2 != 0) {
                                if (++k2 >= s2.length()) {
                                    throw new ExpressionParseException("Missing function close bracket.", i2 + indexErrorOffset);
                                }
                                c2 = s2.charAt(k2);
                                if (c2 == ')') {
                                    --b2;
                                    continue;
                                }
                                if (c2 == '(') {
                                    ++b2;
                                    continue;
                                }
                                if (c2 != ',' || b2 != 1) continue;
                                o2 = ExpressionTree.build(s2.substring(kOld, k2), kOld);
                                if (o2 == null) {
                                    throw new ExpressionParseException("Incomplete function.", kOld + indexErrorOffset);
                                }
                                fn.add(o2);
                                kOld = k2 + 1;
                            }
                            o2 = ExpressionTree.build(s2.substring(kOld, k2), kOld);
                            if (o2 == null) {
                                if (fn.numChildren() > 0) {
                                    throw new ExpressionParseException("Incomplete function.", kOld + indexErrorOffset);
                                }
                            } else {
                                fn.add(o2);
                            }
                            s1.push(fn);
                            i2 = k2;
                        } else {
                            s1.push(new VarNode(s2.substring(i2, j3), negate));
                            i2 = k2 - 1;
                        }
                    } else {
                        s1.push(new VarNode(s2.substring(i2, j3), negate));
                        i2 = j3 - 1;
                    }
                    negate = false;
                    term = false;
                    signed = false;
                    continue;
                }
                throw new ExpressionParseException("Unexpected character: " + String.valueOf(c2), i2 + indexErrorOffset);
            }
            if (c2 == ')') {
                Stack s3 = new Stack();
                Stack s4 = new Stack();
                while (true) {
                    if (s22.isEmpty()) {
                        throw new ExpressionParseException("Missing open bracket.", i2 + indexErrorOffset);
                    }
                    Object o3 = s22.pop();
                    if (o3.equals("(")) break;
                    s3.addToTail(s1.pop());
                    s4.addToTail(o3);
                }
                s3.addToTail(s1.pop());
                s1.push(ExpressionTree.build(s3, s4));
                continue;
            }
            if (c2 == '^' || c2 == '*' || c2 == '/' || c2 == '+' || c2 == '-') {
                term = true;
                s22.push(String.valueOf(c2));
                continue;
            }
            throw new ExpressionParseException("Expected operator or close bracket but found: " + String.valueOf(c2), i2 + indexErrorOffset);
        }
        if (s1.size() != s22.size() + 1) {
            throw new ExpressionParseException("Incomplete expression.", indexErrorOffset + s2.length());
        }
        return ExpressionTree.build(s1, s22);
    }

    private static Expression build(Stack s1, Stack s2) {
        Object o2;
        Object o1;
        Object o3;
        Stack s3 = new Stack();
        Stack s4 = new Stack();
        while (!s2.isEmpty()) {
            o3 = s2.removeTail();
            o1 = s1.removeTail();
            o2 = s1.removeTail();
            if (o3.equals("^")) {
                s1.addToTail(new PowNode((Expression)o1, (Expression)o2));
                continue;
            }
            s1.addToTail(o2);
            s4.push(o3);
            s3.push(o1);
        }
        s3.push(s1.pop());
        while (!s4.isEmpty()) {
            o3 = s4.removeTail();
            o1 = s3.removeTail();
            o2 = s3.removeTail();
            if (o3.equals("*")) {
                s3.addToTail(new MultNode((Expression)o1, (Expression)o2));
                continue;
            }
            if (o3.equals("/")) {
                s3.addToTail(new DivNode((Expression)o1, (Expression)o2));
                continue;
            }
            s3.addToTail(o2);
            s2.push(o3);
            s1.push(o1);
        }
        s1.push(s3.pop());
        while (!s2.isEmpty()) {
            o3 = s2.removeTail();
            o1 = s1.removeTail();
            o2 = s1.removeTail();
            if (o3.equals("+")) {
                s1.addToTail(new AddNode((Expression)o1, (Expression)o2));
                continue;
            }
            if (o3.equals("-")) {
                s1.addToTail(new SubNode((Expression)o1, (Expression)o2));
                continue;
            }
            throw new ExpressionParseException("Unknown operator: " + o3, -1);
        }
        return (Expression)s1.pop();
    }
}

