/*
 * Decompiled with CFR 0.152.
 */
package oracle.nativeimage;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import oracle.jdbc.logging.annotations.DisableTrace;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@DisableTrace
@AutomaticFeature
final class NativeImageFeature
implements Feature {
    private ResourcesRegistry resourcesRegistry;

    NativeImageFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        Class clazz;
        Class clazz2;
        Class clazz3;
        Class clazz4 = beforeAnalysisAccess.findClassByName("oracle.xml.jaxp.JXSAXParserFactory");
        if (clazz4 != null) {
            this.getResourceRegistry().addResourceBundles("oracle.xml.mesg.XMLResourceBundle");
        }
        if ((clazz3 = beforeAnalysisAccess.findClassByName("oracle.security.pki.OraclePKIProvider")) != null) {
            this.registerAll(beforeAnalysisAccess, "oracle.security.pki.OraclePKIProvider");
            this.registerAll(beforeAnalysisAccess, "oracle.security.pki.OracleKeyStoreSpi");
            this.registerAll(beforeAnalysisAccess, "oracle.security.pki.OracleSSOKeyStoreSpi");
            this.registerAll(beforeAnalysisAccess, "oracle.security.pki.ssl.OracleSSLX509TrustManagerFactory14");
            this.registerAll(beforeAnalysisAccess, "oracle.security.pki.ssl.OracleSSLX509KeyManagerFactory14");
            this.getResourceRegistry().addResourceBundles("oracle.security.pki.resources.OraclePKIMsg");
        }
        if ((clazz2 = beforeAnalysisAccess.findClassByName("oracle.security.crypto.core.PKCS12PBE")) != null) {
            this.registerAll(beforeAnalysisAccess, "oracle.security.crypto.core.PKCS12PBE");
            this.registerAll(beforeAnalysisAccess, "oracle.security.crypto.core.SHA");
            this.registerAll(beforeAnalysisAccess, "oracle.security.crypto.core.DES_EDE");
            this.registerAll(beforeAnalysisAccess, "oracle.security.crypto.core.RSAPrivateKey");
            this.registerAll(beforeAnalysisAccess, "oracle.security.crypto.core.RSAPublicKey");
        }
        if ((clazz = beforeAnalysisAccess.findClassByName("oracle.security.crypto.cert.PKCS12")) != null) {
            this.registerAll(beforeAnalysisAccess, "oracle.security.crypto.cert.ext.KeyUsageExtension");
            this.registerAll(beforeAnalysisAccess, "oracle.security.crypto.cert.ext.BasicConstraintsExtension");
            this.registerAll(beforeAnalysisAccess, "oracle.security.crypto.cert.ext.SubjectKeyIDExtension");
            this.registerAll(beforeAnalysisAccess, "oracle.security.crypto.cert.ext.AuthorityKeyIDExtension");
            this.registerAll(beforeAnalysisAccess, "oracle.security.crypto.cert.ext.AuthorityInfoAccessExtension");
            this.registerAll(beforeAnalysisAccess, "oracle.security.crypto.cert.ext.CRLDistPointExtension");
            this.registerAll(beforeAnalysisAccess, "oracle.security.crypto.cert.ext.CertificatePoliciesExtension");
        }
    }

    private void registerAll(Feature.BeforeAnalysisAccess beforeAnalysisAccess, String string) {
        this.registerClass(beforeAnalysisAccess, string);
        this.registerAllConstructor(beforeAnalysisAccess, string);
        this.registerAllMethods(beforeAnalysisAccess, string);
        this.registerAllFields(beforeAnalysisAccess, string);
    }

    private void registerClass(Feature.BeforeAnalysisAccess beforeAnalysisAccess, String string) {
        Class clazz = beforeAnalysisAccess.findClassByName(string);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
        }
    }

    private void registerAllConstructor(Feature.BeforeAnalysisAccess beforeAnalysisAccess, String string) {
        Class clazz = beforeAnalysisAccess.findClassByName(string);
        if (clazz != null) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                RuntimeReflection.register((Executable[])new Executable[]{constructor});
            }
        }
    }

    private void registerAllMethods(Feature.BeforeAnalysisAccess beforeAnalysisAccess, String string) {
        Class clazz = beforeAnalysisAccess.findClassByName(string);
        if (clazz != null) {
            for (Method method : clazz.getMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{method});
            }
        }
    }

    private void registerAllFields(Feature.BeforeAnalysisAccess beforeAnalysisAccess, String string) {
        Class clazz = beforeAnalysisAccess.findClassByName(string);
        if (clazz != null) {
            for (Field field : clazz.getFields()) {
                RuntimeReflection.register((Field[])new Field[]{field});
            }
        }
    }

    private ResourcesRegistry getResourceRegistry() {
        if (this.resourcesRegistry == null) {
            this.resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        }
        return this.resourcesRegistry;
    }
}

