/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import java.util.Arrays;
import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class Gaussian
implements UnivariateDifferentiableFunction,
DifferentiableUnivariateFunction {
    private final double mean;
    private final double is;
    private final double i2s2;
    private final double norm;

    public Gaussian(double norm, double mean, double sigma) throws NotStrictlyPositiveException {
        if (sigma <= 0.0) {
            throw new NotStrictlyPositiveException(sigma);
        }
        this.norm = norm;
        this.mean = mean;
        this.is = 1.0 / sigma;
        this.i2s2 = 0.5 * this.is * this.is;
    }

    public Gaussian(double mean, double sigma) throws NotStrictlyPositiveException {
        this(1.0 / (sigma * FastMath.sqrt(Math.PI * 2)), mean, sigma);
    }

    public Gaussian() {
        this(0.0, 1.0);
    }

    public double value(double x2) {
        return Gaussian.value(x2 - this.mean, this.norm, this.i2s2);
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    private static double value(double xMinusMean, double norm, double i2s2) {
        return norm * FastMath.exp(-xMinusMean * xMinusMean * i2s2);
    }

    public DerivativeStructure value(DerivativeStructure t2) throws DimensionMismatchException {
        double u2 = this.is * (t2.getValue() - this.mean);
        double[] f2 = new double[t2.getOrder() + 1];
        double[] p2 = new double[f2.length];
        p2[0] = 1.0;
        double u22 = u2 * u2;
        double coeff = this.norm * FastMath.exp(-0.5 * u22);
        if (coeff <= Precision.SAFE_MIN) {
            Arrays.fill(f2, 0.0);
        } else {
            f2[0] = coeff;
            for (int n2 = 1; n2 < f2.length; ++n2) {
                double v2 = 0.0;
                p2[n2] = -p2[n2 - 1];
                for (int k2 = n2; k2 >= 0; k2 -= 2) {
                    v2 = v2 * u22 + p2[k2];
                    if (k2 > 2) {
                        p2[k2 - 2] = (double)(k2 - 1) * p2[k2 - 1] - p2[k2 - 3];
                        continue;
                    }
                    if (k2 != 2) continue;
                    p2[0] = p2[1];
                }
                if ((n2 & 1) == 1) {
                    v2 *= u2;
                }
                f2[n2] = (coeff *= this.is) * v2;
            }
        }
        return t2.compose(f2);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        public double value(double x2, double ... param) throws NullArgumentException, DimensionMismatchException, NotStrictlyPositiveException {
            this.validateParameters(param);
            double diff = x2 - param[1];
            double i2s2 = 1.0 / (2.0 * param[2] * param[2]);
            return Gaussian.value(diff, param[0], i2s2);
        }

        public double[] gradient(double x2, double ... param) throws NullArgumentException, DimensionMismatchException, NotStrictlyPositiveException {
            this.validateParameters(param);
            double norm = param[0];
            double diff = x2 - param[1];
            double sigma = param[2];
            double i2s2 = 1.0 / (2.0 * sigma * sigma);
            double n2 = Gaussian.value(diff, 1.0, i2s2);
            double m3 = norm * n2 * 2.0 * i2s2 * diff;
            double s2 = m3 * diff / sigma;
            return new double[]{n2, m3, s2};
        }

        private void validateParameters(double[] param) throws NullArgumentException, DimensionMismatchException, NotStrictlyPositiveException {
            if (param == null) {
                throw new NullArgumentException();
            }
            if (param.length != 3) {
                throw new DimensionMismatchException(param.length, 3);
            }
            if (param[2] <= 0.0) {
                throw new NotStrictlyPositiveException(param[2]);
            }
        }
    }
}

