/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.FastMath;

public class HarmonicOscillator
implements UnivariateDifferentiableFunction,
DifferentiableUnivariateFunction {
    private final double amplitude;
    private final double omega;
    private final double phase;

    public HarmonicOscillator(double amplitude, double omega, double phase) {
        this.amplitude = amplitude;
        this.omega = omega;
        this.phase = phase;
    }

    public double value(double x2) {
        return HarmonicOscillator.value(this.omega * x2 + this.phase, this.amplitude);
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    private static double value(double xTimesOmegaPlusPhase, double amplitude) {
        return amplitude * FastMath.cos(xTimesOmegaPlusPhase);
    }

    public DerivativeStructure value(DerivativeStructure t2) throws DimensionMismatchException {
        double x2 = t2.getValue();
        double[] f2 = new double[t2.getOrder() + 1];
        double alpha = this.omega * x2 + this.phase;
        f2[0] = this.amplitude * FastMath.cos(alpha);
        if (f2.length > 1) {
            f2[1] = -this.amplitude * this.omega * FastMath.sin(alpha);
            double mo2 = -this.omega * this.omega;
            for (int i2 = 2; i2 < f2.length; ++i2) {
                f2[i2] = mo2 * f2[i2 - 2];
            }
        }
        return t2.compose(f2);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        public double value(double x2, double ... param) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(param);
            return HarmonicOscillator.value(x2 * param[1] + param[2], param[0]);
        }

        public double[] gradient(double x2, double ... param) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(param);
            double amplitude = param[0];
            double omega = param[1];
            double phase = param[2];
            double xTimesOmegaPlusPhase = omega * x2 + phase;
            double a2 = HarmonicOscillator.value(xTimesOmegaPlusPhase, 1.0);
            double p2 = -amplitude * FastMath.sin(xTimesOmegaPlusPhase);
            double w2 = p2 * x2;
            return new double[]{a2, w2, p2};
        }

        private void validateParameters(double[] param) throws NullArgumentException, DimensionMismatchException {
            if (param == null) {
                throw new NullArgumentException();
            }
            if (param.length != 3) {
                throw new DimensionMismatchException(param.length, 3);
            }
        }
    }
}

