/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.analysis.function.Sqrt;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.NonSquareOperatorException;
import org.apache.commons.math3.linear.RealLinearOperator;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.MathArrays;

public class JacobiPreconditioner
extends RealLinearOperator {
    private final ArrayRealVector diag;

    public JacobiPreconditioner(double[] diag, boolean deep) {
        this.diag = new ArrayRealVector(diag, deep);
    }

    public static JacobiPreconditioner create(RealLinearOperator a2) throws NonSquareOperatorException {
        int n2 = a2.getColumnDimension();
        if (a2.getRowDimension() != n2) {
            throw new NonSquareOperatorException(a2.getRowDimension(), n2);
        }
        double[] diag = new double[n2];
        if (a2 instanceof AbstractRealMatrix) {
            AbstractRealMatrix m3 = (AbstractRealMatrix)a2;
            for (int i2 = 0; i2 < n2; ++i2) {
                diag[i2] = m3.getEntry(i2, i2);
            }
        } else {
            ArrayRealVector x2 = new ArrayRealVector(n2);
            for (int i3 = 0; i3 < n2; ++i3) {
                x2.set(0.0);
                x2.setEntry(i3, 1.0);
                diag[i3] = a2.operate(x2).getEntry(i3);
            }
        }
        return new JacobiPreconditioner(diag, false);
    }

    public int getColumnDimension() {
        return this.diag.getDimension();
    }

    public int getRowDimension() {
        return this.diag.getDimension();
    }

    public RealVector operate(RealVector x2) {
        return new ArrayRealVector(MathArrays.ebeDivide(x2.toArray(), this.diag.toArray()), false);
    }

    public RealLinearOperator sqrt() {
        final ArrayRealVector sqrtDiag = this.diag.map(new Sqrt());
        return new RealLinearOperator(){

            public RealVector operate(RealVector x2) {
                return new ArrayRealVector(MathArrays.ebeDivide(x2.toArray(), sqrtDiag.toArray()), false);
            }

            public int getRowDimension() {
                return sqrtDiag.getDimension();
            }

            public int getColumnDimension() {
                return sqrtDiag.getDimension();
            }
        };
    }
}

