/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class SingularValueDecomposition {
    private static final double EPS = 2.220446049250313E-16;
    private static final double TINY = 1.6033346880071782E-291;
    private final double[] singularValues;
    private final int m;
    private final int n;
    private final boolean transposed;
    private final RealMatrix cachedU;
    private RealMatrix cachedUt;
    private RealMatrix cachedS;
    private final RealMatrix cachedV;
    private RealMatrix cachedVt;
    private final double tol;

    public SingularValueDecomposition(RealMatrix matrix) {
        int i2;
        double t2;
        int k2;
        int j2;
        double[][] A2;
        if (matrix.getRowDimension() < matrix.getColumnDimension()) {
            this.transposed = true;
            A2 = matrix.transpose().getData();
            this.m = matrix.getColumnDimension();
            this.n = matrix.getRowDimension();
        } else {
            this.transposed = false;
            A2 = matrix.getData();
            this.m = matrix.getRowDimension();
            this.n = matrix.getColumnDimension();
        }
        this.singularValues = new double[this.n];
        double[][] U = new double[this.m][this.n];
        double[][] V = new double[this.n][this.n];
        double[] e2 = new double[this.n];
        double[] work = new double[this.m];
        int nct = FastMath.min(this.m - 1, this.n);
        int nrt = FastMath.max(0, this.n - 2);
        for (int k3 = 0; k3 < FastMath.max(nct, nrt); ++k3) {
            int i3;
            int i4;
            if (k3 < nct) {
                this.singularValues[k3] = 0.0;
                for (i4 = k3; i4 < this.m; ++i4) {
                    this.singularValues[k3] = FastMath.hypot(this.singularValues[k3], A2[i4][k3]);
                }
                if (this.singularValues[k3] != 0.0) {
                    if (A2[k3][k3] < 0.0) {
                        this.singularValues[k3] = -this.singularValues[k3];
                    }
                    for (i4 = k3; i4 < this.m; ++i4) {
                        double[] dArray = A2[i4];
                        int n2 = k3;
                        dArray[n2] = dArray[n2] / this.singularValues[k3];
                    }
                    double[] dArray = A2[k3];
                    int n3 = k3;
                    dArray[n3] = dArray[n3] + 1.0;
                }
                this.singularValues[k3] = -this.singularValues[k3];
            }
            for (j2 = k3 + 1; j2 < this.n; ++j2) {
                if (k3 < nct && this.singularValues[k3] != 0.0) {
                    double t3 = 0.0;
                    for (i3 = k3; i3 < this.m; ++i3) {
                        t3 += A2[i3][k3] * A2[i3][j2];
                    }
                    t3 = -t3 / A2[k3][k3];
                    for (i3 = k3; i3 < this.m; ++i3) {
                        double[] dArray = A2[i3];
                        int n4 = j2;
                        dArray[n4] = dArray[n4] + t3 * A2[i3][k3];
                    }
                }
                e2[j2] = A2[k3][j2];
            }
            if (k3 < nct) {
                for (i4 = k3; i4 < this.m; ++i4) {
                    U[i4][k3] = A2[i4][k3];
                }
            }
            if (k3 >= nrt) continue;
            e2[k3] = 0.0;
            for (i4 = k3 + 1; i4 < this.n; ++i4) {
                e2[k3] = FastMath.hypot(e2[k3], e2[i4]);
            }
            if (e2[k3] != 0.0) {
                if (e2[k3 + 1] < 0.0) {
                    e2[k3] = -e2[k3];
                }
                i4 = k3 + 1;
                while (i4 < this.n) {
                    int n5 = i4++;
                    e2[n5] = e2[n5] / e2[k3];
                }
                int n6 = k3 + 1;
                e2[n6] = e2[n6] + 1.0;
            }
            e2[k3] = -e2[k3];
            if (k3 + 1 < this.m && e2[k3] != 0.0) {
                for (i4 = k3 + 1; i4 < this.m; ++i4) {
                    work[i4] = 0.0;
                }
                for (j2 = k3 + 1; j2 < this.n; ++j2) {
                    for (int i5 = k3 + 1; i5 < this.m; ++i5) {
                        int n7 = i5;
                        work[n7] = work[n7] + e2[j2] * A2[i5][j2];
                    }
                }
                for (j2 = k3 + 1; j2 < this.n; ++j2) {
                    double t4 = -e2[j2] / e2[k3 + 1];
                    for (i3 = k3 + 1; i3 < this.m; ++i3) {
                        double[] dArray = A2[i3];
                        int n8 = j2;
                        dArray[n8] = dArray[n8] + t4 * work[i3];
                    }
                }
            }
            for (i4 = k3 + 1; i4 < this.n; ++i4) {
                V[i4][k3] = e2[i4];
            }
        }
        int p2 = this.n;
        if (nct < this.n) {
            this.singularValues[nct] = A2[nct][nct];
        }
        if (this.m < p2) {
            this.singularValues[p2 - 1] = 0.0;
        }
        if (nrt + 1 < p2) {
            e2[nrt] = A2[nrt][p2 - 1];
        }
        e2[p2 - 1] = 0.0;
        for (j2 = nct; j2 < this.n; ++j2) {
            for (int i6 = 0; i6 < this.m; ++i6) {
                U[i6][j2] = 0.0;
            }
            U[j2][j2] = 1.0;
        }
        for (k2 = nct - 1; k2 >= 0; --k2) {
            int i7;
            if (this.singularValues[k2] != 0.0) {
                for (int j3 = k2 + 1; j3 < this.n; ++j3) {
                    t2 = 0.0;
                    for (i2 = k2; i2 < this.m; ++i2) {
                        t2 += U[i2][k2] * U[i2][j3];
                    }
                    t2 = -t2 / U[k2][k2];
                    for (i2 = k2; i2 < this.m; ++i2) {
                        double[] dArray = U[i2];
                        int n9 = j3;
                        dArray[n9] = dArray[n9] + t2 * U[i2][k2];
                    }
                }
                for (i7 = k2; i7 < this.m; ++i7) {
                    U[i7][k2] = -U[i7][k2];
                }
                U[k2][k2] = 1.0 + U[k2][k2];
                for (i7 = 0; i7 < k2 - 1; ++i7) {
                    U[i7][k2] = 0.0;
                }
                continue;
            }
            for (i7 = 0; i7 < this.m; ++i7) {
                U[i7][k2] = 0.0;
            }
            U[k2][k2] = 1.0;
        }
        for (k2 = this.n - 1; k2 >= 0; --k2) {
            if (k2 < nrt && e2[k2] != 0.0) {
                for (int j4 = k2 + 1; j4 < this.n; ++j4) {
                    t2 = 0.0;
                    for (i2 = k2 + 1; i2 < this.n; ++i2) {
                        t2 += V[i2][k2] * V[i2][j4];
                    }
                    t2 = -t2 / V[k2 + 1][k2];
                    for (i2 = k2 + 1; i2 < this.n; ++i2) {
                        double[] dArray = V[i2];
                        int n10 = j4;
                        dArray[n10] = dArray[n10] + t2 * V[i2][k2];
                    }
                }
            }
            for (int i8 = 0; i8 < this.n; ++i8) {
                V[i8][k2] = 0.0;
            }
            V[k2][k2] = 1.0;
        }
        int pp = p2 - 1;
        block34: while (p2 > 0) {
            int kase;
            int k4;
            for (k4 = p2 - 2; k4 >= 0; --k4) {
                double threshold = 1.6033346880071782E-291 + 2.220446049250313E-16 * (FastMath.abs(this.singularValues[k4]) + FastMath.abs(this.singularValues[k4 + 1]));
                if (FastMath.abs(e2[k4]) > threshold) continue;
                e2[k4] = 0.0;
                break;
            }
            if (k4 == p2 - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p2 - 1; ks >= k4 && ks != k4; --ks) {
                    double t5 = (ks != p2 ? FastMath.abs(e2[ks]) : 0.0) + (ks != k4 + 1 ? FastMath.abs(e2[ks - 1]) : 0.0);
                    if (!(FastMath.abs(this.singularValues[ks]) <= 1.6033346880071782E-291 + 2.220446049250313E-16 * t5)) continue;
                    this.singularValues[ks] = 0.0;
                    break;
                }
                if (ks == k4) {
                    kase = 3;
                } else if (ks == p2 - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k4 = ks;
                }
            }
            ++k4;
            switch (kase) {
                case 1: {
                    int i9;
                    double sn;
                    double cs;
                    double t6;
                    double f2 = e2[p2 - 2];
                    e2[p2 - 2] = 0.0;
                    for (int j5 = p2 - 2; j5 >= k4; --j5) {
                        t6 = FastMath.hypot(this.singularValues[j5], f2);
                        cs = this.singularValues[j5] / t6;
                        sn = f2 / t6;
                        this.singularValues[j5] = t6;
                        if (j5 != k4) {
                            f2 = -sn * e2[j5 - 1];
                            e2[j5 - 1] = cs * e2[j5 - 1];
                        }
                        for (i9 = 0; i9 < this.n; ++i9) {
                            t6 = cs * V[i9][j5] + sn * V[i9][p2 - 1];
                            V[i9][p2 - 1] = -sn * V[i9][j5] + cs * V[i9][p2 - 1];
                            V[i9][j5] = t6;
                        }
                    }
                    continue block34;
                }
                case 2: {
                    int i9;
                    double sn;
                    double cs;
                    double t6;
                    double f3 = e2[k4 - 1];
                    e2[k4 - 1] = 0.0;
                    for (int j6 = k4; j6 < p2; ++j6) {
                        t6 = FastMath.hypot(this.singularValues[j6], f3);
                        cs = this.singularValues[j6] / t6;
                        sn = f3 / t6;
                        this.singularValues[j6] = t6;
                        f3 = -sn * e2[j6];
                        e2[j6] = cs * e2[j6];
                        for (i9 = 0; i9 < this.m; ++i9) {
                            t6 = cs * U[i9][j6] + sn * U[i9][k4 - 1];
                            U[i9][k4 - 1] = -sn * U[i9][j6] + cs * U[i9][k4 - 1];
                            U[i9][j6] = t6;
                        }
                    }
                    continue block34;
                }
                case 3: {
                    double maxPm1Pm2 = FastMath.max(FastMath.abs(this.singularValues[p2 - 1]), FastMath.abs(this.singularValues[p2 - 2]));
                    double scale = FastMath.max(FastMath.max(FastMath.max(maxPm1Pm2, FastMath.abs(e2[p2 - 2])), FastMath.abs(this.singularValues[k4])), FastMath.abs(e2[k4]));
                    double sp = this.singularValues[p2 - 1] / scale;
                    double spm1 = this.singularValues[p2 - 2] / scale;
                    double epm1 = e2[p2 - 2] / scale;
                    double sk = this.singularValues[k4] / scale;
                    double ek = e2[k4] / scale;
                    double b2 = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c2 = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b2 != 0.0 || c2 != 0.0) {
                        shift = FastMath.sqrt(b2 * b2 + c2);
                        if (b2 < 0.0) {
                            shift = -shift;
                        }
                        shift = c2 / (b2 + shift);
                    }
                    double f4 = (sk + sp) * (sk - sp) + shift;
                    double g2 = sk * ek;
                    for (int j7 = k4; j7 < p2 - 1; ++j7) {
                        int i10;
                        double t7 = FastMath.hypot(f4, g2);
                        double cs = f4 / t7;
                        double sn = g2 / t7;
                        if (j7 != k4) {
                            e2[j7 - 1] = t7;
                        }
                        f4 = cs * this.singularValues[j7] + sn * e2[j7];
                        e2[j7] = cs * e2[j7] - sn * this.singularValues[j7];
                        g2 = sn * this.singularValues[j7 + 1];
                        this.singularValues[j7 + 1] = cs * this.singularValues[j7 + 1];
                        for (i10 = 0; i10 < this.n; ++i10) {
                            t7 = cs * V[i10][j7] + sn * V[i10][j7 + 1];
                            V[i10][j7 + 1] = -sn * V[i10][j7] + cs * V[i10][j7 + 1];
                            V[i10][j7] = t7;
                        }
                        t7 = FastMath.hypot(f4, g2);
                        cs = f4 / t7;
                        sn = g2 / t7;
                        this.singularValues[j7] = t7;
                        f4 = cs * e2[j7] + sn * this.singularValues[j7 + 1];
                        this.singularValues[j7 + 1] = -sn * e2[j7] + cs * this.singularValues[j7 + 1];
                        g2 = sn * e2[j7 + 1];
                        e2[j7 + 1] = cs * e2[j7 + 1];
                        if (j7 >= this.m - 1) continue;
                        for (i10 = 0; i10 < this.m; ++i10) {
                            t7 = cs * U[i10][j7] + sn * U[i10][j7 + 1];
                            U[i10][j7 + 1] = -sn * U[i10][j7] + cs * U[i10][j7 + 1];
                            U[i10][j7] = t7;
                        }
                    }
                    e2[p2 - 2] = f4;
                    break;
                }
                default: {
                    if (this.singularValues[k4] <= 0.0) {
                        this.singularValues[k4] = this.singularValues[k4] < 0.0 ? -this.singularValues[k4] : 0.0;
                        for (int i11 = 0; i11 <= pp; ++i11) {
                            V[i11][k4] = -V[i11][k4];
                        }
                    }
                    while (k4 < pp && !(this.singularValues[k4] >= this.singularValues[k4 + 1])) {
                        int i12;
                        double t8 = this.singularValues[k4];
                        this.singularValues[k4] = this.singularValues[k4 + 1];
                        this.singularValues[k4 + 1] = t8;
                        if (k4 < this.n - 1) {
                            for (i12 = 0; i12 < this.n; ++i12) {
                                t8 = V[i12][k4 + 1];
                                V[i12][k4 + 1] = V[i12][k4];
                                V[i12][k4] = t8;
                            }
                        }
                        if (k4 < this.m - 1) {
                            for (i12 = 0; i12 < this.m; ++i12) {
                                t8 = U[i12][k4 + 1];
                                U[i12][k4 + 1] = U[i12][k4];
                                U[i12][k4] = t8;
                            }
                        }
                        ++k4;
                    }
                    --p2;
                }
            }
        }
        this.tol = FastMath.max((double)this.m * this.singularValues[0] * 2.220446049250313E-16, FastMath.sqrt(Precision.SAFE_MIN));
        if (!this.transposed) {
            this.cachedU = MatrixUtils.createRealMatrix(U);
            this.cachedV = MatrixUtils.createRealMatrix(V);
        } else {
            this.cachedU = MatrixUtils.createRealMatrix(V);
            this.cachedV = MatrixUtils.createRealMatrix(U);
        }
    }

    public RealMatrix getU() {
        return this.cachedU;
    }

    public RealMatrix getUT() {
        if (this.cachedUt == null) {
            this.cachedUt = this.getU().transpose();
        }
        return this.cachedUt;
    }

    public RealMatrix getS() {
        if (this.cachedS == null) {
            this.cachedS = MatrixUtils.createRealDiagonalMatrix(this.singularValues);
        }
        return this.cachedS;
    }

    public double[] getSingularValues() {
        return (double[])this.singularValues.clone();
    }

    public RealMatrix getV() {
        return this.cachedV;
    }

    public RealMatrix getVT() {
        if (this.cachedVt == null) {
            this.cachedVt = this.getV().transpose();
        }
        return this.cachedVt;
    }

    public RealMatrix getCovariance(double minSingularValue) {
        int dimension;
        int p2 = this.singularValues.length;
        for (dimension = 0; dimension < p2 && this.singularValues[dimension] >= minSingularValue; ++dimension) {
        }
        if (dimension == 0) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.TOO_LARGE_CUTOFF_SINGULAR_VALUE, (Number)minSingularValue, this.singularValues[0], true);
        }
        final double[][] data = new double[dimension][p2];
        this.getVT().walkInOptimizedOrder(new DefaultRealMatrixPreservingVisitor(){

            public void visit(int row, int column, double value) {
                data[row][column] = value / SingularValueDecomposition.this.singularValues[row];
            }
        }, 0, dimension - 1, 0, p2 - 1);
        Array2DRowRealMatrix jv = new Array2DRowRealMatrix(data, false);
        return jv.transpose().multiply(jv);
    }

    public double getNorm() {
        return this.singularValues[0];
    }

    public double getConditionNumber() {
        return this.singularValues[0] / this.singularValues[this.n - 1];
    }

    public double getInverseConditionNumber() {
        return this.singularValues[this.n - 1] / this.singularValues[0];
    }

    public int getRank() {
        int r2 = 0;
        for (int i2 = 0; i2 < this.singularValues.length; ++i2) {
            if (!(this.singularValues[i2] > this.tol)) continue;
            ++r2;
        }
        return r2;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.singularValues, this.getUT(), this.getV(), this.getRank() == this.m, this.tol);
    }

    private static class Solver
    implements DecompositionSolver {
        private final RealMatrix pseudoInverse;
        private boolean nonSingular;

        private Solver(double[] singularValues, RealMatrix uT, RealMatrix v2, boolean nonSingular, double tol) {
            double[][] suT = uT.getData();
            for (int i2 = 0; i2 < singularValues.length; ++i2) {
                double a2 = singularValues[i2] > tol ? 1.0 / singularValues[i2] : 0.0;
                double[] suTi = suT[i2];
                int j2 = 0;
                while (j2 < suTi.length) {
                    int n2 = j2++;
                    suTi[n2] = suTi[n2] * a2;
                }
            }
            this.pseudoInverse = v2.multiply(new Array2DRowRealMatrix(suT, false));
            this.nonSingular = nonSingular;
        }

        public RealVector solve(RealVector b2) {
            return this.pseudoInverse.operate(b2);
        }

        public RealMatrix solve(RealMatrix b2) {
            return this.pseudoInverse.multiply(b2);
        }

        public boolean isNonSingular() {
            return this.nonSingular;
        }

        public RealMatrix getInverse() {
            return this.pseudoInverse;
        }
    }
}

