/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.sofm.util;

import org.apache.commons.math3.analysis.function.Logistic;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;

public class QuasiSigmoidDecayFunction {
    private final Logistic sigmoid;
    private final double scale;

    public QuasiSigmoidDecayFunction(double initValue, double slope, long numCall) {
        if (initValue <= 0.0) {
            throw new NotStrictlyPositiveException(initValue);
        }
        if (slope >= 0.0) {
            throw new NumberIsTooLargeException(slope, (Number)0, false);
        }
        if (numCall <= 1L) {
            throw new NotStrictlyPositiveException(numCall);
        }
        double k2 = initValue;
        double m3 = numCall;
        double b2 = 4.0 * slope / initValue;
        double q2 = 1.0;
        double a2 = 0.0;
        double n2 = 1.0;
        this.sigmoid = new Logistic(k2, m3, b2, 1.0, 0.0, 1.0);
        double y0 = this.sigmoid.value(0.0);
        this.scale = k2 / y0;
    }

    public double value(long numCall) {
        return this.scale * this.sigmoid.value(numCall);
    }
}

