/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw.geom;

import java.util.regex.Pattern;
import org.apache.poi.sl.draw.geom.Context;
import org.apache.poi.sl.draw.geom.Formula;

public interface GuideIf
extends Formula {
    public static final Pattern WHITESPACE = Pattern.compile("\\s+");

    public String getName();

    public void setName(String var1);

    public String getFmla();

    public void setFmla(String var1);

    @Override
    default public double evaluate(Context ctx) {
        return this.evaluateGuide(ctx);
    }

    default public double evaluateGuide(Context ctx) {
        Op op;
        String[] operands = WHITESPACE.split(this.getFmla());
        switch (operands[0]) {
            case "*/": {
                op = Op.muldiv;
                break;
            }
            case "+-": {
                op = Op.addsub;
                break;
            }
            case "+/": {
                op = Op.adddiv;
                break;
            }
            case "?:": {
                op = Op.ifelse;
                break;
            }
            default: {
                op = Op.valueOf(operands[0]);
            }
        }
        double x2 = operands.length > 1 ? ctx.getValue(operands[1]) : 0.0;
        double y2 = operands.length > 2 ? ctx.getValue(operands[2]) : 0.0;
        double z2 = operands.length > 3 ? ctx.getValue(operands[3]) : 0.0;
        switch (op) {
            case abs: {
                return Math.abs(x2);
            }
            case adddiv: {
                return z2 == 0.0 ? 0.0 : (x2 + y2) / z2;
            }
            case addsub: {
                return x2 + y2 - z2;
            }
            case at2: {
                return Math.toDegrees(Math.atan2(y2, x2)) * 60000.0;
            }
            case cos: {
                return x2 * Math.cos(Math.toRadians(y2 / 60000.0));
            }
            case cat2: {
                return x2 * Math.cos(Math.atan2(z2, y2));
            }
            case ifelse: {
                return x2 > 0.0 ? y2 : z2;
            }
            case val: {
                return x2;
            }
            case max: {
                return Math.max(x2, y2);
            }
            case min: {
                return Math.min(x2, y2);
            }
            case mod: {
                return Math.sqrt(x2 * x2 + y2 * y2 + z2 * z2);
            }
            case muldiv: {
                return z2 == 0.0 ? 0.0 : x2 * y2 / z2;
            }
            case pin: {
                return Math.max(x2, Math.min(y2, z2));
            }
            case sat2: {
                return x2 * Math.sin(Math.atan2(z2, y2));
            }
            case sin: {
                return x2 * Math.sin(Math.toRadians(y2 / 60000.0));
            }
            case sqrt: {
                return Math.sqrt(x2);
            }
            case tan: {
                return x2 * Math.tan(Math.toRadians(y2 / 60000.0));
            }
        }
        return 0.0;
    }

    public static enum Op {
        muldiv,
        addsub,
        adddiv,
        ifelse,
        val,
        abs,
        sqrt,
        max,
        min,
        at2,
        sin,
        cos,
        tan,
        cat2,
        sat2,
        pin,
        mod;

    }
}

