/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.util.ArrayList;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.FreeRefFunction;

public class Gcd
implements FreeRefFunction {
    public static final Gcd instance = new Gcd();
    private static final long MAX_INPUT = (long)Math.pow(2.0, 53.0);

    @Override
    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        if (args.length < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        if (args.length == 1) {
            try {
                ValueEval v1 = OperandResolver.getSingleValue(args[0], ec.getRowIndex(), ec.getColumnIndex());
                double d2 = OperandResolver.coerceValueToDouble(v1);
                if (this.isInvalidInput(d2)) {
                    return ErrorEval.NUM_ERROR;
                }
                return new NumberEval((long)d2);
            }
            catch (EvaluationException ee) {
                return ErrorEval.VALUE_INVALID;
            }
        }
        try {
            ArrayList<Long> evals = new ArrayList<Long>();
            for (ValueEval arg : args) {
                ValueEval ve = OperandResolver.getSingleValue(arg, ec.getRowIndex(), ec.getColumnIndex());
                double d3 = OperandResolver.coerceValueToDouble(ve);
                if (this.isInvalidInput(d3)) {
                    return ErrorEval.NUM_ERROR;
                }
                evals.add((long)d3);
            }
            long result = (Long)evals.get(0);
            for (int i2 = 1; i2 < evals.size(); ++i2) {
                result = ArithmeticUtils.gcd(result, (Long)evals.get(i2));
            }
            return new NumberEval(result);
        }
        catch (EvaluationException ee) {
            return ErrorEval.VALUE_INVALID;
        }
    }

    private boolean isInvalidInput(double d2) {
        return d2 < 0.0 || d2 > (double)MAX_INPUT;
    }
}

