/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.CacheAreaEval;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.MissingArgEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.ArrayFunction;
import org.apache.poi.ss.formula.functions.Var2or3ArgFunction;

public final class IfFunc
extends Var2or3ArgFunction
implements ArrayFunction {
    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
        boolean b2;
        try {
            b2 = IfFunc.evaluateFirstArg(arg0, srcRowIndex, srcColumnIndex);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
        if (b2) {
            if (arg1 == MissingArgEval.instance) {
                return BlankEval.instance;
            }
            return arg1;
        }
        return BoolEval.FALSE;
    }

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2) {
        boolean b2;
        try {
            b2 = IfFunc.evaluateFirstArg(arg0, srcRowIndex, srcColumnIndex);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
        if (b2) {
            if (arg1 == MissingArgEval.instance) {
                return BlankEval.instance;
            }
            return arg1;
        }
        if (arg2 == MissingArgEval.instance) {
            return BlankEval.instance;
        }
        return arg2;
    }

    public static boolean evaluateFirstArg(ValueEval arg, int srcCellRow, int srcCellCol) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(arg, srcCellRow, srcCellCol);
        Boolean b2 = OperandResolver.coerceValueToBoolean(ve, false);
        if (b2 == null) {
            return false;
        }
        return b2;
    }

    @Override
    public ValueEval evaluateArray(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        if (args.length < 2 || args.length > 3) {
            return ErrorEval.VALUE_INVALID;
        }
        ValueEval arg0 = args[0];
        ValueEval arg1 = args[1];
        BoolEval arg2 = args.length == 2 ? BoolEval.FALSE : args[2];
        return this.evaluateArrayArgs(arg0, arg1, arg2, srcRowIndex, srcColumnIndex);
    }

    ValueEval evaluateArrayArgs(ValueEval arg0, ValueEval arg1, ValueEval arg2, int srcRowIndex, int srcColumnIndex) {
        int h2;
        int w2;
        int h1;
        int w1;
        int a1FirstCol = 0;
        int a1FirstRow = 0;
        if (arg0 instanceof AreaEval) {
            AreaEval ae2 = (AreaEval)arg0;
            w1 = ae2.getWidth();
            h1 = ae2.getHeight();
            a1FirstCol = ae2.getFirstColumn();
            a1FirstRow = ae2.getFirstRow();
        } else if (arg0 instanceof RefEval) {
            RefEval ref = (RefEval)arg0;
            w1 = 1;
            h1 = 1;
            a1FirstCol = ref.getColumn();
            a1FirstRow = ref.getRow();
        } else {
            w1 = 1;
            h1 = 1;
        }
        int a2FirstCol = 0;
        int a2FirstRow = 0;
        if (arg1 instanceof AreaEval) {
            AreaEval ae3 = (AreaEval)arg1;
            w2 = ae3.getWidth();
            h2 = ae3.getHeight();
            a2FirstCol = ae3.getFirstColumn();
            a2FirstRow = ae3.getFirstRow();
        } else if (arg1 instanceof RefEval) {
            RefEval ref = (RefEval)arg1;
            w2 = 1;
            h2 = 1;
            a2FirstCol = ref.getColumn();
            a2FirstRow = ref.getRow();
        } else {
            w2 = 1;
            h2 = 1;
        }
        int a3FirstCol = 0;
        int a3FirstRow = 0;
        if (arg2 instanceof AreaEval) {
            AreaEval ae4 = (AreaEval)arg2;
            a3FirstCol = ae4.getFirstColumn();
            a3FirstRow = ae4.getFirstRow();
        } else if (arg2 instanceof RefEval) {
            RefEval ref = (RefEval)arg2;
            a3FirstCol = ref.getColumn();
            a3FirstRow = ref.getRow();
        }
        int width = Math.max(w1, w2);
        int height = Math.max(h1, h2);
        ValueEval[] vals = new ValueEval[height * width];
        int idx = 0;
        for (int i2 = 0; i2 < height; ++i2) {
            for (int j2 = 0; j2 < width; ++j2) {
                ValueEval vC;
                ValueEval vB;
                ValueEval vA;
                try {
                    vA = OperandResolver.getSingleValue(arg0, a1FirstRow + i2, a1FirstCol + j2);
                }
                catch (FormulaParseException e2) {
                    vA = ErrorEval.NAME_INVALID;
                }
                catch (EvaluationException e3) {
                    vA = e3.getErrorEval();
                }
                try {
                    vB = OperandResolver.getSingleValue(arg1, a2FirstRow + i2, a2FirstCol + j2);
                }
                catch (FormulaParseException e4) {
                    vB = ErrorEval.NAME_INVALID;
                }
                catch (EvaluationException e5) {
                    vB = e5.getErrorEval();
                }
                try {
                    vC = OperandResolver.getSingleValue(arg2, a3FirstRow + i2, a3FirstCol + j2);
                }
                catch (FormulaParseException e6) {
                    vC = ErrorEval.NAME_INVALID;
                }
                catch (EvaluationException e7) {
                    vC = e7.getErrorEval();
                }
                if (vA instanceof ErrorEval) {
                    vals[idx++] = vA;
                    continue;
                }
                try {
                    Boolean b2 = OperandResolver.coerceValueToBoolean(vA, false);
                    vals[idx++] = b2 != null && b2 != false ? vB : vC;
                    continue;
                }
                catch (EvaluationException e8) {
                    vals[idx++] = e8.getErrorEval();
                }
            }
        }
        if (vals.length == 1) {
            return vals[0];
        }
        return new CacheAreaEval(srcRowIndex, srcColumnIndex, srcRowIndex + height - 1, srcColumnIndex + width - 1, vals);
    }
}

